#include "mbed.h"
#include "USBKeyboard.h"

USBKeyboard keyboard;
DigitalIn DI(p5);
bool alternating = true;

//For toggling LEDs 
DigitalOut myled4(LED4);
DigitalOut myled3(LED3);
DigitalOut myled2(LED2);
DigitalOut myled1(LED1);
void lights(bool on_off_state);

int main(void) {
    while (1) {
        //If digital input on pin 5 evaluates to 1, this means the pedal has been hit
        if(DI == 1){
            if(alternating){
                keyboard.keyCode(KEY_F5, 1);    //Ctrl F5 - save the current screen position to F5
                wait(0.1);
                keyboard.keyCode(KEY_F6);       //F6 - go to the F6 screen position
            }else{
                keyboard.keyCode(KEY_F6, 1);    //Ctrl F6 - save the current screen position to F6
                wait(0.1);
                keyboard.keyCode(KEY_F5);       //F5 - go to F5 screen position
            }
            lights(alternating);
            alternating = !alternating;
        }
        wait(0.0002);
    }
}



void lights(bool on_off_state){
    myled1 = (int)on_off_state;
    myled2 = (int)on_off_state;
    myled3 = (int)on_off_state;
    myled4 = (int)on_off_state;
}