#include <vector>
#include <string>
#include <cstdlib>
#include <iostream>
#include <iomanip>
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Hand.h"
#include "PinDetect.h"
using namespace std;
//mbed declarations
Serial pc(USBTX, USBRX);
uLCD_4DGL lcd(p28, p27, p30);
DigitalIn pb1(p12);
DigitalIn pb2(p15);
DigitalIn pb3(p16);
DigitalIn pb4(p17);
DigitalIn pb5(p19);
DigitalIn pb6(p20);
DigitalIn pb7(p21);
DigitalIn pb8(p23);
//draw player hand
void drawPlayerHand()
{
    lcd.locate(lcd.max_col/4,0);
    lcd.printf("Dealer: ");

    lcd.locate(lcd.max_col/4,lcd.max_row/2);
    lcd.printf("Player: ");

    lcd.filled_rectangle(0,76,20,110,BLUE);
    lcd.filled_rectangle(23,76,43,110,BLUE);
}
//draw player hit cards
void drawPlayerHit(int count)
{
    switch(count) {
        case 1:
            lcd.filled_rectangle(46,76,66,110,BLUE);
            break;
        case 2:
            lcd.filled_rectangle(69,76,89,110,BLUE);
            break;
        case 3:
            lcd.filled_rectangle(92,76,112,110,BLUE);
            break;
    }
}
//draw card for dealer hand
void drawDealerHand()
{
    lcd.filled_rectangle(0,16,20,50,RED);
    lcd.filled_rectangle(23,16,43,50,RED);
}
//draw card for dealer hit
void drawDealerHit(int count2)
{
    switch(count2) {
        case 1:
            lcd.filled_rectangle(46,16,66,50,RED);
            break;
        case 2:
            lcd.filled_rectangle(69,16,89,50,RED);
            break;
        case 3:
            lcd.filled_rectangle(92,16,112,50,RED);
            break;
    }
}
//draw background
void drawTable()
{
    lcd.background_color(POKERGREEN);
    lcd.color(WHITE);
    lcd.cls();
}
//draw text
void drawText(int betVal)
{
    lcd.locate(lcd.max_col/4,lcd.max_row-1);
    lcd.color(WHITE);
    lcd.printf("Bet: %i",betVal);
}
//draw both character player cards
void drawCharacterPlayer(int card1,int card2)
{
    lcd.locate(lcd.max_col/5 - 2,lcd.max_row/2 + 3);
    lcd.printf("%i",card1);
    lcd.locate((lcd.max_col*2)/5 - 3 ,lcd.max_row/2 + 3);
    lcd.printf("%i",card2);
}
//draw dealer character card1
void drawCharDealer(int car1)
{
    lcd.locate(lcd.max_col/5 - 2,lcd.max_row/3 - 1);
    lcd.printf("%i",car1);
}
//draw dealer charcter card2
void drawDealerCard2(int cardvalue)
{
    lcd.locate((lcd.max_col*2)/5 - 3,lcd.max_row/3 - 1);
    lcd.printf("%i",cardvalue);
}
//draw hit cards characters for player
void drawHitChar_player(int cardval, int hit)
{
    switch(hit) {
        case 1:
            lcd.locate((lcd.max_col*2)/5,lcd.max_row/2 + 3);
            lcd.printf("%i",cardval);
            break;
        case 2:
            lcd.locate((lcd.max_col*3)/5 + 1 ,lcd.max_row/2 + 3);
            lcd.printf("%i",cardval);
            break;
        case 3:
            lcd.locate((lcd.max_col*4)/5 + 1 ,lcd.max_row/2 + 3);
            lcd.printf("%i",cardval);
            break;
    }
}
//draw Hit card characters for dealer
void drawHitChar_dealer(int cardv, int hit2)
{
    switch(hit2) {
        case 1:
            lcd.locate((lcd.max_col*2)/5,lcd.max_row/3 - 1);
            lcd.printf("%i",cardv);
            break;
        case 2:
            lcd.locate((lcd.max_col*3)/5 + 1 ,lcd.max_row/3 - 1);
            lcd.printf("%i",cardv);
            break;
        case 3:
            lcd.locate((lcd.max_col*4)/5 + 1 ,lcd.max_row/3 - 1);
            lcd.printf("%i",cardv);
            break;
    }
}

int main()
{
    //stepup and variables
    lcd.baudrate(3000000);
    lcd.cls();
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    pb7.mode(PullUp);
    pb8.mode(PullUp);
    bool overshot = false; // if Player busts
    string action; //Whether player hits, or stands
    int hitCount = 0; //number of hits by player
    int dealerCount = 0; //number of hits by dealer
    int bet = 0; //bet amount
    int round = 1; 
    int i=40;
    int cardArray_player[7];
    int cardArray_dealer[7];
    unsigned int dollars = 500;
    //begin game
    while(1) {
        drawTable();//draws background color
        srand((i)); //change everytime you compile
        i++;
        while (1) {
            wait_ms(1000);
            lcd.cls();
            hitCount = 0; 
            dealerCount = 0; 
            if(dollars == 0) {
                pc.printf("You are broke! Go Home:)\n");
                lcd.locate(lcd.max_col/4,lcd.max_row/2);
                lcd.printf("YOU LOSE");
                wait_ms(10000);
                break;
            }
            Hand Player1("Player");
            Hand Player2("Dealer");
            cout << "Round " << round << endl;
            cout << "Player1 has " << dollars << " Dollars" << endl;
            cout << "Player's hand is: ";
            Player1.printHand();
            for(int a=0; a<2; a++) {
                cardArray_player[a] = Player1.getCardValues(a);
            }
            cout << endl << "Player's hand value is: " << Player1.handValue()<< endl;

            drawPlayerHand();
            drawCharacterPlayer(cardArray_player[0],cardArray_player[1]);
            cout << "Dealer's first card is: ";
            Player2.printFirstCard();
            cout << endl;

            drawDealerHand();
            for(int b=0; b<2; b++) {
                cardArray_dealer[b] = Player2.getCardValues(b);
            }
            drawCharDealer(cardArray_dealer[0]);
            cout << "Select a bet amount. If you want to fold, bet 0 "<< endl<<endl<<endl;

            //Enter pushbutton for bet value
            while(pb1 && pb2 && pb3 && pb4);
            if(!pb1) {
                bet = 0;
            } else if(!pb2) {
                bet = 25;
            } else if(!pb3) {
                bet = 100;
            } else if(!pb4) {
                bet = dollars;
            }

            if (bet == 0) {
                pc.printf("Please leave the table or restart to play again");
                break;
            } else if (bet > dollars && dollars != 0) {
                cout << "You don't have that much money!  Enter a lower bet.";
                wait_ms(200);
                continue;
            }
            drawText(bet);

            while (1) {
                pc.printf("Would you like to hit or stand?\n");
                while(pb5 && pb6);
                if(!pb5) {
                    action = "hit";
                } else if(!pb6) {
                    action = "stand";
                }
                if (action == "hit") {
                    Player1.addCard();
                    hitCount++;
                    cout << endl << "Player's hand value is: " << Player1.handValue()<<endl;
                    Player1.printHand();
                    cout <<endl;
                    drawPlayerHit(hitCount);
                    switch(hitCount) {
                        case 1:
                            cardArray_player[2] = Player1.getCardValues(2);
                            drawHitChar_player(cardArray_player[2],hitCount);
                            break;
                        case 2:
                            cardArray_player[3] = Player1.getCardValues(3);
                            drawHitChar_player(cardArray_player[3],hitCount);
                            break;
                        case 3:
                            cardArray_player[4] = Player1.getCardValues(4);
                            drawHitChar_player(cardArray_player[4],hitCount);
                            break;
                    }
                    cout << endl;

                    if (Player1.handValue() > 21) {

                        cout << "Player's hand is bust " << endl;
                        dollars -= bet;
                        round++;
                        cout << "Player has " << dollars << " dollars" << endl;
                        lcd.cls();
                        lcd.locate(lcd.max_col/4,lcd.max_row/2);
                        lcd.printf("Dealer Wins :()");
                        overshot = true;
                        wait_ms(1000);
                        break;
                    }
                }

                else if (action == "stand") {
                    round++;
                    overshot = false;
                    break;
                }
                wait_ms(500);
            }

            if (!overshot) {
                cout << "Dealer's hand is: ";
                Player2.printHand();
                drawDealerCard2(cardArray_dealer[1]);
                cout << endl << "Dealer's hand value is " << Player2.handValue() << endl;

                while (Player2.handValue() < 17) {
                    dealerCount++;
                    Player2.addCard();
                    cout << "Dealer's hand is: ";
                    Player2.printHand();
                    drawDealerHit(dealerCount);
                    switch(dealerCount) {
                        case 1:
                            cardArray_dealer[2] = Player2.getCardValues(2);
                            drawHitChar_dealer(cardArray_dealer[2],dealerCount);
                            break;
                        case 2:
                            cardArray_dealer[3] = Player2.getCardValues(3);
                            drawHitChar_dealer(cardArray_dealer[3],dealerCount);
                            break;
                        case 3:
                            cardArray_dealer[4] = Player2.getCardValues(4);
                            drawHitChar_dealer(cardArray_dealer[4],dealerCount);
                            break;
                    }
                    cout << endl << "Dealer's hand value is " << Player2.handValue() << endl;
                    wait_ms(600);
                }

                if (Player2.handValue() > 21) {
                    cout << "Dealer's hand is bust.  Player wins!" << endl<<endl;
                    dollars += bet;
                    lcd.cls();
                    lcd.locate(lcd.max_col/4,lcd.max_row/2);
                    lcd.printf("Player Wins!");
                    wait_ms(1000);
                    continue;
                }

                if (Player1.handValue() == Player2.handValue()) {
                    cout << "Draw." << endl;
                    bet = bet / 2;
                    dollars += bet;
                    lcd.cls();
                    lcd.locate(lcd.max_col/4,lcd.max_row/2);
                    lcd.printf("Draw.");
                    wait_ms(1000);
                    continue;
                }

                if (Player1.handValue() < Player2.handValue()) {
                    cout << "Dealer wins." << endl;
                    lcd.cls();
                    lcd.locate(lcd.max_col/4,lcd.max_row/2);
                    lcd.printf("Dealer Wins :(");
                    dollars -= bet;
                    wait_ms(1000);
                    break;
                }

                if (Player1.handValue() > Player2.handValue()) {
                    cout << "Player wins." << endl;
                    dollars += bet;
                    lcd.cls();
                    lcd.locate(lcd.max_col/4,lcd.max_row/2);
                    lcd.printf("Player Wins!");
                    wait_ms(600);
                    continue;
                }
            }
            if(overshot) {
                break;
            }
        }
        wait_ms(400);
        if(dollars != 0) {
            lcd.cls();
            lcd.locate(lcd.max_col/4,lcd.max_row/2);
            lcd.printf("Continue?");
            pc.printf("Continue?\n\n\n");
        } else {
            pc.printf("You Lose");
            lcd.cls();
            lcd.locate(lcd.max_col/4,lcd.max_row/2);
            lcd.printf("YOU LOSE");
            break;
        }
        while(pb7 && pb8);
        if(!pb7) {
            wait_ms(200);
        } else if(!pb8) {
            break;
        }
    }
}