using namespace std;
class Hand
{
private:
    std::vector <std::string> card_types;   // the card names in the hand 
    std::vector <int> card_values;   //  the card values in the hand
    std::string hand_holder;  // either 'Player' or 'Dealer'
    int aceCount;  //  the number of aces, useful for calculating hand value

public:
    explicit Hand(std::string);  // constructor, sets hand_holder and calls addCard twice
    void addCard();  //  adds a randomly chosen card to the hand
    void printHand();  //  prints the card_types vector
    void printFirstCard();  // prints only the first card in the hand (used for dealer)
    int handValue();  // calculates the hand's value
    int getCardValues(int i);
};

Hand::Hand(string player)
{
    hand_holder = player;
    aceCount = 0;
    card_types.clear();
    card_values.clear();
    for(int i = 0; i<2; i++)
    {
        addCard();
    }
    
}
void Hand::addCard()
{
    //card selection was changed
    int cardSelection = 1 + rand() % 13;
    int cardValue = 0;
    string cardType;

    switch (cardSelection)
    {
    case 1:
        cardType = "Ace";
        cardValue = 11;
        aceCount = aceCount + 1;
        break;

    case 2:
        cardType = "King";
        cardValue = 10;
        break;

    case 3:
        cardType = "Queen";
        cardValue = 10;
        break;

    case 4:
        cardType = "Jack";
        cardValue = 10;
        break;

    case 5:
        cardType = "Ten";
        cardValue = 10;
        break;

    case 6:
        cardType = "Two";
        cardValue = 2;
        break;

    case 7:
        cardType = "Three";
        cardValue = 3;
        break;

    case 8:
        cardType = "Four";
        cardValue = 4;
        break;

    case 9:
        cardType = "Five";
        cardValue = 5;
        break;

    case 10:
        cardType = "Six";
        cardValue = 6;
        break;

    case 11:
        cardType = "Seven";
        cardValue = 7;
        break;

    case 12:
        cardType = "Eight";
        cardValue = 8;
        break;

    case 13:
        cardType = "Nine";
        cardValue = 9;
        break;
    }
    card_values.push_back(cardValue);
    card_types.push_back(cardType);
}

int Hand::handValue()
{
    int sumOfCards = 0;

    for (int i = 0; i < card_values.size(); i++)
    {
        sumOfCards = card_values[i] + sumOfCards;
    }

    int numAces = aceCount;

    while ((sumOfCards > 21) && (numAces > 0))
    {
        sumOfCards = sumOfCards - 10;
        numAces--;
    }

    return sumOfCards;
}

void Hand::printHand()
{
    for (int i = 0; i < card_values.size(); i++)
    {
        cout << card_values[i] << " ";
    }
}

int Hand::getCardValues(int i)
{
     return card_values[i];   
}

void Hand::printFirstCard()
{
    cout << card_values[0];
}