/*
 * 640x480 60Hz fullgraphic monochrome VGA Driver demo program
 *
 * Copyright (C) 2011 by Ivo van Poorten <ivop(at)euronet.nl>
 * and Gert van der Knokke <gertk(at)xs4all.nl>
 * This file is licensed under the terms of the GNU Lesser
 * General Public License, version 3.
 *
 * Inspired by Simon's (not Ford) Cookbook entry and Cliff Biffle's
 * assembly code.
 */
 
#include "mbed.h"
#include "vga640x480g.h"

// visual feedback
DigitalOut myled(LED1);

// define serial port for debug
Serial linktopc(USBTX,USBRX);

int main() {
    // init the VGA subsystem (always do this first!)
    init_vga();

    int s,t;

    // serial port on at 115200 baud
    linktopc.baud(115200);
    setbuf(stdout, NULL); // no buffering for this filehandle
    
    
    // clear the screen
    vga_cls();
    
    // draw some circles
    for (t=10; t<200; t+=5)
    vga_circle(20+t,399-t,t,WHITE);

    // draw some boxes
    for (t=10; t<100; t+=5)
    vga_box(400+t,100+t,400+t*2,100+t*2,WHITE);
  
    // circumfence the screen
    vga_box(0,0,639,479,WHITE);
    
    // show the complete character set
    for (s=0; s<4; s++) {
        for (t=0; t<64; t++) {
            vga_putchar(20+t*8,20+16*s,t+s*64,WHITE);
        }
    }

    // put a string on screen
    vga_putstring(400,370,"Hello World!",WHITE);

    // draw some lines
    vga_line(400,390,500,390,WHITE);
    vga_line(500,475,600,375,WHITE);

    // draw a filled box
    vga_filledbox(450,330,550,360,1);

    // draw some more boxes
    for (t=10; t<320; t+=5)
    vga_box(100+t,440-t/16,110+t,440+t/16,WHITE);
    
    
    // all done
    while (1){
         wait(1);
       myled=!myled;
    }
 }
