static struct Z80OpcodeTable opcodes_FDCB = { 1, {
    { LD_B_RLC_off_IY_d   , OP_BYTE  , "LD B,RLC (IY+0%02Xh)", NULL },
    { LD_C_RLC_off_IY_d   , OP_BYTE  , "LD C,RLC (IY+0%02Xh)", NULL },
    { LD_D_RLC_off_IY_d   , OP_BYTE  , "LD D,RLC (IY+0%02Xh)", NULL },
    { LD_E_RLC_off_IY_d   , OP_BYTE  , "LD E,RLC (IY+0%02Xh)", NULL },
    { LD_H_RLC_off_IY_d   , OP_BYTE  , "LD H,RLC (IY+0%02Xh)", NULL },
    { LD_L_RLC_off_IY_d   , OP_BYTE  , "LD L,RLC (IY+0%02Xh)", NULL },
    { RLC_off_IY_d        , OP_BYTE  , "RLC (IY+0%02Xh)"   , NULL },
    { LD_A_RLC_off_IY_d   , OP_BYTE  , "LD A,RLC (IY+0%02Xh)", NULL },
    { LD_B_RRC_off_IY_d   , OP_BYTE  , "LD B,RRC (IY+0%02Xh)", NULL },
    { LD_C_RRC_off_IY_d   , OP_BYTE  , "LD C,RRC (IY+0%02Xh)", NULL },
    { LD_D_RRC_off_IY_d   , OP_BYTE  , "LD D,RRC (IY+0%02Xh)", NULL },
    { LD_E_RRC_off_IY_d   , OP_BYTE  , "LD E,RRC (IY+0%02Xh)", NULL },
    { LD_H_RRC_off_IY_d   , OP_BYTE  , "LD H,RRC (IY+0%02Xh)", NULL },
    { LD_L_RRC_off_IY_d   , OP_BYTE  , "LD L,RRC (IY+0%02Xh)", NULL },
    { RRC_off_IY_d        , OP_BYTE  , "RRC (IY+0%02Xh)"   , NULL },
    { LD_A_RRC_off_IY_d   , OP_BYTE  , "LD A,RRC (IY+0%02Xh)", NULL },
    { LD_B_RL_off_IY_d    , OP_BYTE  , "LD B,RL (IY+0%02Xh)", NULL },
    { LD_C_RL_off_IY_d    , OP_BYTE  , "LD C,RL (IY+0%02Xh)", NULL },
    { LD_D_RL_off_IY_d    , OP_BYTE  , "LD D,RL (IY+0%02Xh)", NULL },
    { LD_E_RL_off_IY_d    , OP_BYTE  , "LD E,RL (IY+0%02Xh)", NULL },
    { LD_H_RL_off_IY_d    , OP_BYTE  , "LD H,RL (IY+0%02Xh)", NULL },
    { LD_L_RL_off_IY_d    , OP_BYTE  , "LD L,RL (IY+0%02Xh)", NULL },
    { RL_off_IY_d         , OP_BYTE  , "RL (IY+0%02Xh)"    , NULL },
    { LD_A_RL_off_IY_d    , OP_BYTE  , "LD A,RL (IY+0%02Xh)", NULL },
    { LD_B_RR_off_IY_d    , OP_BYTE  , "LD B,RR (IY+0%02Xh)", NULL },
    { LD_C_RR_off_IY_d    , OP_BYTE  , "LD C,RR (IY+0%02Xh)", NULL },
    { LD_D_RR_off_IY_d    , OP_BYTE  , "LD D,RR (IY+0%02Xh)", NULL },
    { LD_E_RR_off_IY_d    , OP_BYTE  , "LD E,RR (IY+0%02Xh)", NULL },
    { LD_H_RR_off_IY_d    , OP_BYTE  , "LD H,RR (IY+0%02Xh)", NULL },
    { LD_L_RR_off_IY_d    , OP_BYTE  , "LD L,RR (IY+0%02Xh)", NULL },
    { RR_off_IY_d         , OP_BYTE  , "RR (IY+0%02Xh)"    , NULL },
    { LD_A_RR_off_IY_d    , OP_BYTE  , "LD A,RR (IY+0%02Xh)", NULL },
    { LD_B_SLA_off_IY_d   , OP_BYTE  , "LD B,SLA (IY+0%02Xh)", NULL },
    { LD_C_SLA_off_IY_d   , OP_BYTE  , "LD C,SLA (IY+0%02Xh)", NULL },
    { LD_D_SLA_off_IY_d   , OP_BYTE  , "LD D,SLA (IY+0%02Xh)", NULL },
    { LD_E_SLA_off_IY_d   , OP_BYTE  , "LD E,SLA (IY+0%02Xh)", NULL },
    { LD_H_SLA_off_IY_d   , OP_BYTE  , "LD H,SLA (IY+0%02Xh)", NULL },
    { LD_L_SLA_off_IY_d   , OP_BYTE  , "LD L,SLA (IY+0%02Xh)", NULL },
    { SLA_off_IY_d        , OP_BYTE  , "SLA (IY+0%02Xh)"   , NULL },
    { LD_A_SLA_off_IY_d   , OP_BYTE  , "LD A,SLA (IY+0%02Xh)", NULL },
    { LD_B_SRA_off_IY_d   , OP_BYTE  , "LD B,SRA (IY+0%02Xh)", NULL },
    { LD_C_SRA_off_IY_d   , OP_BYTE  , "LD C,SRA (IY+0%02Xh)", NULL },
    { LD_D_SRA_off_IY_d   , OP_BYTE  , "LD D,SRA (IY+0%02Xh)", NULL },
    { LD_E_SRA_off_IY_d   , OP_BYTE  , "LD E,SRA (IY+0%02Xh)", NULL },
    { LD_H_SRA_off_IY_d   , OP_BYTE  , "LD H,SRA (IY+0%02Xh)", NULL },
    { LD_L_SRA_off_IY_d   , OP_BYTE  , "LD L,SRA (IY+0%02Xh)", NULL },
    { SRA_off_IY_d        , OP_BYTE  , "SRA (IY+0%02Xh)"   , NULL },
    { LD_A_SRA_off_IY_d   , OP_BYTE  , "LD A,SRA (IY+0%02Xh)", NULL },
    { LD_B_SLL_off_IY_d   , OP_BYTE  , "LD B,SLL (IY+0%02Xh)", NULL },
    { LD_C_SLL_off_IY_d   , OP_BYTE  , "LD C,SLL (IY+0%02Xh)", NULL },
    { LD_D_SLL_off_IY_d   , OP_BYTE  , "LD D,SLL (IY+0%02Xh)", NULL },
    { LD_E_SLL_off_IY_d   , OP_BYTE  , "LD E,SLL (IY+0%02Xh)", NULL },
    { LD_H_SLL_off_IY_d   , OP_BYTE  , "LD H,SLL (IY+0%02Xh)", NULL },
    { LD_L_SLL_off_IY_d   , OP_BYTE  , "LD L,SLL (IY+0%02Xh)", NULL },
    { SLL_off_IY_d        , OP_BYTE  , "SLL (IY+0%02Xh)"   , NULL },
    { LD_A_SLL_off_IY_d   , OP_BYTE  , "LD A,SLL (IY+0%02Xh)", NULL },
    { LD_B_SRL_off_IY_d   , OP_BYTE  , "LD B,SRL (IY+0%02Xh)", NULL },
    { LD_C_SRL_off_IY_d   , OP_BYTE  , "LD C,SRL (IY+0%02Xh)", NULL },
    { LD_D_SRL_off_IY_d   , OP_BYTE  , "LD D,SRL (IY+0%02Xh)", NULL },
    { LD_E_SRL_off_IY_d   , OP_BYTE  , "LD E,SRL (IY+0%02Xh)", NULL },
    { LD_H_SRL_off_IY_d   , OP_BYTE  , "LD H,SRL (IY+0%02Xh)", NULL },
    { LD_L_SRL_off_IY_d   , OP_BYTE  , "LD L,SRL (IY+0%02Xh)", NULL },
    { SRL_off_IY_d        , OP_BYTE  , "SRL (IY+0%02Xh)"   , NULL },
    { LD_A_SRL_off_IY_d   , OP_BYTE  , "LD A,SRL (IY+0%02Xh)", NULL },
    { BIT_0_off_IY_d      , OP_BYTE  , "BIT 0,(IY+0%02Xh)" , NULL },
    { BIT_0_off_IY_d      , OP_BYTE  , "BIT 0,(IY+0%02Xh)" , NULL },
    { BIT_0_off_IY_d      , OP_BYTE  , "BIT 0,(IY+0%02Xh)" , NULL },
    { BIT_0_off_IY_d      , OP_BYTE  , "BIT 0,(IY+0%02Xh)" , NULL },
    { BIT_0_off_IY_d      , OP_BYTE  , "BIT 0,(IY+0%02Xh)" , NULL },
    { BIT_0_off_IY_d      , OP_BYTE  , "BIT 0,(IY+0%02Xh)" , NULL },
    { BIT_0_off_IY_d      , OP_BYTE  , "BIT 0,(IY+0%02Xh)" , NULL },
    { BIT_0_off_IY_d      , OP_BYTE  , "BIT 0,(IY+0%02Xh)" , NULL },
    { BIT_1_off_IY_d      , OP_BYTE  , "BIT 1,(IY+0%02Xh)" , NULL },
    { BIT_1_off_IY_d      , OP_BYTE  , "BIT 1,(IY+0%02Xh)" , NULL },
    { BIT_1_off_IY_d      , OP_BYTE  , "BIT 1,(IY+0%02Xh)" , NULL },
    { BIT_1_off_IY_d      , OP_BYTE  , "BIT 1,(IY+0%02Xh)" , NULL },
    { BIT_1_off_IY_d      , OP_BYTE  , "BIT 1,(IY+0%02Xh)" , NULL },
    { BIT_1_off_IY_d      , OP_BYTE  , "BIT 1,(IY+0%02Xh)" , NULL },
    { BIT_1_off_IY_d      , OP_BYTE  , "BIT 1,(IY+0%02Xh)" , NULL },
    { BIT_1_off_IY_d      , OP_BYTE  , "BIT 1,(IY+0%02Xh)" , NULL },
    { BIT_2_off_IY_d      , OP_BYTE  , "BIT 2,(IY+0%02Xh)" , NULL },
    { BIT_2_off_IY_d      , OP_BYTE  , "BIT 2,(IY+0%02Xh)" , NULL },
    { BIT_2_off_IY_d      , OP_BYTE  , "BIT 2,(IY+0%02Xh)" , NULL },
    { BIT_2_off_IY_d      , OP_BYTE  , "BIT 2,(IY+0%02Xh)" , NULL },
    { BIT_2_off_IY_d      , OP_BYTE  , "BIT 2,(IY+0%02Xh)" , NULL },
    { BIT_2_off_IY_d      , OP_BYTE  , "BIT 2,(IY+0%02Xh)" , NULL },
    { BIT_2_off_IY_d      , OP_BYTE  , "BIT 2,(IY+0%02Xh)" , NULL },
    { BIT_2_off_IY_d      , OP_BYTE  , "BIT 2,(IY+0%02Xh)" , NULL },
    { BIT_3_off_IY_d      , OP_BYTE  , "BIT 3,(IY+0%02Xh)" , NULL },
    { BIT_3_off_IY_d      , OP_BYTE  , "BIT 3,(IY+0%02Xh)" , NULL },
    { BIT_3_off_IY_d      , OP_BYTE  , "BIT 3,(IY+0%02Xh)" , NULL },
    { BIT_3_off_IY_d      , OP_BYTE  , "BIT 3,(IY+0%02Xh)" , NULL },
    { BIT_3_off_IY_d      , OP_BYTE  , "BIT 3,(IY+0%02Xh)" , NULL },
    { BIT_3_off_IY_d      , OP_BYTE  , "BIT 3,(IY+0%02Xh)" , NULL },
    { BIT_3_off_IY_d      , OP_BYTE  , "BIT 3,(IY+0%02Xh)" , NULL },
    { BIT_3_off_IY_d      , OP_BYTE  , "BIT 3,(IY+0%02Xh)" , NULL },
    { BIT_4_off_IY_d      , OP_BYTE  , "BIT 4,(IY+0%02Xh)" , NULL },
    { BIT_4_off_IY_d      , OP_BYTE  , "BIT 4,(IY+0%02Xh)" , NULL },
    { BIT_4_off_IY_d      , OP_BYTE  , "BIT 4,(IY+0%02Xh)" , NULL },
    { BIT_4_off_IY_d      , OP_BYTE  , "BIT 4,(IY+0%02Xh)" , NULL },
    { BIT_4_off_IY_d      , OP_BYTE  , "BIT 4,(IY+0%02Xh)" , NULL },
    { BIT_4_off_IY_d      , OP_BYTE  , "BIT 4,(IY+0%02Xh)" , NULL },
    { BIT_4_off_IY_d      , OP_BYTE  , "BIT 4,(IY+0%02Xh)" , NULL },
    { BIT_4_off_IY_d      , OP_BYTE  , "BIT 4,(IY+0%02Xh)" , NULL },
    { BIT_5_off_IY_d      , OP_BYTE  , "BIT 5,(IY+0%02Xh)" , NULL },
    { BIT_5_off_IY_d      , OP_BYTE  , "BIT 5,(IY+0%02Xh)" , NULL },
    { BIT_5_off_IY_d      , OP_BYTE  , "BIT 5,(IY+0%02Xh)" , NULL },
    { BIT_5_off_IY_d      , OP_BYTE  , "BIT 5,(IY+0%02Xh)" , NULL },
    { BIT_5_off_IY_d      , OP_BYTE  , "BIT 5,(IY+0%02Xh)" , NULL },
    { BIT_5_off_IY_d      , OP_BYTE  , "BIT 5,(IY+0%02Xh)" , NULL },
    { BIT_5_off_IY_d      , OP_BYTE  , "BIT 5,(IY+0%02Xh)" , NULL },
    { BIT_5_off_IY_d      , OP_BYTE  , "BIT 5,(IY+0%02Xh)" , NULL },
    { BIT_6_off_IY_d      , OP_BYTE  , "BIT 6,(IY+0%02Xh)" , NULL },
    { BIT_6_off_IY_d      , OP_BYTE  , "BIT 6,(IY+0%02Xh)" , NULL },
    { BIT_6_off_IY_d      , OP_BYTE  , "BIT 6,(IY+0%02Xh)" , NULL },
    { BIT_6_off_IY_d      , OP_BYTE  , "BIT 6,(IY+0%02Xh)" , NULL },
    { BIT_6_off_IY_d      , OP_BYTE  , "BIT 6,(IY+0%02Xh)" , NULL },
    { BIT_6_off_IY_d      , OP_BYTE  , "BIT 6,(IY+0%02Xh)" , NULL },
    { BIT_6_off_IY_d      , OP_BYTE  , "BIT 6,(IY+0%02Xh)" , NULL },
    { BIT_6_off_IY_d      , OP_BYTE  , "BIT 6,(IY+0%02Xh)" , NULL },
    { BIT_7_off_IY_d      , OP_BYTE  , "BIT 7,(IY+0%02Xh)" , NULL },
    { BIT_7_off_IY_d      , OP_BYTE  , "BIT 7,(IY+0%02Xh)" , NULL },
    { BIT_7_off_IY_d      , OP_BYTE  , "BIT 7,(IY+0%02Xh)" , NULL },
    { BIT_7_off_IY_d      , OP_BYTE  , "BIT 7,(IY+0%02Xh)" , NULL },
    { BIT_7_off_IY_d      , OP_BYTE  , "BIT 7,(IY+0%02Xh)" , NULL },
    { BIT_7_off_IY_d      , OP_BYTE  , "BIT 7,(IY+0%02Xh)" , NULL },
    { BIT_7_off_IY_d      , OP_BYTE  , "BIT 7,(IY+0%02Xh)" , NULL },
    { BIT_7_off_IY_d      , OP_BYTE  , "BIT 7,(IY+0%02Xh)" , NULL },
    { LD_B_RES_0_off_IY_d , OP_BYTE  , "LD B,RES 0,(IY+0%02Xh)", NULL },
    { LD_C_RES_0_off_IY_d , OP_BYTE  , "LD C,RES 0,(IY+0%02Xh)", NULL },
    { LD_D_RES_0_off_IY_d , OP_BYTE  , "LD D,RES 0,(IY+0%02Xh)", NULL },
    { LD_E_RES_0_off_IY_d , OP_BYTE  , "LD E,RES 0,(IY+0%02Xh)", NULL },
    { LD_H_RES_0_off_IY_d , OP_BYTE  , "LD H,RES 0,(IY+0%02Xh)", NULL },
    { LD_L_RES_0_off_IY_d , OP_BYTE  , "LD L,RES 0,(IY+0%02Xh)", NULL },
    { RES_0_off_IY_d      , OP_BYTE  , "RES 0,(IY+0%02Xh)" , NULL },
    { LD_A_RES_0_off_IY_d , OP_BYTE  , "LD A,RES 0,(IY+0%02Xh)", NULL },
    { LD_B_RES_1_off_IY_d , OP_BYTE  , "LD B,RES 1,(IY+0%02Xh)", NULL },
    { LD_C_RES_1_off_IY_d , OP_BYTE  , "LD C,RES 1,(IY+0%02Xh)", NULL },
    { LD_D_RES_1_off_IY_d , OP_BYTE  , "LD D,RES 1,(IY+0%02Xh)", NULL },
    { LD_E_RES_1_off_IY_d , OP_BYTE  , "LD E,RES 1,(IY+0%02Xh)", NULL },
    { LD_H_RES_1_off_IY_d , OP_BYTE  , "LD H,RES 1,(IY+0%02Xh)", NULL },
    { LD_L_RES_1_off_IY_d , OP_BYTE  , "LD L,RES 1,(IY+0%02Xh)", NULL },
    { RES_1_off_IY_d      , OP_BYTE  , "RES 1,(IY+0%02Xh)" , NULL },
    { LD_A_RES_1_off_IY_d , OP_BYTE  , "LD A,RES 1,(IY+0%02Xh)", NULL },
    { LD_B_RES_2_off_IY_d , OP_BYTE  , "LD B,RES 2,(IY+0%02Xh)", NULL },
    { LD_C_RES_2_off_IY_d , OP_BYTE  , "LD C,RES 2,(IY+0%02Xh)", NULL },
    { LD_D_RES_2_off_IY_d , OP_BYTE  , "LD D,RES 2,(IY+0%02Xh)", NULL },
    { LD_E_RES_2_off_IY_d , OP_BYTE  , "LD E,RES 2,(IY+0%02Xh)", NULL },
    { LD_H_RES_2_off_IY_d , OP_BYTE  , "LD H,RES 2,(IY+0%02Xh)", NULL },
    { LD_L_RES_2_off_IY_d , OP_BYTE  , "LD L,RES 2,(IY+0%02Xh)", NULL },
    { RES_2_off_IY_d      , OP_BYTE  , "RES 2,(IY+0%02Xh)" , NULL },
    { LD_A_RES_2_off_IY_d , OP_BYTE  , "LD A,RES 2,(IY+0%02Xh)", NULL },
    { LD_B_RES_3_off_IY_d , OP_BYTE  , "LD B,RES 3,(IY+0%02Xh)", NULL },
    { LD_C_RES_3_off_IY_d , OP_BYTE  , "LD C,RES 3,(IY+0%02Xh)", NULL },
    { LD_D_RES_3_off_IY_d , OP_BYTE  , "LD D,RES 3,(IY+0%02Xh)", NULL },
    { LD_E_RES_3_off_IY_d , OP_BYTE  , "LD E,RES 3,(IY+0%02Xh)", NULL },
    { LD_H_RES_3_off_IY_d , OP_BYTE  , "LD H,RES 3,(IY+0%02Xh)", NULL },
    { LD_L_RES_3_off_IY_d , OP_BYTE  , "LD L,RES 3,(IY+0%02Xh)", NULL },
    { RES_3_off_IY_d      , OP_BYTE  , "RES 3,(IY+0%02Xh)" , NULL },
    { LD_A_RES_3_off_IY_d , OP_BYTE  , "LD A,RES 3,(IY+0%02Xh)", NULL },
    { LD_B_RES_4_off_IY_d , OP_BYTE  , "LD B,RES 4,(IY+0%02Xh)", NULL },
    { LD_C_RES_4_off_IY_d , OP_BYTE  , "LD C,RES 4,(IY+0%02Xh)", NULL },
    { LD_D_RES_4_off_IY_d , OP_BYTE  , "LD D,RES 4,(IY+0%02Xh)", NULL },
    { LD_E_RES_4_off_IY_d , OP_BYTE  , "LD E,RES 4,(IY+0%02Xh)", NULL },
    { LD_H_RES_4_off_IY_d , OP_BYTE  , "LD H,RES 4,(IY+0%02Xh)", NULL },
    { LD_L_RES_4_off_IY_d , OP_BYTE  , "LD L,RES 4,(IY+0%02Xh)", NULL },
    { RES_4_off_IY_d      , OP_BYTE  , "RES 4,(IY+0%02Xh)" , NULL },
    { LD_A_RES_4_off_IY_d , OP_BYTE  , "LD A,RES 4,(IY+0%02Xh)", NULL },
    { LD_B_RES_5_off_IY_d , OP_BYTE  , "LD B,RES 5,(IY+0%02Xh)", NULL },
    { LD_C_RES_5_off_IY_d , OP_BYTE  , "LD C,RES 5,(IY+0%02Xh)", NULL },
    { LD_D_RES_5_off_IY_d , OP_BYTE  , "LD D,RES 5,(IY+0%02Xh)", NULL },
    { LD_E_RES_5_off_IY_d , OP_BYTE  , "LD E,RES 5,(IY+0%02Xh)", NULL },
    { LD_H_RES_5_off_IY_d , OP_BYTE  , "LD H,RES 5,(IY+0%02Xh)", NULL },
    { LD_L_RES_5_off_IY_d , OP_BYTE  , "LD L,RES 5,(IY+0%02Xh)", NULL },
    { RES_5_off_IY_d      , OP_BYTE  , "RES 5,(IY+0%02Xh)" , NULL },
    { LD_A_RES_5_off_IY_d , OP_BYTE  , "LD A,RES 5,(IY+0%02Xh)", NULL },
    { LD_B_RES_6_off_IY_d , OP_BYTE  , "LD B,RES 6,(IY+0%02Xh)", NULL },
    { LD_C_RES_6_off_IY_d , OP_BYTE  , "LD C,RES 6,(IY+0%02Xh)", NULL },
    { LD_D_RES_6_off_IY_d , OP_BYTE  , "LD D,RES 6,(IY+0%02Xh)", NULL },
    { LD_E_RES_6_off_IY_d , OP_BYTE  , "LD E,RES 6,(IY+0%02Xh)", NULL },
    { LD_H_RES_6_off_IY_d , OP_BYTE  , "LD H,RES 6,(IY+0%02Xh)", NULL },
    { LD_L_RES_6_off_IY_d , OP_BYTE  , "LD L,RES 6,(IY+0%02Xh)", NULL },
    { RES_6_off_IY_d      , OP_BYTE  , "RES 6,(IY+0%02Xh)" , NULL },
    { LD_A_RES_6_off_IY_d , OP_BYTE  , "LD A,RES 6,(IY+0%02Xh)", NULL },
    { LD_B_RES_7_off_IY_d , OP_BYTE  , "LD B,RES 7,(IY+0%02Xh)", NULL },
    { LD_C_RES_7_off_IY_d , OP_BYTE  , "LD C,RES 7,(IY+0%02Xh)", NULL },
    { LD_D_RES_7_off_IY_d , OP_BYTE  , "LD D,RES 7,(IY+0%02Xh)", NULL },
    { LD_E_RES_7_off_IY_d , OP_BYTE  , "LD E,RES 7,(IY+0%02Xh)", NULL },
    { LD_H_RES_7_off_IY_d , OP_BYTE  , "LD H,RES 7,(IY+0%02Xh)", NULL },
    { LD_L_RES_7_off_IY_d , OP_BYTE  , "LD L,RES 7,(IY+0%02Xh)", NULL },
    { RES_7_off_IY_d      , OP_BYTE  , "RES 7,(IY+0%02Xh)" , NULL },
    { LD_A_RES_7_off_IY_d , OP_BYTE  , "LD A,RES 7,(IY+0%02Xh)", NULL },
    { LD_B_SET_0_off_IY_d , OP_BYTE  , "LD B,SET 0,(IY+0%02Xh)", NULL },
    { LD_C_SET_0_off_IY_d , OP_BYTE  , "LD C,SET 0,(IY+0%02Xh)", NULL },
    { LD_D_SET_0_off_IY_d , OP_BYTE  , "LD D,SET 0,(IY+0%02Xh)", NULL },
    { LD_E_SET_0_off_IY_d , OP_BYTE  , "LD E,SET 0,(IY+0%02Xh)", NULL },
    { LD_H_SET_0_off_IY_d , OP_BYTE  , "LD H,SET 0,(IY+0%02Xh)", NULL },
    { LD_L_SET_0_off_IY_d , OP_BYTE  , "LD L,SET 0,(IY+0%02Xh)", NULL },
    { SET_0_off_IY_d      , OP_BYTE  , "SET 0,(IY+0%02Xh)" , NULL },
    { LD_A_SET_0_off_IY_d , OP_BYTE  , "LD A,SET 0,(IY+0%02Xh)", NULL },
    { LD_B_SET_1_off_IY_d , OP_BYTE  , "LD B,SET 1,(IY+0%02Xh)", NULL },
    { LD_C_SET_1_off_IY_d , OP_BYTE  , "LD C,SET 1,(IY+0%02Xh)", NULL },
    { LD_D_SET_1_off_IY_d , OP_BYTE  , "LD D,SET 1,(IY+0%02Xh)", NULL },
    { LD_E_SET_1_off_IY_d , OP_BYTE  , "LD E,SET 1,(IY+0%02Xh)", NULL },
    { LD_H_SET_1_off_IY_d , OP_BYTE  , "LD H,SET 1,(IY+0%02Xh)", NULL },
    { LD_L_SET_1_off_IY_d , OP_BYTE  , "LD L,SET 1,(IY+0%02Xh)", NULL },
    { SET_1_off_IY_d      , OP_BYTE  , "SET 1,(IY+0%02Xh)" , NULL },
    { LD_A_SET_1_off_IY_d , OP_BYTE  , "LD A,SET 1,(IY+0%02Xh)", NULL },
    { LD_B_SET_2_off_IY_d , OP_BYTE  , "LD B,SET 2,(IY+0%02Xh)", NULL },
    { LD_C_SET_2_off_IY_d , OP_BYTE  , "LD C,SET 2,(IY+0%02Xh)", NULL },
    { LD_D_SET_2_off_IY_d , OP_BYTE  , "LD D,SET 2,(IY+0%02Xh)", NULL },
    { LD_E_SET_2_off_IY_d , OP_BYTE  , "LD E,SET 2,(IY+0%02Xh)", NULL },
    { LD_H_SET_2_off_IY_d , OP_BYTE  , "LD H,SET 2,(IY+0%02Xh)", NULL },
    { LD_L_SET_2_off_IY_d , OP_BYTE  , "LD L,SET 2,(IY+0%02Xh)", NULL },
    { SET_2_off_IY_d      , OP_BYTE  , "SET 2,(IY+0%02Xh)" , NULL },
    { LD_A_SET_2_off_IY_d , OP_BYTE  , "LD A,SET 2,(IY+0%02Xh)", NULL },
    { LD_B_SET_3_off_IY_d , OP_BYTE  , "LD B,SET 3,(IY+0%02Xh)", NULL },
    { LD_C_SET_3_off_IY_d , OP_BYTE  , "LD C,SET 3,(IY+0%02Xh)", NULL },
    { LD_D_SET_3_off_IY_d , OP_BYTE  , "LD D,SET 3,(IY+0%02Xh)", NULL },
    { LD_E_SET_3_off_IY_d , OP_BYTE  , "LD E,SET 3,(IY+0%02Xh)", NULL },
    { LD_H_SET_3_off_IY_d , OP_BYTE  , "LD H,SET 3,(IY+0%02Xh)", NULL },
    { LD_L_SET_3_off_IY_d , OP_BYTE  , "LD L,SET 3,(IY+0%02Xh)", NULL },
    { SET_3_off_IY_d      , OP_BYTE  , "SET 3,(IY+0%02Xh)" , NULL },
    { LD_A_SET_3_off_IY_d , OP_BYTE  , "LD A,SET 3,(IY+0%02Xh)", NULL },
    { LD_B_SET_4_off_IY_d , OP_BYTE  , "LD B,SET 4,(IY+0%02Xh)", NULL },
    { LD_C_SET_4_off_IY_d , OP_BYTE  , "LD C,SET 4,(IY+0%02Xh)", NULL },
    { LD_D_SET_4_off_IY_d , OP_BYTE  , "LD D,SET 4,(IY+0%02Xh)", NULL },
    { LD_E_SET_4_off_IY_d , OP_BYTE  , "LD E,SET 4,(IY+0%02Xh)", NULL },
    { LD_H_SET_4_off_IY_d , OP_BYTE  , "LD H,SET 4,(IY+0%02Xh)", NULL },
    { LD_L_SET_4_off_IY_d , OP_BYTE  , "LD L,SET 4,(IY+0%02Xh)", NULL },
    { SET_4_off_IY_d      , OP_BYTE  , "SET 4,(IY+0%02Xh)" , NULL },
    { LD_A_SET_4_off_IY_d , OP_BYTE  , "LD A,SET 4,(IY+0%02Xh)", NULL },
    { LD_B_SET_5_off_IY_d , OP_BYTE  , "LD B,SET 5,(IY+0%02Xh)", NULL },
    { LD_C_SET_5_off_IY_d , OP_BYTE  , "LD C,SET 5,(IY+0%02Xh)", NULL },
    { LD_D_SET_5_off_IY_d , OP_BYTE  , "LD D,SET 5,(IY+0%02Xh)", NULL },
    { LD_E_SET_5_off_IY_d , OP_BYTE  , "LD E,SET 5,(IY+0%02Xh)", NULL },
    { LD_H_SET_5_off_IY_d , OP_BYTE  , "LD H,SET 5,(IY+0%02Xh)", NULL },
    { LD_L_SET_5_off_IY_d , OP_BYTE  , "LD L,SET 5,(IY+0%02Xh)", NULL },
    { SET_5_off_IY_d      , OP_BYTE  , "SET 5,(IY+0%02Xh)" , NULL },
    { LD_A_SET_5_off_IY_d , OP_BYTE  , "LD A,SET 5,(IY+0%02Xh)", NULL },
    { LD_B_SET_6_off_IY_d , OP_BYTE  , "LD B,SET 6,(IY+0%02Xh)", NULL },
    { LD_C_SET_6_off_IY_d , OP_BYTE  , "LD C,SET 6,(IY+0%02Xh)", NULL },
    { LD_D_SET_6_off_IY_d , OP_BYTE  , "LD D,SET 6,(IY+0%02Xh)", NULL },
    { LD_E_SET_6_off_IY_d , OP_BYTE  , "LD E,SET 6,(IY+0%02Xh)", NULL },
    { LD_H_SET_6_off_IY_d , OP_BYTE  , "LD H,SET 6,(IY+0%02Xh)", NULL },
    { LD_L_SET_6_off_IY_d , OP_BYTE  , "LD L,SET 6,(IY+0%02Xh)", NULL },
    { SET_6_off_IY_d      , OP_BYTE  , "SET 6,(IY+0%02Xh)" , NULL },
    { LD_A_SET_6_off_IY_d , OP_BYTE  , "LD A,SET 6,(IY+0%02Xh)", NULL },
    { LD_B_SET_7_off_IY_d , OP_BYTE  , "LD B,SET 7,(IY+0%02Xh)", NULL },
    { LD_C_SET_7_off_IY_d , OP_BYTE  , "LD C,SET 7,(IY+0%02Xh)", NULL },
    { LD_D_SET_7_off_IY_d , OP_BYTE  , "LD D,SET 7,(IY+0%02Xh)", NULL },
    { LD_E_SET_7_off_IY_d , OP_BYTE  , "LD E,SET 7,(IY+0%02Xh)", NULL },
    { LD_H_SET_7_off_IY_d , OP_BYTE  , "LD H,SET 7,(IY+0%02Xh)", NULL },
    { LD_L_SET_7_off_IY_d , OP_BYTE  , "LD L,SET 7,(IY+0%02Xh)", NULL },
    { SET_7_off_IY_d      , OP_BYTE  , "SET 7,(IY+0%02Xh)" , NULL },
    { LD_A_SET_7_off_IY_d , OP_BYTE  , "LD A,SET 7,(IY+0%02Xh)", NULL }
} };

static struct Z80OpcodeTable opcodes_DDCB = { 1, {
    { LD_B_RLC_off_IX_d   , OP_BYTE  , "LD B,RLC (IX+0%02Xh)", NULL },
    { LD_C_RLC_off_IX_d   , OP_BYTE  , "LD C,RLC (IX+0%02Xh)", NULL },
    { LD_D_RLC_off_IX_d   , OP_BYTE  , "LD D,RLC (IX+0%02Xh)", NULL },
    { LD_E_RLC_off_IX_d   , OP_BYTE  , "LD E,RLC (IX+0%02Xh)", NULL },
    { LD_H_RLC_off_IX_d   , OP_BYTE  , "LD H,RLC (IX+0%02Xh)", NULL },
    { LD_L_RLC_off_IX_d   , OP_BYTE  , "LD L,RLC (IX+0%02Xh)", NULL },
    { RLC_off_IX_d        , OP_BYTE  , "RLC (IX+0%02Xh)"   , NULL },
    { LD_A_RLC_off_IX_d   , OP_BYTE  , "LD A,RLC (IX+0%02Xh)", NULL },
    { LD_B_RRC_off_IX_d   , OP_BYTE  , "LD B,RRC (IX+0%02Xh)", NULL },
    { LD_C_RRC_off_IX_d   , OP_BYTE  , "LD C,RRC (IX+0%02Xh)", NULL },
    { LD_D_RRC_off_IX_d   , OP_BYTE  , "LD D,RRC (IX+0%02Xh)", NULL },
    { LD_E_RRC_off_IX_d   , OP_BYTE  , "LD E,RRC (IX+0%02Xh)", NULL },
    { LD_H_RRC_off_IX_d   , OP_BYTE  , "LD H,RRC (IX+0%02Xh)", NULL },
    { LD_L_RRC_off_IX_d   , OP_BYTE  , "LD L,RRC (IX+0%02Xh)", NULL },
    { RRC_off_IX_d        , OP_BYTE  , "RRC (IX+0%02Xh)"   , NULL },
    { LD_A_RRC_off_IX_d   , OP_BYTE  , "LD A,RRC (IX+0%02Xh)", NULL },
    { LD_B_RL_off_IX_d    , OP_BYTE  , "LD B,RL (IX+0%02Xh)", NULL },
    { LD_C_RL_off_IX_d    , OP_BYTE  , "LD C,RL (IX+0%02Xh)", NULL },
    { LD_D_RL_off_IX_d    , OP_BYTE  , "LD D,RL (IX+0%02Xh)", NULL },
    { LD_E_RL_off_IX_d    , OP_BYTE  , "LD E,RL (IX+0%02Xh)", NULL },
    { LD_H_RL_off_IX_d    , OP_BYTE  , "LD H,RL (IX+0%02Xh)", NULL },
    { LD_L_RL_off_IX_d    , OP_BYTE  , "LD L,RL (IX+0%02Xh)", NULL },
    { RL_off_IX_d         , OP_BYTE  , "RL (IX+0%02Xh)"    , NULL },
    { LD_A_RL_off_IX_d    , OP_BYTE  , "LD A,RL (IX+0%02Xh)", NULL },
    { LD_B_RR_off_IX_d    , OP_BYTE  , "LD B,RR (IX+0%02Xh)", NULL },
    { LD_C_RR_off_IX_d    , OP_BYTE  , "LD C,RR (IX+0%02Xh)", NULL },
    { LD_D_RR_off_IX_d    , OP_BYTE  , "LD D,RR (IX+0%02Xh)", NULL },
    { LD_E_RR_off_IX_d    , OP_BYTE  , "LD E,RR (IX+0%02Xh)", NULL },
    { LD_H_RR_off_IX_d    , OP_BYTE  , "LD H,RR (IX+0%02Xh)", NULL },
    { LD_L_RR_off_IX_d    , OP_BYTE  , "LD L,RR (IX+0%02Xh)", NULL },
    { RR_off_IX_d         , OP_BYTE  , "RR (IX+0%02Xh)"    , NULL },
    { LD_A_RR_off_IX_d    , OP_BYTE  , "LD A,RR (IX+0%02Xh)", NULL },
    { LD_B_SLA_off_IX_d   , OP_BYTE  , "LD B,SLA (IX+0%02Xh)", NULL },
    { LD_C_SLA_off_IX_d   , OP_BYTE  , "LD C,SLA (IX+0%02Xh)", NULL },
    { LD_D_SLA_off_IX_d   , OP_BYTE  , "LD D,SLA (IX+0%02Xh)", NULL },
    { LD_E_SLA_off_IX_d   , OP_BYTE  , "LD E,SLA (IX+0%02Xh)", NULL },
    { LD_H_SLA_off_IX_d   , OP_BYTE  , "LD H,SLA (IX+0%02Xh)", NULL },
    { LD_L_SLA_off_IX_d   , OP_BYTE  , "LD L,SLA (IX+0%02Xh)", NULL },
    { SLA_off_IX_d        , OP_BYTE  , "SLA (IX+0%02Xh)"   , NULL },
    { LD_A_SLA_off_IX_d   , OP_BYTE  , "LD A,SLA (IX+0%02Xh)", NULL },
    { LD_B_SRA_off_IX_d   , OP_BYTE  , "LD B,SRA (IX+0%02Xh)", NULL },
    { LD_C_SRA_off_IX_d   , OP_BYTE  , "LD C,SRA (IX+0%02Xh)", NULL },
    { LD_D_SRA_off_IX_d   , OP_BYTE  , "LD D,SRA (IX+0%02Xh)", NULL },
    { LD_E_SRA_off_IX_d   , OP_BYTE  , "LD E,SRA (IX+0%02Xh)", NULL },
    { LD_H_SRA_off_IX_d   , OP_BYTE  , "LD H,SRA (IX+0%02Xh)", NULL },
    { LD_L_SRA_off_IX_d   , OP_BYTE  , "LD L,SRA (IX+0%02Xh)", NULL },
    { SRA_off_IX_d        , OP_BYTE  , "SRA (IX+0%02Xh)"   , NULL },
    { LD_A_SRA_off_IX_d   , OP_BYTE  , "LD A,SRA (IX+0%02Xh)", NULL },
    { LD_B_SLL_off_IX_d   , OP_BYTE  , "LD B,SLL (IX+0%02Xh)", NULL },
    { LD_C_SLL_off_IX_d   , OP_BYTE  , "LD C,SLL (IX+0%02Xh)", NULL },
    { LD_D_SLL_off_IX_d   , OP_BYTE  , "LD D,SLL (IX+0%02Xh)", NULL },
    { LD_E_SLL_off_IX_d   , OP_BYTE  , "LD E,SLL (IX+0%02Xh)", NULL },
    { LD_H_SLL_off_IX_d   , OP_BYTE  , "LD H,SLL (IX+0%02Xh)", NULL },
    { LD_L_SLL_off_IX_d   , OP_BYTE  , "LD L,SLL (IX+0%02Xh)", NULL },
    { SLL_off_IX_d        , OP_BYTE  , "SLL (IX+0%02Xh)"   , NULL },
    { LD_A_SLL_off_IX_d   , OP_BYTE  , "LD A,SLL (IX+0%02Xh)", NULL },
    { LD_B_SRL_off_IX_d   , OP_BYTE  , "LD B,SRL (IX+0%02Xh)", NULL },
    { LD_C_SRL_off_IX_d   , OP_BYTE  , "LD C,SRL (IX+0%02Xh)", NULL },
    { LD_D_SRL_off_IX_d   , OP_BYTE  , "LD D,SRL (IX+0%02Xh)", NULL },
    { LD_E_SRL_off_IX_d   , OP_BYTE  , "LD E,SRL (IX+0%02Xh)", NULL },
    { LD_H_SRL_off_IX_d   , OP_BYTE  , "LD H,SRL (IX+0%02Xh)", NULL },
    { LD_L_SRL_off_IX_d   , OP_BYTE  , "LD L,SRL (IX+0%02Xh)", NULL },
    { SRL_off_IX_d        , OP_BYTE  , "SRL (IX+0%02Xh)"   , NULL },
    { LD_A_SRL_off_IX_d   , OP_BYTE  , "LD A,SRL (IX+0%02Xh)", NULL },
    { BIT_0_off_IX_d      , OP_BYTE  , "BIT 0,(IX+0%02Xh)" , NULL },
    { BIT_0_off_IX_d      , OP_BYTE  , "BIT 0,(IX+0%02Xh)" , NULL },
    { BIT_0_off_IX_d      , OP_BYTE  , "BIT 0,(IX+0%02Xh)" , NULL },
    { BIT_0_off_IX_d      , OP_BYTE  , "BIT 0,(IX+0%02Xh)" , NULL },
    { BIT_0_off_IX_d      , OP_BYTE  , "BIT 0,(IX+0%02Xh)" , NULL },
    { BIT_0_off_IX_d      , OP_BYTE  , "BIT 0,(IX+0%02Xh)" , NULL },
    { BIT_0_off_IX_d      , OP_BYTE  , "BIT 0,(IX+0%02Xh)" , NULL },
    { BIT_0_off_IX_d      , OP_BYTE  , "BIT 0,(IX+0%02Xh)" , NULL },
    { BIT_1_off_IX_d      , OP_BYTE  , "BIT 1,(IX+0%02Xh)" , NULL },
    { BIT_1_off_IX_d      , OP_BYTE  , "BIT 1,(IX+0%02Xh)" , NULL },
    { BIT_1_off_IX_d      , OP_BYTE  , "BIT 1,(IX+0%02Xh)" , NULL },
    { BIT_1_off_IX_d      , OP_BYTE  , "BIT 1,(IX+0%02Xh)" , NULL },
    { BIT_1_off_IX_d      , OP_BYTE  , "BIT 1,(IX+0%02Xh)" , NULL },
    { BIT_1_off_IX_d      , OP_BYTE  , "BIT 1,(IX+0%02Xh)" , NULL },
    { BIT_1_off_IX_d      , OP_BYTE  , "BIT 1,(IX+0%02Xh)" , NULL },
    { BIT_1_off_IX_d      , OP_BYTE  , "BIT 1,(IX+0%02Xh)" , NULL },
    { BIT_2_off_IX_d      , OP_BYTE  , "BIT 2,(IX+0%02Xh)" , NULL },
    { BIT_2_off_IX_d      , OP_BYTE  , "BIT 2,(IX+0%02Xh)" , NULL },
    { BIT_2_off_IX_d      , OP_BYTE  , "BIT 2,(IX+0%02Xh)" , NULL },
    { BIT_2_off_IX_d      , OP_BYTE  , "BIT 2,(IX+0%02Xh)" , NULL },
    { BIT_2_off_IX_d      , OP_BYTE  , "BIT 2,(IX+0%02Xh)" , NULL },
    { BIT_2_off_IX_d      , OP_BYTE  , "BIT 2,(IX+0%02Xh)" , NULL },
    { BIT_2_off_IX_d      , OP_BYTE  , "BIT 2,(IX+0%02Xh)" , NULL },
    { BIT_2_off_IX_d      , OP_BYTE  , "BIT 2,(IX+0%02Xh)" , NULL },
    { BIT_3_off_IX_d      , OP_BYTE  , "BIT 3,(IX+0%02Xh)" , NULL },
    { BIT_3_off_IX_d      , OP_BYTE  , "BIT 3,(IX+0%02Xh)" , NULL },
    { BIT_3_off_IX_d      , OP_BYTE  , "BIT 3,(IX+0%02Xh)" , NULL },
    { BIT_3_off_IX_d      , OP_BYTE  , "BIT 3,(IX+0%02Xh)" , NULL },
    { BIT_3_off_IX_d      , OP_BYTE  , "BIT 3,(IX+0%02Xh)" , NULL },
    { BIT_3_off_IX_d      , OP_BYTE  , "BIT 3,(IX+0%02Xh)" , NULL },
    { BIT_3_off_IX_d      , OP_BYTE  , "BIT 3,(IX+0%02Xh)" , NULL },
    { BIT_3_off_IX_d      , OP_BYTE  , "BIT 3,(IX+0%02Xh)" , NULL },
    { BIT_4_off_IX_d      , OP_BYTE  , "BIT 4,(IX+0%02Xh)" , NULL },
    { BIT_4_off_IX_d      , OP_BYTE  , "BIT 4,(IX+0%02Xh)" , NULL },
    { BIT_4_off_IX_d      , OP_BYTE  , "BIT 4,(IX+0%02Xh)" , NULL },
    { BIT_4_off_IX_d      , OP_BYTE  , "BIT 4,(IX+0%02Xh)" , NULL },
    { BIT_4_off_IX_d      , OP_BYTE  , "BIT 4,(IX+0%02Xh)" , NULL },
    { BIT_4_off_IX_d      , OP_BYTE  , "BIT 4,(IX+0%02Xh)" , NULL },
    { BIT_4_off_IX_d      , OP_BYTE  , "BIT 4,(IX+0%02Xh)" , NULL },
    { BIT_4_off_IX_d      , OP_BYTE  , "BIT 4,(IX+0%02Xh)" , NULL },
    { BIT_5_off_IX_d      , OP_BYTE  , "BIT 5,(IX+0%02Xh)" , NULL },
    { BIT_5_off_IX_d      , OP_BYTE  , "BIT 5,(IX+0%02Xh)" , NULL },
    { BIT_5_off_IX_d      , OP_BYTE  , "BIT 5,(IX+0%02Xh)" , NULL },
    { BIT_5_off_IX_d      , OP_BYTE  , "BIT 5,(IX+0%02Xh)" , NULL },
    { BIT_5_off_IX_d      , OP_BYTE  , "BIT 5,(IX+0%02Xh)" , NULL },
    { BIT_5_off_IX_d      , OP_BYTE  , "BIT 5,(IX+0%02Xh)" , NULL },
    { BIT_5_off_IX_d      , OP_BYTE  , "BIT 5,(IX+0%02Xh)" , NULL },
    { BIT_5_off_IX_d      , OP_BYTE  , "BIT 5,(IX+0%02Xh)" , NULL },
    { BIT_6_off_IX_d      , OP_BYTE  , "BIT 6,(IX+0%02Xh)" , NULL },
    { BIT_6_off_IX_d      , OP_BYTE  , "BIT 6,(IX+0%02Xh)" , NULL },
    { BIT_6_off_IX_d      , OP_BYTE  , "BIT 6,(IX+0%02Xh)" , NULL },
    { BIT_6_off_IX_d      , OP_BYTE  , "BIT 6,(IX+0%02Xh)" , NULL },
    { BIT_6_off_IX_d      , OP_BYTE  , "BIT 6,(IX+0%02Xh)" , NULL },
    { BIT_6_off_IX_d      , OP_BYTE  , "BIT 6,(IX+0%02Xh)" , NULL },
    { BIT_6_off_IX_d      , OP_BYTE  , "BIT 6,(IX+0%02Xh)" , NULL },
    { BIT_6_off_IX_d      , OP_BYTE  , "BIT 6,(IX+0%02Xh)" , NULL },
    { BIT_7_off_IX_d      , OP_BYTE  , "BIT 7,(IX+0%02Xh)" , NULL },
    { BIT_7_off_IX_d      , OP_BYTE  , "BIT 7,(IX+0%02Xh)" , NULL },
    { BIT_7_off_IX_d      , OP_BYTE  , "BIT 7,(IX+0%02Xh)" , NULL },
    { BIT_7_off_IX_d      , OP_BYTE  , "BIT 7,(IX+0%02Xh)" , NULL },
    { BIT_7_off_IX_d      , OP_BYTE  , "BIT 7,(IX+0%02Xh)" , NULL },
    { BIT_7_off_IX_d      , OP_BYTE  , "BIT 7,(IX+0%02Xh)" , NULL },
    { BIT_7_off_IX_d      , OP_BYTE  , "BIT 7,(IX+0%02Xh)" , NULL },
    { BIT_7_off_IX_d      , OP_BYTE  , "BIT 7,(IX+0%02Xh)" , NULL },
    { LD_B_RES_0_off_IX_d , OP_BYTE  , "LD B,RES 0,(IX+0%02Xh)", NULL },
    { LD_C_RES_0_off_IX_d , OP_BYTE  , "LD C,RES 0,(IX+0%02Xh)", NULL },
    { LD_D_RES_0_off_IX_d , OP_BYTE  , "LD D,RES 0,(IX+0%02Xh)", NULL },
    { LD_E_RES_0_off_IX_d , OP_BYTE  , "LD E,RES 0,(IX+0%02Xh)", NULL },
    { LD_H_RES_0_off_IX_d , OP_BYTE  , "LD H,RES 0,(IX+0%02Xh)", NULL },
    { LD_L_RES_0_off_IX_d , OP_BYTE  , "LD L,RES 0,(IX+0%02Xh)", NULL },
    { RES_0_off_IX_d      , OP_BYTE  , "RES 0,(IX+0%02Xh)" , NULL },
    { LD_A_RES_0_off_IX_d , OP_BYTE  , "LD A,RES 0,(IX+0%02Xh)", NULL },
    { LD_B_RES_1_off_IX_d , OP_BYTE  , "LD B,RES 1,(IX+0%02Xh)", NULL },
    { LD_C_RES_1_off_IX_d , OP_BYTE  , "LD C,RES 1,(IX+0%02Xh)", NULL },
    { LD_D_RES_1_off_IX_d , OP_BYTE  , "LD D,RES 1,(IX+0%02Xh)", NULL },
    { LD_E_RES_1_off_IX_d , OP_BYTE  , "LD E,RES 1,(IX+0%02Xh)", NULL },
    { LD_H_RES_1_off_IX_d , OP_BYTE  , "LD H,RES 1,(IX+0%02Xh)", NULL },
    { LD_L_RES_1_off_IX_d , OP_BYTE  , "LD L,RES 1,(IX+0%02Xh)", NULL },
    { RES_1_off_IX_d      , OP_BYTE  , "RES 1,(IX+0%02Xh)" , NULL },
    { LD_A_RES_1_off_IX_d , OP_BYTE  , "LD A,RES 1,(IX+0%02Xh)", NULL },
    { LD_B_RES_2_off_IX_d , OP_BYTE  , "LD B,RES 2,(IX+0%02Xh)", NULL },
    { LD_C_RES_2_off_IX_d , OP_BYTE  , "LD C,RES 2,(IX+0%02Xh)", NULL },
    { LD_D_RES_2_off_IX_d , OP_BYTE  , "LD D,RES 2,(IX+0%02Xh)", NULL },
    { LD_E_RES_2_off_IX_d , OP_BYTE  , "LD E,RES 2,(IX+0%02Xh)", NULL },
    { LD_H_RES_2_off_IX_d , OP_BYTE  , "LD H,RES 2,(IX+0%02Xh)", NULL },
    { LD_L_RES_2_off_IX_d , OP_BYTE  , "LD L,RES 2,(IX+0%02Xh)", NULL },
    { RES_2_off_IX_d      , OP_BYTE  , "RES 2,(IX+0%02Xh)" , NULL },
    { LD_A_RES_2_off_IX_d , OP_BYTE  , "LD A,RES 2,(IX+0%02Xh)", NULL },
    { LD_B_RES_3_off_IX_d , OP_BYTE  , "LD B,RES 3,(IX+0%02Xh)", NULL },
    { LD_C_RES_3_off_IX_d , OP_BYTE  , "LD C,RES 3,(IX+0%02Xh)", NULL },
    { LD_D_RES_3_off_IX_d , OP_BYTE  , "LD D,RES 3,(IX+0%02Xh)", NULL },
    { LD_E_RES_3_off_IX_d , OP_BYTE  , "LD E,RES 3,(IX+0%02Xh)", NULL },
    { LD_H_RES_3_off_IX_d , OP_BYTE  , "LD H,RES 3,(IX+0%02Xh)", NULL },
    { LD_L_RES_3_off_IX_d , OP_BYTE  , "LD L,RES 3,(IX+0%02Xh)", NULL },
    { RES_3_off_IX_d      , OP_BYTE  , "RES 3,(IX+0%02Xh)" , NULL },
    { LD_A_RES_3_off_IX_d , OP_BYTE  , "LD A,RES 3,(IX+0%02Xh)", NULL },
    { LD_B_RES_4_off_IX_d , OP_BYTE  , "LD B,RES 4,(IX+0%02Xh)", NULL },
    { LD_C_RES_4_off_IX_d , OP_BYTE  , "LD C,RES 4,(IX+0%02Xh)", NULL },
    { LD_D_RES_4_off_IX_d , OP_BYTE  , "LD D,RES 4,(IX+0%02Xh)", NULL },
    { LD_E_RES_4_off_IX_d , OP_BYTE  , "LD E,RES 4,(IX+0%02Xh)", NULL },
    { LD_H_RES_4_off_IX_d , OP_BYTE  , "LD H,RES 4,(IX+0%02Xh)", NULL },
    { LD_L_RES_4_off_IX_d , OP_BYTE  , "LD L,RES 4,(IX+0%02Xh)", NULL },
    { RES_4_off_IX_d      , OP_BYTE  , "RES 4,(IX+0%02Xh)" , NULL },
    { LD_A_RES_4_off_IX_d , OP_BYTE  , "LD A,RES 4,(IX+0%02Xh)", NULL },
    { LD_B_RES_5_off_IX_d , OP_BYTE  , "LD B,RES 5,(IX+0%02Xh)", NULL },
    { LD_C_RES_5_off_IX_d , OP_BYTE  , "LD C,RES 5,(IX+0%02Xh)", NULL },
    { LD_D_RES_5_off_IX_d , OP_BYTE  , "LD D,RES 5,(IX+0%02Xh)", NULL },
    { LD_E_RES_5_off_IX_d , OP_BYTE  , "LD E,RES 5,(IX+0%02Xh)", NULL },
    { LD_H_RES_5_off_IX_d , OP_BYTE  , "LD H,RES 5,(IX+0%02Xh)", NULL },
    { LD_L_RES_5_off_IX_d , OP_BYTE  , "LD L,RES 5,(IX+0%02Xh)", NULL },
    { RES_5_off_IX_d      , OP_BYTE  , "RES 5,(IX+0%02Xh)" , NULL },
    { LD_A_RES_5_off_IX_d , OP_BYTE  , "LD A,RES 5,(IX+0%02Xh)", NULL },
    { LD_B_RES_6_off_IX_d , OP_BYTE  , "LD B,RES 6,(IX+0%02Xh)", NULL },
    { LD_C_RES_6_off_IX_d , OP_BYTE  , "LD C,RES 6,(IX+0%02Xh)", NULL },
    { LD_D_RES_6_off_IX_d , OP_BYTE  , "LD D,RES 6,(IX+0%02Xh)", NULL },
    { LD_E_RES_6_off_IX_d , OP_BYTE  , "LD E,RES 6,(IX+0%02Xh)", NULL },
    { LD_H_RES_6_off_IX_d , OP_BYTE  , "LD H,RES 6,(IX+0%02Xh)", NULL },
    { LD_L_RES_6_off_IX_d , OP_BYTE  , "LD L,RES 6,(IX+0%02Xh)", NULL },
    { RES_6_off_IX_d      , OP_BYTE  , "RES 6,(IX+0%02Xh)" , NULL },
    { LD_A_RES_6_off_IX_d , OP_BYTE  , "LD A,RES 6,(IX+0%02Xh)", NULL },
    { LD_B_RES_7_off_IX_d , OP_BYTE  , "LD B,RES 7,(IX+0%02Xh)", NULL },
    { LD_C_RES_7_off_IX_d , OP_BYTE  , "LD C,RES 7,(IX+0%02Xh)", NULL },
    { LD_D_RES_7_off_IX_d , OP_BYTE  , "LD D,RES 7,(IX+0%02Xh)", NULL },
    { LD_E_RES_7_off_IX_d , OP_BYTE  , "LD E,RES 7,(IX+0%02Xh)", NULL },
    { LD_H_RES_7_off_IX_d , OP_BYTE  , "LD H,RES 7,(IX+0%02Xh)", NULL },
    { LD_L_RES_7_off_IX_d , OP_BYTE  , "LD L,RES 7,(IX+0%02Xh)", NULL },
    { RES_7_off_IX_d      , OP_BYTE  , "RES 7,(IX+0%02Xh)" , NULL },
    { LD_A_RES_7_off_IX_d , OP_BYTE  , "LD A,RES 7,(IX+0%02Xh)", NULL },
    { LD_B_SET_0_off_IX_d , OP_BYTE  , "LD B,SET 0,(IX+0%02Xh)", NULL },
    { LD_C_SET_0_off_IX_d , OP_BYTE  , "LD C,SET 0,(IX+0%02Xh)", NULL },
    { LD_D_SET_0_off_IX_d , OP_BYTE  , "LD D,SET 0,(IX+0%02Xh)", NULL },
    { LD_E_SET_0_off_IX_d , OP_BYTE  , "LD E,SET 0,(IX+0%02Xh)", NULL },
    { LD_H_SET_0_off_IX_d , OP_BYTE  , "LD H,SET 0,(IX+0%02Xh)", NULL },
    { LD_L_SET_0_off_IX_d , OP_BYTE  , "LD L,SET 0,(IX+0%02Xh)", NULL },
    { SET_0_off_IX_d      , OP_BYTE  , "SET 0,(IX+0%02Xh)" , NULL },
    { LD_A_SET_0_off_IX_d , OP_BYTE  , "LD A,SET 0,(IX+0%02Xh)", NULL },
    { LD_B_SET_1_off_IX_d , OP_BYTE  , "LD B,SET 1,(IX+0%02Xh)", NULL },
    { LD_C_SET_1_off_IX_d , OP_BYTE  , "LD C,SET 1,(IX+0%02Xh)", NULL },
    { LD_D_SET_1_off_IX_d , OP_BYTE  , "LD D,SET 1,(IX+0%02Xh)", NULL },
    { LD_E_SET_1_off_IX_d , OP_BYTE  , "LD E,SET 1,(IX+0%02Xh)", NULL },
    { LD_H_SET_1_off_IX_d , OP_BYTE  , "LD H,SET 1,(IX+0%02Xh)", NULL },
    { LD_L_SET_1_off_IX_d , OP_BYTE  , "LD L,SET 1,(IX+0%02Xh)", NULL },
    { SET_1_off_IX_d      , OP_BYTE  , "SET 1,(IX+0%02Xh)" , NULL },
    { LD_A_SET_1_off_IX_d , OP_BYTE  , "LD A,SET 1,(IX+0%02Xh)", NULL },
    { LD_B_SET_2_off_IX_d , OP_BYTE  , "LD B,SET 2,(IX+0%02Xh)", NULL },
    { LD_C_SET_2_off_IX_d , OP_BYTE  , "LD C,SET 2,(IX+0%02Xh)", NULL },
    { LD_D_SET_2_off_IX_d , OP_BYTE  , "LD D,SET 2,(IX+0%02Xh)", NULL },
    { LD_E_SET_2_off_IX_d , OP_BYTE  , "LD E,SET 2,(IX+0%02Xh)", NULL },
    { LD_H_SET_2_off_IX_d , OP_BYTE  , "LD H,SET 2,(IX+0%02Xh)", NULL },
    { LD_L_SET_2_off_IX_d , OP_BYTE  , "LD L,SET 2,(IX+0%02Xh)", NULL },
    { SET_2_off_IX_d      , OP_BYTE  , "SET 2,(IX+0%02Xh)" , NULL },
    { LD_A_SET_2_off_IX_d , OP_BYTE  , "LD A,SET 2,(IX+0%02Xh)", NULL },
    { LD_B_SET_3_off_IX_d , OP_BYTE  , "LD B,SET 3,(IX+0%02Xh)", NULL },
    { LD_C_SET_3_off_IX_d , OP_BYTE  , "LD C,SET 3,(IX+0%02Xh)", NULL },
    { LD_D_SET_3_off_IX_d , OP_BYTE  , "LD D,SET 3,(IX+0%02Xh)", NULL },
    { LD_E_SET_3_off_IX_d , OP_BYTE  , "LD E,SET 3,(IX+0%02Xh)", NULL },
    { LD_H_SET_3_off_IX_d , OP_BYTE  , "LD H,SET 3,(IX+0%02Xh)", NULL },
    { LD_L_SET_3_off_IX_d , OP_BYTE  , "LD L,SET 3,(IX+0%02Xh)", NULL },
    { SET_3_off_IX_d      , OP_BYTE  , "SET 3,(IX+0%02Xh)" , NULL },
    { LD_A_SET_3_off_IX_d , OP_BYTE  , "LD A,SET 3,(IX+0%02Xh)", NULL },
    { LD_B_SET_4_off_IX_d , OP_BYTE  , "LD B,SET 4,(IX+0%02Xh)", NULL },
    { LD_C_SET_4_off_IX_d , OP_BYTE  , "LD C,SET 4,(IX+0%02Xh)", NULL },
    { LD_D_SET_4_off_IX_d , OP_BYTE  , "LD D,SET 4,(IX+0%02Xh)", NULL },
    { LD_E_SET_4_off_IX_d , OP_BYTE  , "LD E,SET 4,(IX+0%02Xh)", NULL },
    { LD_H_SET_4_off_IX_d , OP_BYTE  , "LD H,SET 4,(IX+0%02Xh)", NULL },
    { LD_L_SET_4_off_IX_d , OP_BYTE  , "LD L,SET 4,(IX+0%02Xh)", NULL },
    { SET_4_off_IX_d      , OP_BYTE  , "SET 4,(IX+0%02Xh)" , NULL },
    { LD_A_SET_4_off_IX_d , OP_BYTE  , "LD A,SET 4,(IX+0%02Xh)", NULL },
    { LD_B_SET_5_off_IX_d , OP_BYTE  , "LD B,SET 5,(IX+0%02Xh)", NULL },
    { LD_C_SET_5_off_IX_d , OP_BYTE  , "LD C,SET 5,(IX+0%02Xh)", NULL },
    { LD_D_SET_5_off_IX_d , OP_BYTE  , "LD D,SET 5,(IX+0%02Xh)", NULL },
    { LD_E_SET_5_off_IX_d , OP_BYTE  , "LD E,SET 5,(IX+0%02Xh)", NULL },
    { LD_H_SET_5_off_IX_d , OP_BYTE  , "LD H,SET 5,(IX+0%02Xh)", NULL },
    { LD_L_SET_5_off_IX_d , OP_BYTE  , "LD L,SET 5,(IX+0%02Xh)", NULL },
    { SET_5_off_IX_d      , OP_BYTE  , "SET 5,(IX+0%02Xh)" , NULL },
    { LD_A_SET_5_off_IX_d , OP_BYTE  , "LD A,SET 5,(IX+0%02Xh)", NULL },
    { LD_B_SET_6_off_IX_d , OP_BYTE  , "LD B,SET 6,(IX+0%02Xh)", NULL },
    { LD_C_SET_6_off_IX_d , OP_BYTE  , "LD C,SET 6,(IX+0%02Xh)", NULL },
    { LD_D_SET_6_off_IX_d , OP_BYTE  , "LD D,SET 6,(IX+0%02Xh)", NULL },
    { LD_E_SET_6_off_IX_d , OP_BYTE  , "LD E,SET 6,(IX+0%02Xh)", NULL },
    { LD_H_SET_6_off_IX_d , OP_BYTE  , "LD H,SET 6,(IX+0%02Xh)", NULL },
    { LD_L_SET_6_off_IX_d , OP_BYTE  , "LD L,SET 6,(IX+0%02Xh)", NULL },
    { SET_6_off_IX_d      , OP_BYTE  , "SET 6,(IX+0%02Xh)" , NULL },
    { LD_A_SET_6_off_IX_d , OP_BYTE  , "LD A,SET 6,(IX+0%02Xh)", NULL },
    { LD_B_SET_7_off_IX_d , OP_BYTE  , "LD B,SET 7,(IX+0%02Xh)", NULL },
    { LD_C_SET_7_off_IX_d , OP_BYTE  , "LD C,SET 7,(IX+0%02Xh)", NULL },
    { LD_D_SET_7_off_IX_d , OP_BYTE  , "LD D,SET 7,(IX+0%02Xh)", NULL },
    { LD_E_SET_7_off_IX_d , OP_BYTE  , "LD E,SET 7,(IX+0%02Xh)", NULL },
    { LD_H_SET_7_off_IX_d , OP_BYTE  , "LD H,SET 7,(IX+0%02Xh)", NULL },
    { LD_L_SET_7_off_IX_d , OP_BYTE  , "LD L,SET 7,(IX+0%02Xh)", NULL },
    { SET_7_off_IX_d      , OP_BYTE  , "SET 7,(IX+0%02Xh)" , NULL },
    { LD_A_SET_7_off_IX_d , OP_BYTE  , "LD A,SET 7,(IX+0%02Xh)", NULL }
} };

static struct Z80OpcodeTable opcodes_CB = { 0, {
    { RLC_B               , OP_NONE  , "RLC B"             , NULL },
    { RLC_C               , OP_NONE  , "RLC C"             , NULL },
    { RLC_D               , OP_NONE  , "RLC D"             , NULL },
    { RLC_E               , OP_NONE  , "RLC E"             , NULL },
    { RLC_H               , OP_NONE  , "RLC H"             , NULL },
    { RLC_L               , OP_NONE  , "RLC L"             , NULL },
    { RLC_off_HL          , OP_NONE  , "RLC (HL)"          , NULL },
    { RLC_A               , OP_NONE  , "RLC A"             , NULL },
    { RRC_B               , OP_NONE  , "RRC B"             , NULL },
    { RRC_C               , OP_NONE  , "RRC C"             , NULL },
    { RRC_D               , OP_NONE  , "RRC D"             , NULL },
    { RRC_E               , OP_NONE  , "RRC E"             , NULL },
    { RRC_H               , OP_NONE  , "RRC H"             , NULL },
    { RRC_L               , OP_NONE  , "RRC L"             , NULL },
    { RRC_off_HL          , OP_NONE  , "RRC (HL)"          , NULL },
    { RRC_A               , OP_NONE  , "RRC A"             , NULL },
    { RL_B                , OP_NONE  , "RL B"              , NULL },
    { RL_C                , OP_NONE  , "RL C"              , NULL },
    { RL_D                , OP_NONE  , "RL D"              , NULL },
    { RL_E                , OP_NONE  , "RL E"              , NULL },
    { RL_H                , OP_NONE  , "RL H"              , NULL },
    { RL_L                , OP_NONE  , "RL L"              , NULL },
    { RL_off_HL           , OP_NONE  , "RL (HL)"           , NULL },
    { RL_A                , OP_NONE  , "RL A"              , NULL },
    { RR_B                , OP_NONE  , "RR B"              , NULL },
    { RR_C                , OP_NONE  , "RR C"              , NULL },
    { RR_D                , OP_NONE  , "RR D"              , NULL },
    { RR_E                , OP_NONE  , "RR E"              , NULL },
    { RR_H                , OP_NONE  , "RR H"              , NULL },
    { RR_L                , OP_NONE  , "RR L"              , NULL },
    { RR_off_HL           , OP_NONE  , "RR (HL)"           , NULL },
    { RR_A                , OP_NONE  , "RR A"              , NULL },
    { SLA_B               , OP_NONE  , "SLA B"             , NULL },
    { SLA_C               , OP_NONE  , "SLA C"             , NULL },
    { SLA_D               , OP_NONE  , "SLA D"             , NULL },
    { SLA_E               , OP_NONE  , "SLA E"             , NULL },
    { SLA_H               , OP_NONE  , "SLA H"             , NULL },
    { SLA_L               , OP_NONE  , "SLA L"             , NULL },
    { SLA_off_HL          , OP_NONE  , "SLA (HL)"          , NULL },
    { SLA_A               , OP_NONE  , "SLA A"             , NULL },
    { SRA_B               , OP_NONE  , "SRA B"             , NULL },
    { SRA_C               , OP_NONE  , "SRA C"             , NULL },
    { SRA_D               , OP_NONE  , "SRA D"             , NULL },
    { SRA_E               , OP_NONE  , "SRA E"             , NULL },
    { SRA_H               , OP_NONE  , "SRA H"             , NULL },
    { SRA_L               , OP_NONE  , "SRA L"             , NULL },
    { SRA_off_HL          , OP_NONE  , "SRA (HL)"          , NULL },
    { SRA_A               , OP_NONE  , "SRA A"             , NULL },
    { SLL_B               , OP_NONE  , "SLL B"             , NULL },
    { SLL_C               , OP_NONE  , "SLL C"             , NULL },
    { SLL_D               , OP_NONE  , "SLL D"             , NULL },
    { SLL_E               , OP_NONE  , "SLL E"             , NULL },
    { SLL_H               , OP_NONE  , "SLL H"             , NULL },
    { SLL_L               , OP_NONE  , "SLL L"             , NULL },
    { SLL_off_HL          , OP_NONE  , "SLL (HL)"          , NULL },
    { SLL_A               , OP_NONE  , "SLL A"             , NULL },
    { SRL_B               , OP_NONE  , "SRL B"             , NULL },
    { SRL_C               , OP_NONE  , "SRL C"             , NULL },
    { SRL_D               , OP_NONE  , "SRL D"             , NULL },
    { SRL_E               , OP_NONE  , "SRL E"             , NULL },
    { SRL_H               , OP_NONE  , "SRL H"             , NULL },
    { SRL_L               , OP_NONE  , "SRL L"             , NULL },
    { SRL_off_HL          , OP_NONE  , "SRL (HL)"          , NULL },
    { SRL_A               , OP_NONE  , "SRL A"             , NULL },
    { BIT_0_B             , OP_NONE  , "BIT 0,B"           , NULL },
    { BIT_0_C             , OP_NONE  , "BIT 0,C"           , NULL },
    { BIT_0_D             , OP_NONE  , "BIT 0,D"           , NULL },
    { BIT_0_E             , OP_NONE  , "BIT 0,E"           , NULL },
    { BIT_0_H             , OP_NONE  , "BIT 0,H"           , NULL },
    { BIT_0_L             , OP_NONE  , "BIT 0,L"           , NULL },
    { BIT_0_off_HL        , OP_NONE  , "BIT 0,(HL)"        , NULL },
    { BIT_0_A             , OP_NONE  , "BIT 0,A"           , NULL },
    { BIT_1_B             , OP_NONE  , "BIT 1,B"           , NULL },
    { BIT_1_C             , OP_NONE  , "BIT 1,C"           , NULL },
    { BIT_1_D             , OP_NONE  , "BIT 1,D"           , NULL },
    { BIT_1_E             , OP_NONE  , "BIT 1,E"           , NULL },
    { BIT_1_H             , OP_NONE  , "BIT 1,H"           , NULL },
    { BIT_1_L             , OP_NONE  , "BIT 1,L"           , NULL },
    { BIT_1_off_HL        , OP_NONE  , "BIT 1,(HL)"        , NULL },
    { BIT_1_A             , OP_NONE  , "BIT 1,A"           , NULL },
    { BIT_2_B             , OP_NONE  , "BIT 2,B"           , NULL },
    { BIT_2_C             , OP_NONE  , "BIT 2,C"           , NULL },
    { BIT_2_D             , OP_NONE  , "BIT 2,D"           , NULL },
    { BIT_2_E             , OP_NONE  , "BIT 2,E"           , NULL },
    { BIT_2_H             , OP_NONE  , "BIT 2,H"           , NULL },
    { BIT_2_L             , OP_NONE  , "BIT 2,L"           , NULL },
    { BIT_2_off_HL        , OP_NONE  , "BIT 2,(HL)"        , NULL },
    { BIT_2_A             , OP_NONE  , "BIT 2,A"           , NULL },
    { BIT_3_B             , OP_NONE  , "BIT 3,B"           , NULL },
    { BIT_3_C             , OP_NONE  , "BIT 3,C"           , NULL },
    { BIT_3_D             , OP_NONE  , "BIT 3,D"           , NULL },
    { BIT_3_E             , OP_NONE  , "BIT 3,E"           , NULL },
    { BIT_3_H             , OP_NONE  , "BIT 3,H"           , NULL },
    { BIT_3_L             , OP_NONE  , "BIT 3,L"           , NULL },
    { BIT_3_off_HL        , OP_NONE  , "BIT 3,(HL)"        , NULL },
    { BIT_3_A             , OP_NONE  , "BIT 3,A"           , NULL },
    { BIT_4_B             , OP_NONE  , "BIT 4,B"           , NULL },
    { BIT_4_C             , OP_NONE  , "BIT 4,C"           , NULL },
    { BIT_4_D             , OP_NONE  , "BIT 4,D"           , NULL },
    { BIT_4_E             , OP_NONE  , "BIT 4,E"           , NULL },
    { BIT_4_H             , OP_NONE  , "BIT 4,H"           , NULL },
    { BIT_4_L             , OP_NONE  , "BIT 4,L"           , NULL },
    { BIT_4_off_HL        , OP_NONE  , "BIT 4,(HL)"        , NULL },
    { BIT_4_A             , OP_NONE  , "BIT 4,A"           , NULL },
    { BIT_5_B             , OP_NONE  , "BIT 5,B"           , NULL },
    { BIT_5_C             , OP_NONE  , "BIT 5,C"           , NULL },
    { BIT_5_D             , OP_NONE  , "BIT 5,D"           , NULL },
    { BIT_5_E             , OP_NONE  , "BIT 5,E"           , NULL },
    { BIT_5_H             , OP_NONE  , "BIT 5,H"           , NULL },
    { BIT_5_L             , OP_NONE  , "BIT 5,L"           , NULL },
    { BIT_5_off_HL        , OP_NONE  , "BIT 5,(HL)"        , NULL },
    { BIT_5_A             , OP_NONE  , "BIT 5,A"           , NULL },
    { BIT_6_B             , OP_NONE  , "BIT 6,B"           , NULL },
    { BIT_6_C             , OP_NONE  , "BIT 6,C"           , NULL },
    { BIT_6_D             , OP_NONE  , "BIT 6,D"           , NULL },
    { BIT_6_E             , OP_NONE  , "BIT 6,E"           , NULL },
    { BIT_6_H             , OP_NONE  , "BIT 6,H"           , NULL },
    { BIT_6_L             , OP_NONE  , "BIT 6,L"           , NULL },
    { BIT_6_off_HL        , OP_NONE  , "BIT 6,(HL)"        , NULL },
    { BIT_6_A             , OP_NONE  , "BIT 6,A"           , NULL },
    { BIT_7_B             , OP_NONE  , "BIT 7,B"           , NULL },
    { BIT_7_C             , OP_NONE  , "BIT 7,C"           , NULL },
    { BIT_7_D             , OP_NONE  , "BIT 7,D"           , NULL },
    { BIT_7_E             , OP_NONE  , "BIT 7,E"           , NULL },
    { BIT_7_H             , OP_NONE  , "BIT 7,H"           , NULL },
    { BIT_7_L             , OP_NONE  , "BIT 7,L"           , NULL },
    { BIT_7_off_HL        , OP_NONE  , "BIT 7,(HL)"        , NULL },
    { BIT_7_A             , OP_NONE  , "BIT 7,A"           , NULL },
    { RES_0_B             , OP_NONE  , "RES 0,B"           , NULL },
    { RES_0_C             , OP_NONE  , "RES 0,C"           , NULL },
    { RES_0_D             , OP_NONE  , "RES 0,D"           , NULL },
    { RES_0_E             , OP_NONE  , "RES 0,E"           , NULL },
    { RES_0_H             , OP_NONE  , "RES 0,H"           , NULL },
    { RES_0_L             , OP_NONE  , "RES 0,L"           , NULL },
    { RES_0_off_HL        , OP_NONE  , "RES 0,(HL)"        , NULL },
    { RES_0_A             , OP_NONE  , "RES 0,A"           , NULL },
    { RES_1_B             , OP_NONE  , "RES 1,B"           , NULL },
    { RES_1_C             , OP_NONE  , "RES 1,C"           , NULL },
    { RES_1_D             , OP_NONE  , "RES 1,D"           , NULL },
    { RES_1_E             , OP_NONE  , "RES 1,E"           , NULL },
    { RES_1_H             , OP_NONE  , "RES 1,H"           , NULL },
    { RES_1_L             , OP_NONE  , "RES 1,L"           , NULL },
    { RES_1_off_HL        , OP_NONE  , "RES 1,(HL)"        , NULL },
    { RES_1_A             , OP_NONE  , "RES 1,A"           , NULL },
    { RES_2_B             , OP_NONE  , "RES 2,B"           , NULL },
    { RES_2_C             , OP_NONE  , "RES 2,C"           , NULL },
    { RES_2_D             , OP_NONE  , "RES 2,D"           , NULL },
    { RES_2_E             , OP_NONE  , "RES 2,E"           , NULL },
    { RES_2_H             , OP_NONE  , "RES 2,H"           , NULL },
    { RES_2_L             , OP_NONE  , "RES 2,L"           , NULL },
    { RES_2_off_HL        , OP_NONE  , "RES 2,(HL)"        , NULL },
    { RES_2_A             , OP_NONE  , "RES 2,A"           , NULL },
    { RES_3_B             , OP_NONE  , "RES 3,B"           , NULL },
    { RES_3_C             , OP_NONE  , "RES 3,C"           , NULL },
    { RES_3_D             , OP_NONE  , "RES 3,D"           , NULL },
    { RES_3_E             , OP_NONE  , "RES 3,E"           , NULL },
    { RES_3_H             , OP_NONE  , "RES 3,H"           , NULL },
    { RES_3_L             , OP_NONE  , "RES 3,L"           , NULL },
    { RES_3_off_HL        , OP_NONE  , "RES 3,(HL)"        , NULL },
    { RES_3_A             , OP_NONE  , "RES 3,A"           , NULL },
    { RES_4_B             , OP_NONE  , "RES 4,B"           , NULL },
    { RES_4_C             , OP_NONE  , "RES 4,C"           , NULL },
    { RES_4_D             , OP_NONE  , "RES 4,D"           , NULL },
    { RES_4_E             , OP_NONE  , "RES 4,E"           , NULL },
    { RES_4_H             , OP_NONE  , "RES 4,H"           , NULL },
    { RES_4_L             , OP_NONE  , "RES 4,L"           , NULL },
    { RES_4_off_HL        , OP_NONE  , "RES 4,(HL)"        , NULL },
    { RES_4_A             , OP_NONE  , "RES 4,A"           , NULL },
    { RES_5_B             , OP_NONE  , "RES 5,B"           , NULL },
    { RES_5_C             , OP_NONE  , "RES 5,C"           , NULL },
    { RES_5_D             , OP_NONE  , "RES 5,D"           , NULL },
    { RES_5_E             , OP_NONE  , "RES 5,E"           , NULL },
    { RES_5_H             , OP_NONE  , "RES 5,H"           , NULL },
    { RES_5_L             , OP_NONE  , "RES 5,L"           , NULL },
    { RES_5_off_HL        , OP_NONE  , "RES 5,(HL)"        , NULL },
    { RES_5_A             , OP_NONE  , "RES 5,A"           , NULL },
    { RES_6_B             , OP_NONE  , "RES 6,B"           , NULL },
    { RES_6_C             , OP_NONE  , "RES 6,C"           , NULL },
    { RES_6_D             , OP_NONE  , "RES 6,D"           , NULL },
    { RES_6_E             , OP_NONE  , "RES 6,E"           , NULL },
    { RES_6_H             , OP_NONE  , "RES 6,H"           , NULL },
    { RES_6_L             , OP_NONE  , "RES 6,L"           , NULL },
    { RES_6_off_HL        , OP_NONE  , "RES 6,(HL)"        , NULL },
    { RES_6_A             , OP_NONE  , "RES 6,A"           , NULL },
    { RES_7_B             , OP_NONE  , "RES 7,B"           , NULL },
    { RES_7_C             , OP_NONE  , "RES 7,C"           , NULL },
    { RES_7_D             , OP_NONE  , "RES 7,D"           , NULL },
    { RES_7_E             , OP_NONE  , "RES 7,E"           , NULL },
    { RES_7_H             , OP_NONE  , "RES 7,H"           , NULL },
    { RES_7_L             , OP_NONE  , "RES 7,L"           , NULL },
    { RES_7_off_HL        , OP_NONE  , "RES 7,(HL)"        , NULL },
    { RES_7_A             , OP_NONE  , "RES 7,A"           , NULL },
    { SET_0_B             , OP_NONE  , "SET 0,B"           , NULL },
    { SET_0_C             , OP_NONE  , "SET 0,C"           , NULL },
    { SET_0_D             , OP_NONE  , "SET 0,D"           , NULL },
    { SET_0_E             , OP_NONE  , "SET 0,E"           , NULL },
    { SET_0_H             , OP_NONE  , "SET 0,H"           , NULL },
    { SET_0_L             , OP_NONE  , "SET 0,L"           , NULL },
    { SET_0_off_HL        , OP_NONE  , "SET 0,(HL)"        , NULL },
    { SET_0_A             , OP_NONE  , "SET 0,A"           , NULL },
    { SET_1_B             , OP_NONE  , "SET 1,B"           , NULL },
    { SET_1_C             , OP_NONE  , "SET 1,C"           , NULL },
    { SET_1_D             , OP_NONE  , "SET 1,D"           , NULL },
    { SET_1_E             , OP_NONE  , "SET 1,E"           , NULL },
    { SET_1_H             , OP_NONE  , "SET 1,H"           , NULL },
    { SET_1_L             , OP_NONE  , "SET 1,L"           , NULL },
    { SET_1_off_HL        , OP_NONE  , "SET 1,(HL)"        , NULL },
    { SET_1_A             , OP_NONE  , "SET 1,A"           , NULL },
    { SET_2_B             , OP_NONE  , "SET 2,B"           , NULL },
    { SET_2_C             , OP_NONE  , "SET 2,C"           , NULL },
    { SET_2_D             , OP_NONE  , "SET 2,D"           , NULL },
    { SET_2_E             , OP_NONE  , "SET 2,E"           , NULL },
    { SET_2_H             , OP_NONE  , "SET 2,H"           , NULL },
    { SET_2_L             , OP_NONE  , "SET 2,L"           , NULL },
    { SET_2_off_HL        , OP_NONE  , "SET 2,(HL)"        , NULL },
    { SET_2_A             , OP_NONE  , "SET 2,A"           , NULL },
    { SET_3_B             , OP_NONE  , "SET 3,B"           , NULL },
    { SET_3_C             , OP_NONE  , "SET 3,C"           , NULL },
    { SET_3_D             , OP_NONE  , "SET 3,D"           , NULL },
    { SET_3_E             , OP_NONE  , "SET 3,E"           , NULL },
    { SET_3_H             , OP_NONE  , "SET 3,H"           , NULL },
    { SET_3_L             , OP_NONE  , "SET 3,L"           , NULL },
    { SET_3_off_HL        , OP_NONE  , "SET 3,(HL)"        , NULL },
    { SET_3_A             , OP_NONE  , "SET 3,A"           , NULL },
    { SET_4_B             , OP_NONE  , "SET 4,B"           , NULL },
    { SET_4_C             , OP_NONE  , "SET 4,C"           , NULL },
    { SET_4_D             , OP_NONE  , "SET 4,D"           , NULL },
    { SET_4_E             , OP_NONE  , "SET 4,E"           , NULL },
    { SET_4_H             , OP_NONE  , "SET 4,H"           , NULL },
    { SET_4_L             , OP_NONE  , "SET 4,L"           , NULL },
    { SET_4_off_HL        , OP_NONE  , "SET 4,(HL)"        , NULL },
    { SET_4_A             , OP_NONE  , "SET 4,A"           , NULL },
    { SET_5_B             , OP_NONE  , "SET 5,B"           , NULL },
    { SET_5_C             , OP_NONE  , "SET 5,C"           , NULL },
    { SET_5_D             , OP_NONE  , "SET 5,D"           , NULL },
    { SET_5_E             , OP_NONE  , "SET 5,E"           , NULL },
    { SET_5_H             , OP_NONE  , "SET 5,H"           , NULL },
    { SET_5_L             , OP_NONE  , "SET 5,L"           , NULL },
    { SET_5_off_HL        , OP_NONE  , "SET 5,(HL)"        , NULL },
    { SET_5_A             , OP_NONE  , "SET 5,A"           , NULL },
    { SET_6_B             , OP_NONE  , "SET 6,B"           , NULL },
    { SET_6_C             , OP_NONE  , "SET 6,C"           , NULL },
    { SET_6_D             , OP_NONE  , "SET 6,D"           , NULL },
    { SET_6_E             , OP_NONE  , "SET 6,E"           , NULL },
    { SET_6_H             , OP_NONE  , "SET 6,H"           , NULL },
    { SET_6_L             , OP_NONE  , "SET 6,L"           , NULL },
    { SET_6_off_HL        , OP_NONE  , "SET 6,(HL)"        , NULL },
    { SET_6_A             , OP_NONE  , "SET 6,A"           , NULL },
    { SET_7_B             , OP_NONE  , "SET 7,B"           , NULL },
    { SET_7_C             , OP_NONE  , "SET 7,C"           , NULL },
    { SET_7_D             , OP_NONE  , "SET 7,D"           , NULL },
    { SET_7_E             , OP_NONE  , "SET 7,E"           , NULL },
    { SET_7_H             , OP_NONE  , "SET 7,H"           , NULL },
    { SET_7_L             , OP_NONE  , "SET 7,L"           , NULL },
    { SET_7_off_HL        , OP_NONE  , "SET 7,(HL)"        , NULL },
    { SET_7_A             , OP_NONE  , "SET 7,A"           , NULL }
} };


static struct Z80OpcodeTable opcodes_DD = { 0, {
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_IX_BC           , OP_NONE  , "ADD IX,BC"         , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_IX_DE           , OP_NONE  , "ADD IX,DE"         , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_IX_nn            , OP_WORD  , "LD IX,0%04Xh"      , NULL },
    { LD_off_nn_IX        , OP_WORD  , "LD (0%04Xh),IX"    , NULL },
    { INC_IX              , OP_NONE  , "INC IX"            , NULL },
    { INC_IXh             , OP_NONE  , "INC IXh"           , NULL },
    { DEC_IXh             , OP_NONE  , "DEC IXh"           , NULL },
    { LD_IXh_n            , OP_BYTE  , "LD IXh,0%02Xh"     , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_IX_IX           , OP_NONE  , "ADD IX,IX"         , NULL },
    { LD_IX_off_nn        , OP_WORD  , "LD IX,(0%04Xh)"    , NULL },
    { DEC_IX              , OP_NONE  , "DEC IX"            , NULL },
    { INC_IXl             , OP_NONE  , "INC IXl"           , NULL },
    { DEC_IXl             , OP_NONE  , "DEC IXl"           , NULL },
    { LD_IXl_n            , OP_BYTE  , "LD IXl,0%02Xh"     , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { INC_off_IX_d        , OP_BYTE  , "INC (IX+0%02Xh)"   , NULL },
    { DEC_off_IX_d        , OP_BYTE  , "DEC (IX+0%02Xh)"   , NULL },
    { LD_off_IX_d_n       , OP_BYTE  , "LD (IX+0%02Xh),0%02Xh", NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_IX_SP           , OP_NONE  , "ADD IX,SP"         , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_B_IXh            , OP_NONE  , "LD B,IXh"          , NULL },
    { LD_B_IXl            , OP_NONE  , "LD B,IXl"          , NULL },
    { LD_B_off_IX_d       , OP_BYTE  , "LD B,(IX+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_C_IXh            , OP_NONE  , "LD C,IXh"          , NULL },
    { LD_C_IXl            , OP_NONE  , "LD C,IXl"          , NULL },
    { LD_C_off_IX_d       , OP_BYTE  , "LD C,(IX+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_D_IXh            , OP_NONE  , "LD D,IXh"          , NULL },
    { LD_D_IXl            , OP_NONE  , "LD D,IXl"          , NULL },
    { LD_D_off_IX_d       , OP_BYTE  , "LD D,(IX+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_E_IXh            , OP_NONE  , "LD E,IXh"          , NULL },
    { LD_E_IXl            , OP_NONE  , "LD E,IXl"          , NULL },
    { LD_E_off_IX_d       , OP_BYTE  , "LD E,(IX+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_IXh_B            , OP_NONE  , "LD IXh,B"          , NULL },
    { LD_IXh_C            , OP_NONE  , "LD IXh,C"          , NULL },
    { LD_IXh_D            , OP_NONE  , "LD IXh,D"          , NULL },
    { LD_IXh_E            , OP_NONE  , "LD IXh,E"          , NULL },
    { LD_IXh_IXh          , OP_NONE  , "LD IXh,IXh"        , NULL },
    { LD_IXh_IXl          , OP_NONE  , "LD IXh,IXl"        , NULL },
    { LD_H_off_IX_d       , OP_BYTE  , "LD H,(IX+0%02Xh)"  , NULL },
    { LD_IXh_A            , OP_NONE  , "LD IXh,A"          , NULL },
    { LD_IXl_B            , OP_NONE  , "LD IXl,B"          , NULL },
    { LD_IXl_C            , OP_NONE  , "LD IXl,C"          , NULL },
    { LD_IXl_D            , OP_NONE  , "LD IXl,D"          , NULL },
    { LD_IXl_E            , OP_NONE  , "LD IXl,E"          , NULL },
    { LD_IXl_IXh          , OP_NONE  , "LD IXl,IXh"        , NULL },
    { LD_IXl_IXl          , OP_NONE  , "LD IXl,IXl"        , NULL },
    { LD_L_off_IX_d       , OP_BYTE  , "LD L,(IX+0%02Xh)"  , NULL },
    { LD_IXl_A            , OP_NONE  , "LD IXl,A"          , NULL },
    { LD_off_IX_d_B       , OP_BYTE  , "LD (IX+0%02Xh),B"  , NULL },
    { LD_off_IX_d_C       , OP_BYTE  , "LD (IX+0%02Xh),C"  , NULL },
    { LD_off_IX_d_D       , OP_BYTE  , "LD (IX+0%02Xh),D"  , NULL },
    { LD_off_IX_d_E       , OP_BYTE  , "LD (IX+0%02Xh),E"  , NULL },
    { LD_off_IX_d_H       , OP_BYTE  , "LD (IX+0%02Xh),H"  , NULL },
    { LD_off_IX_d_L       , OP_BYTE  , "LD (IX+0%02Xh),L"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_off_IX_d_A       , OP_BYTE  , "LD (IX+0%02Xh),A"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_A_IXh            , OP_NONE  , "LD A,IXh"          , NULL },
    { LD_A_IXl            , OP_NONE  , "LD A,IXl"          , NULL },
    { LD_A_off_IX_d       , OP_BYTE  , "LD A,(IX+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_A_IXh           , OP_NONE  , "ADD A,IXh"         , NULL },
    { ADD_A_IXl           , OP_NONE  , "ADD A,IXl"         , NULL },
    { ADD_A_off_IX_d      , OP_BYTE  , "ADD A,(IX+0%02Xh)" , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADC_A_IXh           , OP_NONE  , "ADC A,IXh"         , NULL },
    { ADC_A_IXl           , OP_NONE  , "ADC A,IXl"         , NULL },
    { ADC_A_off_IX_d      , OP_BYTE  , "ADC A,(IX+0%02Xh)" , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { SUB_A_IXh           , OP_NONE  , "SUB A,IXh"         , NULL },
    { SUB_A_IXl           , OP_NONE  , "SUB A,IXl"         , NULL },
    { SUB_A_off_IX_d      , OP_BYTE  , "SUB A,(IX+0%02Xh)" , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { SBC_A_IXh           , OP_NONE  , "SBC A,IXh"         , NULL },
    { SBC_A_IXl           , OP_NONE  , "SBC A,IXl"         , NULL },
    { SBC_A_off_IX_d      , OP_BYTE  , "SBC A,(IX+0%02Xh)" , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { AND_IXh             , OP_NONE  , "AND IXh"           , NULL },
    { AND_IXl             , OP_NONE  , "AND IXl"           , NULL },
    { AND_off_IX_d        , OP_BYTE  , "AND (IX+0%02Xh)"   , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { XOR_IXh             , OP_NONE  , "XOR IXh"           , NULL },
    { XOR_IXl             , OP_NONE  , "XOR IXl"           , NULL },
    { XOR_off_IX_d        , OP_BYTE  , "XOR (IX+0%02Xh)"   , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { OR_IXh              , OP_NONE  , "OR IXh"            , NULL },
    { OR_IXl              , OP_NONE  , "OR IXl"            , NULL },
    { OR_off_IX_d         , OP_BYTE  , "OR (IX+0%02Xh)"    , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { CP_IXh              , OP_NONE  , "CP IXh"            , NULL },
    { CP_IXl              , OP_NONE  , "CP IXl"            , NULL },
    { CP_off_IX_d         , OP_BYTE  , "CP (IX+0%02Xh)"    , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , &opcodes_DDCB },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { POP_IX              , OP_NONE  , "POP IX"            , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { EX_off_SP_IX        , OP_NONE  , "EX (SP),IX"        , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { PUSH_IX             , OP_NONE  , "PUSH IX"           , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { JP_off_IX           , OP_NONE  , "JP (IX)"           , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_SP_IX            , OP_NONE  , "LD SP,IX"          , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL }
} };



static struct Z80OpcodeTable opcodes_ED = { 0, {
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { IN_B_off_C          , OP_NONE  , "IN B,(C)"          , NULL },
    { OUT_off_C_B         , OP_NONE  , "OUT (C),B"         , NULL },
    { SBC_HL_BC           , OP_NONE  , "SBC HL,BC"         , NULL },
    { LD_off_nn_BC        , OP_WORD  , "LD (0%04Xh),BC"    , NULL },
    { NEG                 , OP_NONE  , "NEG"               , NULL },
    { RETN                , OP_NONE  , "RETN"              , NULL },
    { IM_0                , OP_NONE  , "IM 0"              , NULL },
    { LD_I_A              , OP_NONE  , "LD I,A"            , NULL },
    { IN_C_off_C          , OP_NONE  , "IN C,(C)"          , NULL },
    { OUT_off_C_C         , OP_NONE  , "OUT (C),C"         , NULL },
    { ADC_HL_BC           , OP_NONE  , "ADC HL,BC"         , NULL },
    { LD_BC_off_nn        , OP_WORD  , "LD BC,(0%04Xh)"    , NULL },
    { NEG                 , OP_NONE  , "NEG"               , NULL },
    { RETI                , OP_NONE  , "RETI"              , NULL },
    { IM_0                , OP_NONE  , "IM 0"              , NULL },
    { LD_R_A              , OP_NONE  , "LD R,A"            , NULL },
    { IN_D_off_C          , OP_NONE  , "IN D,(C)"          , NULL },
    { OUT_off_C_D         , OP_NONE  , "OUT (C),D"         , NULL },
    { SBC_HL_DE           , OP_NONE  , "SBC HL,DE"         , NULL },
    { LD_off_nn_DE        , OP_WORD  , "LD (0%04Xh),DE"    , NULL },
    { NEG                 , OP_NONE  , "NEG"               , NULL },
    { RETN                , OP_NONE  , "RETN"              , NULL },
    { IM_1                , OP_NONE  , "IM 1"              , NULL },
    { LD_A_I              , OP_NONE  , "LD A,I"            , NULL },
    { IN_E_off_C          , OP_NONE  , "IN E,(C)"          , NULL },
    { OUT_off_C_E         , OP_NONE  , "OUT (C),E"         , NULL },
    { ADC_HL_DE           , OP_NONE  , "ADC HL,DE"         , NULL },
    { LD_DE_off_nn        , OP_WORD  , "LD DE,(0%04Xh)"    , NULL },
    { NEG                 , OP_NONE  , "NEG"               , NULL },
    { RETN                , OP_NONE  , "RETN"              , NULL },
    { IM_2                , OP_NONE  , "IM 2"              , NULL },
    { LD_A_R              , OP_NONE  , "LD A,R"            , NULL },
    { IN_H_off_C          , OP_NONE  , "IN H,(C)"          , NULL },
    { OUT_off_C_H         , OP_NONE  , "OUT (C),H"         , NULL },
    { SBC_HL_HL           , OP_NONE  , "SBC HL,HL"         , NULL },
    { LD_off_nn_HL        , OP_WORD  , "LD (0%04Xh),HL"    , NULL },
    { NEG                 , OP_NONE  , "NEG"               , NULL },
    { RETN                , OP_NONE  , "RETN"              , NULL },
    { IM_0                , OP_NONE  , "IM 0"              , NULL },
    { RRD                 , OP_NONE  , "RRD"               , NULL },
    { IN_L_off_C          , OP_NONE  , "IN L,(C)"          , NULL },
    { OUT_off_C_L         , OP_NONE  , "OUT (C),L"         , NULL },
    { ADC_HL_HL           , OP_NONE  , "ADC HL,HL"         , NULL },
    { LD_HL_off_nn        , OP_WORD  , "LD HL,(0%04Xh)"    , NULL },
    { NEG                 , OP_NONE  , "NEG"               , NULL },
    { RETN                , OP_NONE  , "RETN"              , NULL },
    { IM_0                , OP_NONE  , "IM 0"              , NULL },
    { RLD                 , OP_NONE  , "RLD"               , NULL },
    { IN_F_off_C          , OP_NONE  , "IN F,(C)"          , NULL },
    { OUT_off_C_0         , OP_NONE  , "OUT (C),0"         , NULL },
    { SBC_HL_SP           , OP_NONE  , "SBC HL,SP"         , NULL },
    { LD_off_nn_SP        , OP_WORD  , "LD (0%04Xh),SP"    , NULL },
    { NEG                 , OP_NONE  , "NEG"               , NULL },
    { RETN                , OP_NONE  , "RETN"              , NULL },
    { IM_1                , OP_NONE  , "IM 1"              , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { IN_A_off_C          , OP_NONE  , "IN A,(C)"          , NULL },
    { OUT_off_C_A         , OP_NONE  , "OUT (C),A"         , NULL },
    { ADC_HL_SP           , OP_NONE  , "ADC HL,SP"         , NULL },
    { LD_SP_off_nn        , OP_WORD  , "LD SP,(0%04Xh)"    , NULL },
    { NEG                 , OP_NONE  , "NEG"               , NULL },
    { RETN                , OP_NONE  , "RETN"              , NULL },
    { IM_2                , OP_NONE  , "IM 2"              , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LDI                 , OP_NONE  , "LDI"               , NULL },
    { CPI                 , OP_NONE  , "CPI"               , NULL },
    { INI                 , OP_NONE  , "INI"               , NULL },
    { OUTI                , OP_NONE  , "OUTI"              , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LDD                 , OP_NONE  , "LDD"               , NULL },
    { CPD                 , OP_NONE  , "CPD"               , NULL },
    { IND                 , OP_NONE  , "IND"               , NULL },
    { OUTD                , OP_NONE  , "OUTD"              , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LDIR                , OP_NONE  , "LDIR"              , NULL },
    { CPIR                , OP_NONE  , "CPIR"              , NULL },
    { INIR                , OP_NONE  , "INIR"              , NULL },
    { OTIR                , OP_NONE  , "OTIR"              , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LDDR                , OP_NONE  , "LDDR"              , NULL },
    { CPDR                , OP_NONE  , "CPDR"              , NULL },
    { INDR                , OP_NONE  , "INDR"              , NULL },
    { OTDR                , OP_NONE  , "OTDR"              , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL }
} };


static struct Z80OpcodeTable opcodes_FD = { 0, {
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_IY_BC           , OP_NONE  , "ADD IY,BC"         , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_IY_DE           , OP_NONE  , "ADD IY,DE"         , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_IY_nn            , OP_WORD  , "LD IY,0%04Xh"      , NULL },
    { LD_off_nn_IY        , OP_WORD  , "LD (0%04Xh),IY"    , NULL },
    { INC_IY              , OP_NONE  , "INC IY"            , NULL },
    { INC_IYh             , OP_NONE  , "INC IYh"           , NULL },
    { DEC_IYh             , OP_NONE  , "DEC IYh"           , NULL },
    { LD_IYh_n            , OP_BYTE  , "LD IYh,0%02Xh"     , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_IY_IY           , OP_NONE  , "ADD IY,IY"         , NULL },
    { LD_IY_off_nn        , OP_WORD  , "LD IY,(0%04Xh)"    , NULL },
    { DEC_IY              , OP_NONE  , "DEC IY"            , NULL },
    { INC_IYl             , OP_NONE  , "INC IYl"           , NULL },
    { DEC_IYl             , OP_NONE  , "DEC IYl"           , NULL },
    { LD_IYl_n            , OP_BYTE  , "LD IYl,0%02Xh"     , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { INC_off_IY_d        , OP_BYTE  , "INC (IY+0%02Xh)"   , NULL },
    { DEC_off_IY_d        , OP_BYTE  , "DEC (IY+0%02Xh)"   , NULL },
    { LD_off_IY_d_n       , OP_BYTE  , "LD (IY+0%02Xh),0%02Xh", NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_IY_SP           , OP_NONE  , "ADD IY,SP"         , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_B_IYh            , OP_NONE  , "LD B,IYh"          , NULL },
    { LD_B_IYl            , OP_NONE  , "LD B,IYl"          , NULL },
    { LD_B_off_IY_d       , OP_BYTE  , "LD B,(IY+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_C_IYh            , OP_NONE  , "LD C,IYh"          , NULL },
    { LD_C_IYl            , OP_NONE  , "LD C,IYl"          , NULL },
    { LD_C_off_IY_d       , OP_BYTE  , "LD C,(IY+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_D_IYh            , OP_NONE  , "LD D,IYh"          , NULL },
    { LD_D_IYl            , OP_NONE  , "LD D,IYl"          , NULL },
    { LD_D_off_IY_d       , OP_BYTE  , "LD D,(IY+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_E_IYh            , OP_NONE  , "LD E,IYh"          , NULL },
    { LD_E_IYl            , OP_NONE  , "LD E,IYl"          , NULL },
    { LD_E_off_IY_d       , OP_BYTE  , "LD E,(IY+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_IYh_B            , OP_NONE  , "LD IYh,B"          , NULL },
    { LD_IYh_C            , OP_NONE  , "LD IYh,C"          , NULL },
    { LD_IYh_D            , OP_NONE  , "LD IYh,D"          , NULL },
    { LD_IYh_E            , OP_NONE  , "LD IYh,E"          , NULL },
    { LD_IYh_IYh          , OP_NONE  , "LD IYh,IYh"        , NULL },
    { LD_IYh_IYl          , OP_NONE  , "LD IYh,IYl"        , NULL },
    { LD_H_off_IY_d       , OP_BYTE  , "LD H,(IY+0%02Xh)"  , NULL },
    { LD_IYh_A            , OP_NONE  , "LD IYh,A"          , NULL },
    { LD_IYl_B            , OP_NONE  , "LD IYl,B"          , NULL },
    { LD_IYl_C            , OP_NONE  , "LD IYl,C"          , NULL },
    { LD_IYl_D            , OP_NONE  , "LD IYl,D"          , NULL },
    { LD_IYl_E            , OP_NONE  , "LD IYl,E"          , NULL },
    { LD_IYl_IYh          , OP_NONE  , "LD IYl,IYh"        , NULL },
    { LD_IYl_IYl          , OP_NONE  , "LD IYl,IYl"        , NULL },
    { LD_L_off_IY_d       , OP_BYTE  , "LD L,(IY+0%02Xh)"  , NULL },
    { LD_IYl_A            , OP_NONE  , "LD IYl,A"          , NULL },
    { LD_off_IY_d_B       , OP_BYTE  , "LD (IY+0%02Xh),B"  , NULL },
    { LD_off_IY_d_C       , OP_BYTE  , "LD (IY+0%02Xh),C"  , NULL },
    { LD_off_IY_d_D       , OP_BYTE  , "LD (IY+0%02Xh),D"  , NULL },
    { LD_off_IY_d_E       , OP_BYTE  , "LD (IY+0%02Xh),E"  , NULL },
    { LD_off_IY_d_H       , OP_BYTE  , "LD (IY+0%02Xh),H"  , NULL },
    { LD_off_IY_d_L       , OP_BYTE  , "LD (IY+0%02Xh),L"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_off_IY_d_A       , OP_BYTE  , "LD (IY+0%02Xh),A"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_A_IYh            , OP_NONE  , "LD A,IYh"          , NULL },
    { LD_A_IYl            , OP_NONE  , "LD A,IYl"          , NULL },
    { LD_A_off_IY_d       , OP_BYTE  , "LD A,(IY+0%02Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADD_A_IYh           , OP_NONE  , "ADD A,IYh"         , NULL },
    { ADD_A_IYl           , OP_NONE  , "ADD A,IYl"         , NULL },
    { ADD_A_off_IY_d      , OP_BYTE  , "ADD A,(IY+0%02Xh)" , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { ADC_A_IYh           , OP_NONE  , "ADC A,IYh"         , NULL },
    { ADC_A_IYl           , OP_NONE  , "ADC A,IYl"         , NULL },
    { ADC_A_off_IY_d      , OP_BYTE  , "ADC A,(IY+0%02Xh)" , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { SUB_A_IYh           , OP_NONE  , "SUB A,IYh"         , NULL },
    { SUB_A_IYl           , OP_NONE  , "SUB A,IYl"         , NULL },
    { SUB_A_off_IY_d      , OP_BYTE  , "SUB A,(IY+0%02Xh)" , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { SBC_A_IYh           , OP_NONE  , "SBC A,IYh"         , NULL },
    { SBC_A_IYl           , OP_NONE  , "SBC A,IYl"         , NULL },
    { SBC_A_off_IY_d      , OP_BYTE  , "SBC A,(IY+0%02Xh)" , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { AND_IYh             , OP_NONE  , "AND IYh"           , NULL },
    { AND_IYl             , OP_NONE  , "AND IYl"           , NULL },
    { AND_off_IY_d        , OP_BYTE  , "AND (IY+0%02Xh)"   , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { XOR_IYh             , OP_NONE  , "XOR IYh"           , NULL },
    { XOR_IYl             , OP_NONE  , "XOR IYl"           , NULL },
    { XOR_off_IY_d        , OP_BYTE  , "XOR (IY+0%02Xh)"   , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { OR_IYh              , OP_NONE  , "OR IYh"            , NULL },
    { OR_IYl              , OP_NONE  , "OR IYl"            , NULL },
    { OR_off_IY_d         , OP_BYTE  , "OR (IY+0%02Xh)"    , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { CP_IYh              , OP_NONE  , "CP IYh"            , NULL },
    { CP_IYl              , OP_NONE  , "CP IYl"            , NULL },
    { CP_off_IY_d         , OP_BYTE  , "CP (IY+0%02Xh)"    , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , &opcodes_FDCB },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { POP_IY              , OP_NONE  , "POP IY"            , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { EX_off_SP_IY        , OP_NONE  , "EX (SP),IY"        , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { PUSH_IY             , OP_NONE  , "PUSH IY"           , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { JP_off_IY           , OP_NONE  , "JP (IY)"           , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { LD_SP_IY            , OP_NONE  , "LD SP,IY"          , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL },
    { NULL                , OP_NONE  , NULL                , NULL }
} };




static struct Z80OpcodeTable opcodes_main = { 0, {
    { NOP                 , OP_NONE  , "NOP"               , NULL },
    { LD_BC_nn            , OP_WORD  , "LD BC,0%04Xh"      , NULL },
    { LD_off_BC_A         , OP_NONE  , "LD (BC),A"         , NULL },
    { INC_BC              , OP_NONE  , "INC BC"            , NULL },
    { INC_B               , OP_NONE  , "INC B"             , NULL },
    { DEC_B               , OP_NONE  , "DEC B"             , NULL },
    { LD_B_n              , OP_BYTE  , "LD B,0%02Xh"       , NULL },
    { RLCA                , OP_NONE  , "RLCA"              , NULL },
    { EX_AF_AF_           , OP_NONE  , "EX AF,AF'"         , NULL },
    { ADD_HL_BC           , OP_NONE  , "ADD HL,BC"         , NULL },
    { LD_A_off_BC         , OP_NONE  , "LD A,(BC)"         , NULL },
    { DEC_BC              , OP_NONE  , "DEC BC"            , NULL },
    { INC_C               , OP_NONE  , "INC C"             , NULL },
    { DEC_C               , OP_NONE  , "DEC C"             , NULL },
    { LD_C_n              , OP_BYTE  , "LD C,0%02Xh"       , NULL },
    { RRCA                , OP_NONE  , "RRCA"              , NULL },
    { DJNZ_off_PC_e_      , OP_OFFSET, "DJNZ (PC+%d) "     , NULL },
    { LD_DE_nn            , OP_WORD  , "LD DE,0%04Xh"      , NULL },
    { LD_off_DE_A         , OP_NONE  , "LD (DE),A"         , NULL },
    { INC_DE              , OP_NONE  , "INC DE"            , NULL },
    { INC_D               , OP_NONE  , "INC D"             , NULL },
    { DEC_D               , OP_NONE  , "DEC D"             , NULL },
    { LD_D_n              , OP_BYTE  , "LD D,0%02Xh"       , NULL },
    { RLA                 , OP_NONE  , "RLA"               , NULL },
    { JR_off_PC_e         , OP_OFFSET, "JR (PC+%d)"        , NULL },
    { ADD_HL_DE           , OP_NONE  , "ADD HL,DE"         , NULL },
    { LD_A_off_DE         , OP_NONE  , "LD A,(DE)"         , NULL },
    { DEC_DE              , OP_NONE  , "DEC DE"            , NULL },
    { INC_E               , OP_NONE  , "INC E"             , NULL },
    { DEC_E               , OP_NONE  , "DEC E"             , NULL },
    { LD_E_n              , OP_BYTE  , "LD E,0%02Xh"       , NULL },
    { RRA                 , OP_NONE  , "RRA"               , NULL },
    { JR_NZ_off_PC_e      , OP_OFFSET, "JR NZ,(PC+%d)"     , NULL },
    { LD_HL_nn            , OP_WORD  , "LD HL,0%04Xh"      , NULL },
    { LD_off_nn_HL        , OP_WORD  , "LD (0%04Xh),HL"    , NULL },
    { INC_HL              , OP_NONE  , "INC HL"            , NULL },
    { INC_H               , OP_NONE  , "INC H"             , NULL },
    { DEC_H               , OP_NONE  , "DEC H"             , NULL },
    { LD_H_n              , OP_BYTE  , "LD H,0%02Xh"       , NULL },
    { DAA                 , OP_NONE  , "DAA"               , NULL },
    { JR_Z_off_PC_e       , OP_OFFSET, "JR Z,(PC+%d)"      , NULL },
    { ADD_HL_HL           , OP_NONE  , "ADD HL,HL"         , NULL },
    { LD_HL_off_nn        , OP_WORD  , "LD HL,(0%04Xh)"    , NULL },
    { DEC_HL              , OP_NONE  , "DEC HL"            , NULL },
    { INC_L               , OP_NONE  , "INC L"             , NULL },
    { DEC_L               , OP_NONE  , "DEC L"             , NULL },
    { LD_L_n              , OP_BYTE  , "LD L,0%02Xh"       , NULL },
    { CPL                 , OP_NONE  , "CPL"               , NULL },
    { JR_NC_off_PC_e      , OP_OFFSET, "JR NC,(PC+%d)"     , NULL },
    { LD_SP_nn            , OP_WORD  , "LD SP,0%04Xh"      , NULL },
    { LD_off_nn_A         , OP_WORD  , "LD (0%04Xh),A"     , NULL },
    { INC_SP              , OP_NONE  , "INC SP"            , NULL },
    { INC_off_HL          , OP_NONE  , "INC (HL)"          , NULL },
    { DEC_off_HL          , OP_NONE  , "DEC (HL)"          , NULL },
    { LD_off_HL_n         , OP_BYTE  , "LD (HL),0%02Xh"    , NULL },
    { SCF                 , OP_NONE  , "SCF"               , NULL },
    { JR_C_off_PC_e       , OP_OFFSET, "JR C,(PC+%d)"      , NULL },
    { ADD_HL_SP           , OP_NONE  , "ADD HL,SP"         , NULL },
    { LD_A_off_nn         , OP_WORD  , "LD A,(0%04Xh)"     , NULL },
    { DEC_SP              , OP_NONE  , "DEC SP"            , NULL },
    { INC_A               , OP_NONE  , "INC A"             , NULL },
    { DEC_A               , OP_NONE  , "DEC A"             , NULL },
    { LD_A_n              , OP_BYTE  , "LD A,0%02Xh"       , NULL },
    { CCF                 , OP_NONE  , "CCF"               , NULL },
    { LD_B_B              , OP_NONE  , "LD B,B"            , NULL },
    { LD_B_C              , OP_NONE  , "LD B,C"            , NULL },
    { LD_B_D              , OP_NONE  , "LD B,D"            , NULL },
    { LD_B_E              , OP_NONE  , "LD B,E"            , NULL },
    { LD_B_H              , OP_NONE  , "LD B,H"            , NULL },
    { LD_B_L              , OP_NONE  , "LD B,L"            , NULL },
    { LD_B_off_HL         , OP_NONE  , "LD B,(HL)"         , NULL },
    { LD_B_A              , OP_NONE  , "LD B,A"            , NULL },
    { LD_C_B              , OP_NONE  , "LD C,B"            , NULL },
    { LD_C_C              , OP_NONE  , "LD C,C"            , NULL },
    { LD_C_D              , OP_NONE  , "LD C,D"            , NULL },
    { LD_C_E              , OP_NONE  , "LD C,E"            , NULL },
    { LD_C_H              , OP_NONE  , "LD C,H"            , NULL },
    { LD_C_L              , OP_NONE  , "LD C,L"            , NULL },
    { LD_C_off_HL         , OP_NONE  , "LD C,(HL)"         , NULL },
    { LD_C_A              , OP_NONE  , "LD C,A"            , NULL },
    { LD_D_B              , OP_NONE  , "LD D,B"            , NULL },
    { LD_D_C              , OP_NONE  , "LD D,C"            , NULL },
    { LD_D_D              , OP_NONE  , "LD D,D"            , NULL },
    { LD_D_E              , OP_NONE  , "LD D,E"            , NULL },
    { LD_D_H              , OP_NONE  , "LD D,H"            , NULL },
    { LD_D_L              , OP_NONE  , "LD D,L"            , NULL },
    { LD_D_off_HL         , OP_NONE  , "LD D,(HL)"         , NULL },
    { LD_D_A              , OP_NONE  , "LD D,A"            , NULL },
    { LD_E_B              , OP_NONE  , "LD E,B"            , NULL },
    { LD_E_C              , OP_NONE  , "LD E,C"            , NULL },
    { LD_E_D              , OP_NONE  , "LD E,D"            , NULL },
    { LD_E_E              , OP_NONE  , "LD E,E"            , NULL },
    { LD_E_H              , OP_NONE  , "LD E,H"            , NULL },
    { LD_E_L              , OP_NONE  , "LD E,L"            , NULL },
    { LD_E_off_HL         , OP_NONE  , "LD E,(HL)"         , NULL },
    { LD_E_A              , OP_NONE  , "LD E,A"            , NULL },
    { LD_H_B              , OP_NONE  , "LD H,B"            , NULL },
    { LD_H_C              , OP_NONE  , "LD H,C"            , NULL },
    { LD_H_D              , OP_NONE  , "LD H,D"            , NULL },
    { LD_H_E              , OP_NONE  , "LD H,E"            , NULL },
    { LD_H_H              , OP_NONE  , "LD H,H"            , NULL },
    { LD_H_L              , OP_NONE  , "LD H,L"            , NULL },
    { LD_H_off_HL         , OP_NONE  , "LD H,(HL)"         , NULL },
    { LD_H_A              , OP_NONE  , "LD H,A"            , NULL },
    { LD_L_B              , OP_NONE  , "LD L,B"            , NULL },
    { LD_L_C              , OP_NONE  , "LD L,C"            , NULL },
    { LD_L_D              , OP_NONE  , "LD L,D"            , NULL },
    { LD_L_E              , OP_NONE  , "LD L,E"            , NULL },
    { LD_L_H              , OP_NONE  , "LD L,H"            , NULL },
    { LD_L_L              , OP_NONE  , "LD L,L"            , NULL },
    { LD_L_off_HL         , OP_NONE  , "LD L,(HL)"         , NULL },
    { LD_L_A              , OP_NONE  , "LD L,A"            , NULL },
    { LD_off_HL_B         , OP_NONE  , "LD (HL),B"         , NULL },
    { LD_off_HL_C         , OP_NONE  , "LD (HL),C"         , NULL },
    { LD_off_HL_D         , OP_NONE  , "LD (HL),D"         , NULL },
    { LD_off_HL_E         , OP_NONE  , "LD (HL),E"         , NULL },
    { LD_off_HL_H         , OP_NONE  , "LD (HL),H"         , NULL },
    { LD_off_HL_L         , OP_NONE  , "LD (HL),L"         , NULL },
    { HALT                , OP_NONE  , "HALT"              , NULL },
    { LD_off_HL_A         , OP_NONE  , "LD (HL),A"         , NULL },
    { LD_A_B              , OP_NONE  , "LD A,B"            , NULL },
    { LD_A_C              , OP_NONE  , "LD A,C"            , NULL },
    { LD_A_D              , OP_NONE  , "LD A,D"            , NULL },
    { LD_A_E              , OP_NONE  , "LD A,E"            , NULL },
    { LD_A_H              , OP_NONE  , "LD A,H"            , NULL },
    { LD_A_L              , OP_NONE  , "LD A,L"            , NULL },
    { LD_A_off_HL         , OP_NONE  , "LD A,(HL)"         , NULL },
    { LD_A_A              , OP_NONE  , "LD A,A"            , NULL },
    { ADD_A_B             , OP_NONE  , "ADD A,B"           , NULL },
    { ADD_A_C             , OP_NONE  , "ADD A,C"           , NULL },
    { ADD_A_D             , OP_NONE  , "ADD A,D"           , NULL },
    { ADD_A_E             , OP_NONE  , "ADD A,E"           , NULL },
    { ADD_A_H             , OP_NONE  , "ADD A,H"           , NULL },
    { ADD_A_L             , OP_NONE  , "ADD A,L"           , NULL },
    { ADD_A_off_HL        , OP_NONE  , "ADD A,(HL)"        , NULL },
    { ADD_A_A             , OP_NONE  , "ADD A,A"           , NULL },
    { ADC_A_B             , OP_NONE  , "ADC A,B"           , NULL },
    { ADC_A_C             , OP_NONE  , "ADC A,C"           , NULL },
    { ADC_A_D             , OP_NONE  , "ADC A,D"           , NULL },
    { ADC_A_E             , OP_NONE  , "ADC A,E"           , NULL },
    { ADC_A_H             , OP_NONE  , "ADC A,H"           , NULL },
    { ADC_A_L             , OP_NONE  , "ADC A,L"           , NULL },
    { ADC_A_off_HL        , OP_NONE  , "ADC A,(HL)"        , NULL },
    { ADC_A_A             , OP_NONE  , "ADC A,A"           , NULL },
    { SUB_A_B             , OP_NONE  , "SUB A,B"           , NULL },
    { SUB_A_C             , OP_NONE  , "SUB A,C"           , NULL },
    { SUB_A_D             , OP_NONE  , "SUB A,D"           , NULL },
    { SUB_A_E             , OP_NONE  , "SUB A,E"           , NULL },
    { SUB_A_H             , OP_NONE  , "SUB A,H"           , NULL },
    { SUB_A_L             , OP_NONE  , "SUB A,L"           , NULL },
    { SUB_A_off_HL        , OP_NONE  , "SUB A,(HL)"        , NULL },
    { SUB_A_A             , OP_NONE  , "SUB A,A"           , NULL },
    { SBC_A_B             , OP_NONE  , "SBC A,B"           , NULL },
    { SBC_A_C             , OP_NONE  , "SBC A,C"           , NULL },
    { SBC_A_D             , OP_NONE  , "SBC A,D"           , NULL },
    { SBC_A_E             , OP_NONE  , "SBC A,E"           , NULL },
    { SBC_A_H             , OP_NONE  , "SBC A,H"           , NULL },
    { SBC_A_L             , OP_NONE  , "SBC A,L"           , NULL },
    { SBC_A_off_HL        , OP_NONE  , "SBC A,(HL)"        , NULL },
    { SBC_A_A             , OP_NONE  , "SBC A,A"           , NULL },
    { AND_B               , OP_NONE  , "AND B"             , NULL },
    { AND_C               , OP_NONE  , "AND C"             , NULL },
    { AND_D               , OP_NONE  , "AND D"             , NULL },
    { AND_E               , OP_NONE  , "AND E"             , NULL },
    { AND_H               , OP_NONE  , "AND H"             , NULL },
    { AND_L               , OP_NONE  , "AND L"             , NULL },
    { AND_off_HL          , OP_NONE  , "AND (HL)"          , NULL },
    { AND_A               , OP_NONE  , "AND A"             , NULL },
    { XOR_B               , OP_NONE  , "XOR B"             , NULL },
    { XOR_C               , OP_NONE  , "XOR C"             , NULL },
    { XOR_D               , OP_NONE  , "XOR D"             , NULL },
    { XOR_E               , OP_NONE  , "XOR E"             , NULL },
    { XOR_H               , OP_NONE  , "XOR H"             , NULL },
    { XOR_L               , OP_NONE  , "XOR L"             , NULL },
    { XOR_off_HL          , OP_NONE  , "XOR (HL)"          , NULL },
    { XOR_A               , OP_NONE  , "XOR A"             , NULL },
    { OR_B                , OP_NONE  , "OR B"              , NULL },
    { OR_C                , OP_NONE  , "OR C"              , NULL },
    { OR_D                , OP_NONE  , "OR D"              , NULL },
    { OR_E                , OP_NONE  , "OR E"              , NULL },
    { OR_H                , OP_NONE  , "OR H"              , NULL },
    { OR_L                , OP_NONE  , "OR L"              , NULL },
    { OR_off_HL           , OP_NONE  , "OR (HL)"           , NULL },
    { OR_A                , OP_NONE  , "OR A"              , NULL },
    { CP_B                , OP_NONE  , "CP B"              , NULL },
    { CP_C                , OP_NONE  , "CP C"              , NULL },
    { CP_D                , OP_NONE  , "CP D"              , NULL },
    { CP_E                , OP_NONE  , "CP E"              , NULL },
    { CP_H                , OP_NONE  , "CP H"              , NULL },
    { CP_L                , OP_NONE  , "CP L"              , NULL },
    { CP_off_HL           , OP_NONE  , "CP (HL)"           , NULL },
    { CP_A                , OP_NONE  , "CP A"              , NULL },
    { RET_NZ              , OP_NONE  , "RET NZ"            , NULL },
    { POP_BC              , OP_NONE  , "POP BC"            , NULL },
    { JP_NZ_off_nn        , OP_WORD  , "JP NZ,(0%04Xh)"    , NULL },
    { JP_off_nn           , OP_WORD  , "JP (0%04Xh)"       , NULL },
    { CALL_NZ_off_nn      , OP_WORD  , "CALL NZ,(0%04Xh)"  , NULL },
    { PUSH_BC             , OP_NONE  , "PUSH BC"           , NULL },
    { ADD_A_n             , OP_BYTE  , "ADD A,0%02Xh"      , NULL },
    { RST_0H              , OP_NONE  , "RST 0H"            , NULL },
    { RET_Z               , OP_NONE  , "RET Z"             , NULL },
    { RET                 , OP_NONE  , "RET"               , NULL },
    { JP_Z_off_nn         , OP_WORD  , "JP Z,(0%04Xh)"     , NULL },
    { NULL                , OP_NONE  , NULL                , &opcodes_CB },
    { CALL_Z_off_nn       , OP_WORD  , "CALL Z,(0%04Xh)"   , NULL },
    { CALL_off_nn         , OP_WORD  , "CALL (0%04Xh)"     , NULL },
    { ADC_A_n             , OP_BYTE  , "ADC A,0%02Xh"      , NULL },
    { RST_8H              , OP_NONE  , "RST 8H"            , NULL },
    { RET_NC              , OP_NONE  , "RET NC"            , NULL },
    { POP_DE              , OP_NONE  , "POP DE"            , NULL },
    { JP_NC_off_nn        , OP_WORD  , "JP NC,(0%04Xh)"    , NULL },
    { OUT_off_n_A         , OP_BYTE  , "OUT (0%02Xh),A"    , NULL },
    { CALL_NC_off_nn      , OP_WORD  , "CALL NC,(0%04Xh)"  , NULL },
    { PUSH_DE             , OP_NONE  , "PUSH DE"           , NULL },
    { SUB_A_n             , OP_BYTE  , "SUB A,0%02Xh"      , NULL },
    { RST_10H             , OP_NONE  , "RST 10H"           , NULL },
    { RET_C               , OP_NONE  , "RET C"             , NULL },
    { EXX                 , OP_NONE  , "EXX"               , NULL },
    { JP_C_off_nn         , OP_WORD  , "JP C,(0%04Xh)"     , NULL },
    { IN_A_off_n          , OP_BYTE  , "IN A,(0%02Xh)"     , NULL },
    { CALL_C_off_nn       , OP_WORD  , "CALL C,(0%04Xh)"   , NULL },
    { NULL                , OP_NONE  , NULL                , &opcodes_DD },
    { SBC_A_n             , OP_BYTE  , "SBC A,0%02Xh"      , NULL },
    { RST_18H             , OP_NONE  , "RST 18H"           , NULL },
    { RET_PO              , OP_NONE  , "RET PO"            , NULL },
    { POP_HL              , OP_NONE  , "POP HL"            , NULL },
    { JP_PO_off_nn        , OP_WORD  , "JP PO,(0%04Xh)"    , NULL },
    { EX_off_SP_HL        , OP_NONE  , "EX (SP),HL"        , NULL },
    { CALL_PO_off_nn      , OP_WORD  , "CALL PO,(0%04Xh)"  , NULL },
    { PUSH_HL             , OP_NONE  , "PUSH HL"           , NULL },
    { AND_n               , OP_BYTE  , "AND 0%02Xh"        , NULL },
    { RST_20H             , OP_NONE  , "RST 20H"           , NULL },
    { RET_PE              , OP_NONE  , "RET PE"            , NULL },
    { JP_off_HL           , OP_NONE  , "JP (HL)"           , NULL },
    { JP_PE_off_nn        , OP_WORD  , "JP PE,(0%04Xh)"    , NULL },
    { EX_DE_HL            , OP_NONE  , "EX DE,HL"          , NULL },
    { CALL_PE_off_nn      , OP_WORD  , "CALL PE,(0%04Xh)"  , NULL },
    { NULL                , OP_NONE  , NULL                , &opcodes_ED },
    { XOR_n               , OP_BYTE  , "XOR 0%02Xh"        , NULL },
    { RST_28H             , OP_NONE  , "RST 28H"           , NULL },
    { RET_P               , OP_NONE  , "RET P"             , NULL },
    { POP_AF              , OP_NONE  , "POP AF"            , NULL },
    { JP_P_off_nn         , OP_WORD  , "JP P,(0%04Xh)"     , NULL },
    { DI                  , OP_NONE  , "DI"                , NULL },
    { CALL_P_off_nn       , OP_WORD  , "CALL P,(0%04Xh)"   , NULL },
    { PUSH_AF             , OP_NONE  , "PUSH AF"           , NULL },
    { OR_n                , OP_BYTE  , "OR 0%02Xh"         , NULL },
    { RST_30H             , OP_NONE  , "RST 30H"           , NULL },
    { RET_M               , OP_NONE  , "RET M"             , NULL },
    { LD_SP_HL            , OP_NONE  , "LD SP,HL"          , NULL },
    { JP_M_off_nn         , OP_WORD  , "JP M,(0%04Xh)"     , NULL },
    { EI                  , OP_NONE  , "EI"                , NULL },
    { CALL_M_off_nn       , OP_WORD  , "CALL M,(0%04Xh)"   , NULL },
    { NULL                , OP_NONE  , NULL                , &opcodes_FD },
    { CP_n                , OP_BYTE  , "CP 0%02Xh"         , NULL },
    { RST_38H             , OP_NONE  , "RST 38H"           , NULL }
} };

