/* MCP23S17 - Microchip MCP23S17 16-bit Port Extender using SPI
* Copyright (c) 2010 Gert van der Knokke
*/
#include "mbed.h"

#define IODIRA      0x00
#define IODIRB      0x01
#define IPOLA       0x02
#define IPOLB       0x03
#define GPINTENA    0x04
#define GPINTENB    0x05
#define DEFVALA     0x06
#define DEFVALB     0x07
#define INTCONA     0x08
#define INTCONB     0x09
#define IOCONA      0x0A
#define IOCONB      0x0B
#define GPPUA       0x0C
#define GPPUB       0x0D
#define INTFA       0x0E
#define INTFB       0x0F
#define INTCAPA     0x10
#define INTCAPB     0x11
#define GPIOA       0x12
#define GPIOB       0x13
#define OLATA       0x14
#define OLATB       0x15

// LCD pin connections/bit numbers
#define LCD_HALT    0x80
#define LCD_FS      0x20
#define LCD_RST     0x10
#define LCD_CD      0x08
#define LCD_CE      0x04
#define LCD_RD      0x02
#define LCD_WR      0x01

//      T6963C OPCODES
#define TXHOME      0x40    // SET TXT HOME ADDRESS
#define TXAREA      0x41    // SET TXT AREA
#define GRHOME      0x42    // SET GRAPHIC HOME ADDRESS
#define GRAREA      0x43    // SET GRAPHIC AREA
#define OFFSET      0x22    // SET OFFSET ADDRESS
#define ADPSET      0x24    // SET ADDRESS POINTER
#define AWRON       0xB0    // SET AUTO WRITE MODE
#define AWROFF      0xB2    // RESET AUTO WRITE MODE


/* This file contains definitions for all of the commands in a t6963. */
/********************************************************************/
/*  Register set */
#define CPS 0x21 //Cursor pointer set
#define ORS 0x22 //Offset register set
#define APS 0x24 //Address pointer set
#define THAS 0x40 //Text home address set
#define TAS 0x41 //Text area set
#define GHAS 0x42 //Graphic home address set
#define GAS 0x43 //Graphic area set
#define OM 0x80 //OR mode
#define EM 0x81 //EXOR mode
#define AM 0x83 //AND mode
#define TAM 0x84 //TEXT ATTRIBUTE mode
#define DOF 0x90 //Display OFF
#define CONBOF 0x92 //Cursor ON, Blink OFF
#define CONBON 0x93 //Cursor ON, Blink ON
#define TONGOF 0x94 //Text ON, Graphic OFF
#define TOFGON 0x98 //Text OFF, Graphic ON
#define TONGON 0x9C //Text ON, Graphic ON
#define LC1 0xA0 //1 Line cursor
#define LC2 0xA1 //2 Line cursor
#define LC3 0xA2 //3 Line cursor
#define LC4 0xA3 //4 Line cursor
#define LC5 0xA4 //5 Line cursor
#define LC6 0xA5 //6 Line cursor
#define LC7 0xA6 //7 Line cursor
#define LC8 0xA7 //8 Line cursor
#define DAWS 0xB0 //Data auto write set
#define DARS 0xB1 //Data auto read set
#define AR 0xB2 //Auto reset
#define DWAAI 0xC0 //Data write and ADP increment
#define DRAAI 0xC1 //Data read and ADP increment
#define DWAAD 0xC2 //Data write and ADP decrement
#define DRAAD 0xC3 //Data read and ADP decrement
#define DWAAN 0xC4 //Data write and ADP nonvariable
#define DRAAN 0xC5 //Data read and ADP nonvariable
#define SP 0xE0 //Screen PEEK
#define SC 0xE8 //Screen COPY
#define BR 0xF0 //Bit RESET
#define BS 0xF8 //Bit SET
//add 3 bit data to these
//commands to select bit