#ifndef _MAIN_H_INCLUDED
#define _MAIN_H_INCLUDED

/*constants*/
#define        MAX_NUMBER_OF_DOS_BUFFERS    5        /*the maximum numbers of available buffers within this device*/

/*structures*/
struct    DOS_buffer_struct
{
    unsigned char    buffer_in_use;                /*this flag indicates wether the buffer is allready in use*/            
    unsigned char    buffer[256];                /*the buffer capable of holding a complete block*/
};

struct    DOS_channel_struct
{
    unsigned char    channel_in_use;                /*this flag indicates wether this channel is allready in use*/
    unsigned char    next_action;                /*this holds the next action (if nothing interupts it) for this channel*/
    unsigned char    filename[17];                /*the actual filename, as it is stored on the disk*/
    unsigned char    filetype;                    /*filetype can be sequential, program, user, etc.*/
    unsigned char    RW;                            /*file read or write*/
    unsigned char    track;                        /*the current track position on the disk regarding this file*/
    unsigned char    sector;                        /*the current sector position on the disk regarding this file*/
    unsigned char    buffer_pointer;                /*the current byte position within the block specified by track and sector on the disk regarding this file*/
    unsigned char    used_buffer;                /*this register holds the value of the connected buffer (if required)*/
    unsigned char    status;                        /*the current status of this file entry in the sa_DOS_buffer*/
};

/*variables*/
extern unsigned char    RAM_buffer[256];        /*this is the buffer capable of holding one 256 byte block, a memory area to which the user or the 1541-III can write/read data to/from*/
//extern unsigned char    BAM_buffer[162];        /*this buffer holds the Block Allocation Map, required for when we want to write to the D64 (max 40 tracks)*/
extern unsigned char     block_buffer[512];        /*this buffers the data 'as read from' or 'to be written to' the card*/
extern struct            DOS_buffer_struct    DOS_buffer[MAX_NUMBER_OF_DOS_BUFFERS];    /*this array of structs holds the information about the currently used buffers*/
extern struct            DOS_channel_struct    DOS_channel[16];    /*this array of structs holds this information about the currently used channels*/

extern unsigned char Card_CID(void);
extern unsigned char Card_CSD(void);

/*routines*/
/*--------*/
// void delay_10uS(unsigned long delay);

//void CLRWDT();

#endif
