/*For Microchip 18Fxxx or 18Cxxx and Hi-Tech C

Designed by Shane Tolmie of www.microchipC.com corporation.  Freely distributable.
Questions and comments to webmaster@microchipC.com.
Lots of Hi-Tech C FAQ and sample source code at http://www.microchipC.com/.

Example C:

#define PIC_CLK 4000000

unsigned int timeout_int, timeout_char;

DelayUs(40);  //do NOT do DelayUs(N) of N<5 @ 4Mhz or else it executes DelayUs(255) !!!!
DelayUs(255); //max

dly250n;      //delay 250ns
dly1u;        //delay 1us

timeout_char=timeout_char_us(1147);
while(timeout_char-- && (RA1==0));  //wait up to 1147us for port RA1 to go high
                    //  - this is the max timeout

timeout_int=timeout_int_us(491512);
while(timeout_int-- && (RA1==0));   //wait up to 491512us for port RA1 to go high
                    //  - this is the max timeout

*/

#ifndef __DELAY_H
#define __DELAY_H


extern unsigned char delayus_variable;

#define DelayUs wait_us

/*

timeouts:

C code for testing with ints:

            unsigned int timeout;
            timeout=4000;
            PORT_DIRECTION=OUTPUT;
            while(1)
            {
                PORT=1;
                timeout=8000;
                while(timeout-- >= 1);    //60ms @ 8Mhz, opt on, 72ms @ 8Mhz, opt off
                PORT=0;
            }

Time taken:    optimisations on:        16cyc/number loop, 8us @ 8Mhz
            optimisations off:        18cyc/number loop, 9us @ 8Mhz
            with extra check ie:    && (RB7==1), +3cyc/number loop, +1.5us @ 8Mhz

C code for testing with chars:

            similar to above

Time taken:    optimisations on:        9cyc/number loop, 4.5us @ 8Mhz
            with extra check ie:    && (RB7==1), +3cyc/number loop, +1.5us @ 8Mhz

Formula:    rough timeout value = (<us desired>/<cycles per loop>) * (PIC_CLK/4.0)

To use:        //for max  timeout of 1147us @ 8Mhz
            #define LOOP_CYCLES_CHAR    9                    //how many cycles per loop, optimizations on
            #define timeout_char_us(x)    (unsigned char)((x/LOOP_CYCLES_CHAR)*(PIC_CLK/4.0))
            unsigned char timeout;
            timeout=timeout_char_us(1147);                        //max timeout allowed @ 8Mhz, 573us @ 16Mhz
            while((timeout-- >= 1) && (<extra condition>));    //wait

To use:        //for max 491512us, half sec timeout @ 8Mhz
            #define LOOP_CYCLES_INT        16                    //how many cycles per loop, optimizations on
            #define timeout_int_us(x)    (unsigned int)((x+/LOOP_CYCLES_INT)*(PIC_CLK/4.0))
            unsigned int timeout;
            timeout=timeout_int_us(491512);                        //max timeout allowed @ 8Mhz
            while((timeout-- >= 1) && (<extra condition>));    //wait
*/


//function prototypes
void DelayBigUs(unsigned int cnt);
void DelayMs(unsigned char cnt);
void DelayMs_interrupt(unsigned char cnt);
void DelayBigMs(unsigned int cnt);
void DelayS(unsigned char cnt);

#endif


