#ifndef IEC_BUS_INCLUDED
#define IEC_BUS_INCLUDED      


/*defines*/
/*-------*/
/*IEC commandset: the talker requests the addresses device to become a ...-er*/
#define        LISTEN            0x20    /*base address, device 0-30*/
#define        UNLISTEN        0x3F    /*base address, n/a*/                
#define        TALK            0x40    /*base address, device 0-30*/        
#define        UNTALK            0x5F    /*base address, n/a*/        
#define        DATA            0x60    /*base address, secondary address 0-15 (this is in some documentation also refered to as OPEN_CHANNEL)*/
#define        CLOSE            0xE0    /*base address, secondary address 0-15*/        
#define        OPEN            0xF0    /*base address, secondary address 0-15*/        

#define        TIMINGS_DEFAULT    10
#define        TIMINGS_DTV        11
#define        TIMINGS_VIC20    12
extern int IEC_CLOCK();
extern int IEC_DATA();
extern int IEC_ATN();
extern int IEC_RESET();
extern int IEC_SRQ();

extern void IEC_ATN_REL();
extern void IEC_ATN_PULL();
extern void IEC_DATA_REL();
extern void IEC_CLOCK_REL();
extern void IEC_DATA_PULL();
extern void IEC_CLOCK_PULL();
extern void IEC_SRQ_REL();
extern void IEC_SRQ_PULL();


/*routines*/
/*--------*/
void InitIEC(void);
void SetIEC_timings(unsigned char settings);
void FreeIEC(void);

unsigned char IEC_receive(unsigned char frame_handshake);
unsigned char IEC_send(unsigned char data);
unsigned char IEC_monitor(void);
void IEC_send_string(const unsigned char *inputstring);
void IEC_send_number_as_ASCII(unsigned char number);
void IEC_turnaround(void);
void IEC_undoturnaround(void);
void IEC_letgo(void);
unsigned char CheckForCommand(unsigned char *outputcommand, unsigned char frame_handshake);

#endif






