#ifndef _FAT_H_INCLUDED
#define _FAT_H_INCLUDED

struct file2TYPE
{
    unsigned char    name[12];           /*name of file*/
    unsigned char    name_lfn[27];         /*name of file according the long-file-name information*/
    unsigned short    entry;                /*file-entry index in directory table*/
    unsigned short    sec;                  /*sector index in file*/
    unsigned short    len;                /*total number of sectors in file, 0 if not a file*/
    unsigned long    size;                /*filesize in bytes*/
    unsigned short    cluster;            /*current cluster*/    
};

/*functions*/
unsigned char FindDrive(void);
unsigned char FileSearch(struct file2TYPE *file, unsigned char mode);    /*attention: screws up secbuf!!*/
unsigned char OpenSubDirectory(struct file2TYPE *file);
unsigned char FileSectorScan(struct file2TYPE *file);
unsigned char FileNextSector(struct file2TYPE *file);                    /*attention: screws up databuffer!!*/
unsigned char FileReadSector(struct file2TYPE *file);                    /*attention: secbuf is valid after this command*/
unsigned char FileReadSector_X(struct file2TYPE *file, unsigned long block);
unsigned char FileRead_X_Bytes(struct file2TYPE *file, unsigned long startaddress, unsigned int NmbrOfBytes);
unsigned char FileWriteSector_X(struct file2TYPE *file, unsigned long block);

#define        ERROR_FAT_READBOOTSECTOR        30
#define        ERROR_FAT_JUMPOPCODE            31
#define        ERROR_FAT_BLOCKSIZE                32
#define        ERROR_FAT_MEDIUM                33

#endif
