/*----------------------------------------------------------------------------------*/
/*    These routines are designed to decode a file according the D64 format           */
/*----------------------------------------------------------------------------------*/
/*                                                                                  */

/*  History:                                                                        
    -------- 
    2008-02-17    started with T64 coding
*/

/*  TO DO:                                                                          
    ------
*/

/*----------------------------------------------------------------------------------*/


/*--------------------------------------------------------*/
/*                        includes                        */
/*--------------------------------------------------------*/
#include <mbed.h>
#include <stdio.h>
#include <main.h>
#include <hardware.h>
#include <fat.h>
#include <delay.h>
#include <T64_decoder.h>

/*--------------------------------------------------------*/
/*                   (tunable) constants                  */ 
/*--------------------------------------------------------*/


/*--------------------------------------------------------*/
/*                        constants                       */   
/*--------------------------------------------------------*/
#define            FALSE            0                /*FALSE*/
#define            TRUE            1                /*TRUE*/

/*--------------------------------------------------------*/
/*                         table                          */
/*--------------------------------------------------------*/

/*variables*/
extern struct            file2TYPE             file;            /*file handle*/

extern unsigned char    error_code;                /*this holds the error-message generated by one of the disk routines*/

/*--------------------------------------------------------*/
/*                     local functions                    */
/*--------------------------------------------------------*/

/*************************************************************************************/
/*External functions*/
/*************************************************************************************/
/*This routine will search for the first dir entry within track 18, it returns the track and sector of the corresponding file*/
/*mode: 0=first,1=next*/
unsigned char T64SeekDirEntry(unsigned char mode, unsigned char *track, unsigned char *sector, unsigned char *entry_cnt)
{
    static unsigned char     entry_counter, CurrentDirTrack, CurrentDirSector, NextDirTrack, NextDirSector;

    switch(mode)
    {
        case 0:    /*read from first directory block (Track 18, Sector 1)*/
        {
            entry_counter = 0;
            break;
        }

        case 1:    /*read from next directory block (Track , Sector )*/
        {
            entry_counter++;
            break;
        }
    }

    *entry_cnt = entry_counter;

    
    return(TRUE);        /*there is more info stored on other track(s)*/
}



/*----------------------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------------------*/

