#ifndef D64_DECODER_INCLUDED
#define D64_DECODER_INCLUDED      

/* Description of the error-bytes at the end of some .D64 files:

    Code  Error  Type   1541 error description
    ----  -----  ----   ------------------------------
     01    00    N/A    No error, sector ok.
     02    20    Read   Header block not found
     03    21    Seek   No sync character
     04    22    Read   Data block not present
     05    23    Read   Checksum error in data block
     06    24    Write  Write verify (on format)
     07    25    Write  Write verify error
     08    26    Write  Write protect on
     09    27    Seek   Checksum error in header block
     0A    28    Write  Write error
     0B    29    Seek   Disk ID mismatch
     0F    74    Read   Disk Not Ready (no device 1)
*/

struct    directory_entry
{
    unsigned char    filetype;
    unsigned char    track_first_block;
    unsigned char    sector_first_block;
    unsigned char    filename[16];
    unsigned char    track_first_block_relfile;
    unsigned char    sector_first_block_relfile;
    unsigned char    record_size_relfile;
    unsigned char    unused_1[4];
    unsigned char    track_first_block_replacementfile;
    unsigned char    sector_first_block_replacementfile;
    unsigned char    blocksize_low_byte;
    unsigned char    blocksize_high_byte;    
    unsigned char    unused_2[2];
};


/*routines*/
/*--------*/
void Clear_RAM_buffer(void);
void D64ConvertBlockToTrackSector(unsigned int block, unsigned char *track, unsigned char *sector);
unsigned int D64ConvertTrackSectorToBlock(unsigned char track, unsigned char sector);
void D64ReadBAM(void);                                                                    /*this routine only supports 35 track disks, since I lack the knowledge of 40 track size disks*/
void D64WriteBAM(void);                                                                    /*this routine only supports 35 track disks, since I lack the knowledge of 40 track size disks*/
unsigned char D64ReadFreeBlocksPerTrack(unsigned char track);                            /*this routine only supports 35 track disks, since I lack the knowledge of 40 track size disks*/
unsigned char D64WriteFreeBlocksPerTrack(unsigned char track, unsigned char value);        /*this routine only supports 35 track disks, since I lack the knowledge of 40 track size disks*/
unsigned char D64BAMFlagTest(unsigned char track, unsigned char sector);                /*this routine only supports 35 track disks, since I lack the knowledge of 40 track size disks*/
void D64BAMFlagModify(unsigned char track, unsigned char sector, unsigned status);
unsigned char D64SeekFreeBlock(unsigned char *track, unsigned char *sector);            /*this routine only supports 35 track disks, since I lack the knowledge of 40 track size disks*/
unsigned char D64BlockAllocate(unsigned char track, unsigned char sector);
unsigned char D64BlockFree(unsigned char track, unsigned char sector);
void D64BlockWrite(unsigned char track, unsigned char sector);
void D64BlockWrite_new(unsigned char buffer, unsigned char track, unsigned char sector);
void D64BlockRead(unsigned char track, unsigned char sector);
void D64BlockRead_new(unsigned char buffer, unsigned char track, unsigned char sector);
unsigned char D64SeekDirEntry(unsigned char mode, unsigned char *track, unsigned char *sector, unsigned char *entry_cnt);
unsigned char D64SeekNextBlock(unsigned char *track, unsigned char *sector);
unsigned char D64AddDirEntry(unsigned char ftype, unsigned char tfblock, unsigned char sfblock, unsigned char *fname, unsigned int blocksize, unsigned char tfblock_rel, unsigned char sfblock_rel, unsigned char size_rel, unsigned char tfblock_replace, unsigned char sfblock_replace);
unsigned char D64ScratchDirEntry(unsigned char dirtrack, unsigned char dirsector, unsigned char direntry);
unsigned char D64RenameDirEntry(unsigned char *fname, unsigned char dirtrack, unsigned char dirsector, unsigned char direntry);

unsigned char D64LoadFileNameSector(unsigned char mode, unsigned char *dirtrack, unsigned char *dirsector);
unsigned int D64LoadFreeBlocks(void);
unsigned char D64LoadFile_X_Bytes(struct file2TYPE *file, unsigned char track, unsigned char sector, unsigned char byte, unsigned int NmbrOfBytes);
unsigned char D64SeekFile(unsigned char *filename, unsigned char *track, unsigned char *sector, unsigned int *blocksize, unsigned char *dirtrack, unsigned char *dirsector, unsigned char *direntry);

#endif
