// -------------------------------------------------------------
// BBC Basic hardware emulation part
// -------------------------------------------------------------

#include "bbc_0100.h"

#include "mbed.h"
#define byte unsigned char
#define word unsigned short

// some defaults
#define ESCFLG  0xff80          // escape flag
#define FAULT   0xff82          // fault address
#define DEFERR  0xff84          // default error handler
#define CMDPTR  0xff86          // command line tail
#define SCRATCHPAD  0xff88      // Basic scratchpad area
#define RESERVED    0xff9a      
#define OSRDRM  0xffb9          // read byte in paged ROM
#define MAINVDU 0xffbc          // main VDU character output entry point
#define OSEVEN  0xffbf          // generate an event
#define GSINIT  0xffc2          // general string input initialise routine
#define GSREAD  0xffc5          // read character from string input
#define UKCMD   0xffc9          // unknown command
#define OSFSC   0xffcb          // filing system control
#define OSFIND  0xffce          // open or close a file
#define OSGBPB  0xffd1          // multiple byte access
#define OSBPUT  0xffd4          // put a byte to a file
#define OSBGET  0xffd7          // get a byte from a file
#define OSARGS  0xffda          // read or set file arguments
#define OSFILE  0xffdd          // load or save a file
#define OSRDCH  0xffe0          // input a character
#define OSASCI  0xffe3          // print a character with CR converted to LF, CR
#define OSNEWL  0xffe7          // print a LF, CR sequence
#define OSWRCH  0xffee          // print a character
#define OSWORD  0xfff1          // do an OSWORD call
#define OSBYTE  0xfff4          // do an OSBYTE call
#define OSCLI   0xfff7          // interpret a command
#define BRKV    0xfffa          // FAULT vector

// default CP/M ram pages
#define RAMSIZE (word)0x4000    // 16K ram
#define RAMSTART 0x34ee
#define RAMEND   RAMSTART+RAMSIZE
#define PAGE     0x3800

// the emulated ram space
volatile unsigned char ram[RAMSIZE];

// ramtop space with vectors
volatile unsigned char ramtop[0x80];


// read from memory space
unsigned char rdmem(word addr) {
    extern volatile unsigned short pc;
 
     // all rom space
    if (addr<RAMSTART) {
        return rom[addr];
    }

    // ramtop with vectors
    if ((addr >=0xff80) && (addr <=0xffff)) {
        return ramtop[addr-0xff80];
    }

    // relocate $3400
    if ((addr >= RAMSTART) && (addr < RAMEND)) {
        return ram[addr-0x34ee];
    }
    return 0xff;   // non existant memory reads as 0xff
}

// write to memory space
void wrmem (word addr, byte val) {
    extern volatile unsigned short pc;

    // memtop vector space
    if ((addr >=0xff80) && (addr <=0xffff)) {
        ramtop[addr-0xff80]=val;
        return;
    }
    // printf("MEMW %04x %02x\n\r",addr,val);
    if ((addr >= RAMSTART) && (addr < RAMEND)) {
        ram[addr-RAMSTART] = val;
    } 
}

// write a byte to IO space
void out(unsigned char addr, unsigned char val) {
    printf("IO out called %02d, %02d\n\r",addr,val);
}

// read a byte from IO space
unsigned char in(unsigned char addr) {
    printf("IO in called %02d\n\r",addr);
    return 0xff;
}

