/*
 * XbeeConfig.cpp
 *
 *  Created on: 29/01/2017
 *      Author: gert
 */

#include <XbeeConfig/XbeeConfig.h>

XbeeConfig::XbeeConfig(PinName tx, PinName rx, PinName Rst): _com(tx,rx), rst(Rst){
  _com.baud(9600);
  Reset();
}

XbeeConfig::~XbeeConfig() {

}

void XbeeConfig::Reset()
{
    rst = 0;
    wait_ms(10);
    rst = 1;
    wait_ms(1);
}

int XbeeConfig::SetZB()
{
    wait_ms(5);
    _com.printf("ATZS2\r");
    Wait4OK();
    return 1;
}

int XbeeConfig::ResetSetAPI()
{
    wait_ms(5);
    _com.printf("ATAP0\r");
    Wait4OK();
    return 1;
}


int XbeeConfig::SetAPI()
{
    wait_ms(5);
    _com.printf("ATAP1\r");
    Wait4OK();
    return 1;
}


int XbeeConfig::ExitConfigMode()
{
    wait_ms(5);
    _com.printf("ATWR \r");
    Wait4OK();

    _com.printf("ATCN \r");
    Wait4OK();
    return 1;
}

int XbeeConfig::Wait4OK(){
    int a=0;
    while (a != 75) { //Wait for OK
        if (_com.readable()) {
            a = _com.getc();
        }
    }
    return 1;
}

int XbeeConfig::ConfigMode()
{
    wait(2);
    _com.printf("+++");
    Wait4OK();
    wait(1);
    return 1;
}

int XbeeConfig::Switch2Transperantmode() {
 if (ConfigMode()) {
     ResetSetAPI();
     ExitConfigMode();
     return 1;
 }
 else return 0;
}


int XbeeConfig::Switch2APImode() {
 if (ConfigMode()) {
     SetAPI();
     SetZB();
     ExitConfigMode();
     return 1;
 }
 else return 0;
}
