#include "mbed.h"
#include "thingspeak.h" 
#include "TCPSocketConnection.h"

/****************************************************************************************
 *                              --- Global Parameters ---                               *
 ***************************************************************************************/   

int i;
bool flagTCP=0;
bool flagTCPisCON=0;
int z = 0;
int Error = 0;

THINGSPEAK::THINGSPEAK() {
  FieldNumber=1;
  p=&thingStr[0];  
}    

void THINGSPEAK::AddFloat(float Value) {
  if (FieldNumber>1)
   p+=sprintf(p,"&field%d=%f",FieldNumber,Value); 
  else  
   p+=sprintf(p,"field1=%f",Value); 
  FieldNumber++; 
}

void THINGSPEAK::AddInt(int Value) {
  if (FieldNumber>1)
   p+=sprintf(p,"&field%d=%f",FieldNumber,Value); 
  else  
   p+=sprintf(p,"field1=%f",Value); 
  FieldNumber++; 
}

int THINGSPEAK::SendData(char* apikey) {
 return ThingString(apikey,thingStr,strlen(thingStr));   
}    

int THINGSPEAK::ThingString(char* apikey, char* data, int MessSize)
{       
    Error = 0; z=0;
    TCPSocketConnection ThingSock;
    flagTCP=0;

    char strPOST[500];
    sprintf( strPOST, "POST /update HTTP/1.1\r\nHost: api.thingspeak.com\r\nConnection: close\r\nX-THINGSPEAKAPIKEY: %s\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: %d\r\n\r\n%s", apikey, MessSize, data);
    //printf("%s\r\n",strPOST);
    while(flagTCP==FALSE)
    {
        if(z==5)
        {   
            z=0;
            flagTCP=TRUE;
            Error=1;
        }
        else
        {   
            ThingSock.connect(IPThingSpeak, 80); 
            flagTCP=ThingSock.is_connected();
            flagTCPisCON=flagTCP;
            z++;
        }
    }
    
    if(flagTCPisCON==TRUE)
    {
        ThingSock.send_all(strPOST, (int)strlen(strPOST)); 
        // Receive message from server
        char buf[256];
        int n = ThingSock.receive(buf, 256);
        buf[n] = '\0';
       // printf("Received message from server: '%s'\n", buf);   
        ThingSock.close(); 
        flagTCPisCON=FALSE;
        if (strstr(buf,"HTTP/1.1 200 OK")) Error=0; else Error=1;
    }
    FieldNumber=1; //Ready for next time
    p=&thingStr[0];  
    
    return Error;
}
