#ifndef _Tarco_H
#define _Tarco_H

#include "mbed.h"
#define TarcoRunMean 50
#define PulsPrRotation 24
#define PulsTimeOut 200 //200ms
/************************************************************************************* 
*  Tarco sensor on the SwitchAuto
*  Have 2 mode to measure the rotation
*  @param mode
*  Mode 0 Prescale
*  Mode 1 Runing mean
*************************************************************************************/
class Tarco {
private:
    InterruptIn _tarcosensor;
     int AdvPeriode; //running mean for tarco
    Timer t; //time for one rotation
    Ticker TimeOut;
    bool GettingPuls;
    float lastfrekvens;
    void Rotationtimer();   //measure tarco by dividing input frekvens with 24
    void TarcoTimeout();
public:
    /********************************************************************************
    * Constructor
    * @param flowsignal   The pin which is connected to the flowsensor.
    *
    * change the mode of the tarco
    * 0: Standard Prescale to one measure pr rotation
    * 1: Running mean
     ********************************************************************************/
    Tarco(PinName tarcosignal);
    
    /********************************************************************************
    * gives the tarco value in rotation pr min
    ********************************************************************************/

    float RPM();
    
};

#endif