#include "Tarco.h"
#include "mbed.h"

Tarco::Tarco(PinName tarcosignal) :
    _tarcosensor(tarcosignal)
{
  lastfrekvens=0; AdvPeriode=0;
  _tarcosensor.fall(this, &Tarco::Rotationtimer);
  TimeOut.attach(this,&Tarco::TarcoTimeout, 0.5);
}


void Tarco::Rotationtimer()
{
//Da switchAuto motoren kommer ud med 24 pulser/rotation laver vi en prescale på 24
//
    static int pulscounter;
    GettingPuls=1;
    if (pulscounter++>=PulsPrRotation) { //Vi tæller til 24, således at det er tiden/omgang
        t.stop();
        AdvPeriode=t.read_us();
        if (AdvPeriode>0) lastfrekvens=(1e6/AdvPeriode); else lastfrekvens=0;
        t.reset();
        t.start();
        pulscounter=0;
    }
}

void Tarco::TarcoTimeout() {
//Timeout på tarco puls, så vi får resat tarcoen, når den staopper
  if (GettingPuls==0) { //Hvis vi ikke har haft en puld indenfor 0.5 sek, så er den stoppet
    t.stop(); t.reset(); 
    lastfrekvens=0;
  }
  GettingPuls=false;      
} 
   

float Tarco::RPM()
{
    float rpm=lastfrekvens*60;
    return (float) rpm;
}

