#include "mbed.h"
#include "EthernetInterface.h"
#include "thingspeak.h"

#define apikey1 "29KO1SSTACFU295A"
#define apikey2 "262BP2WZLBS2VHWV"

EthernetInterface eth;
char* thingSpeakKey1 = apikey1;
char* thingSpeakKey2 = apikey2;
Serial pc(USBTX, USBRX);     // serial comms over usb back to console
Serial extpc(p28,p27);
Serial Radio(p9,p10);
THINGSPEAK Channel;
DigitalOut led(LED1);
DigitalOut flowindi(LED2);

AnalogIn transmitter(p15);
AnalogIn amb(p16);
InterruptIn flow(p17);
AnalogIn vand(p18);
AnalogIn retur(p19);
AnalogIn oltemp(p20);

int flowCount;
char InBuff[100];
char *p;

float Tryk;
float Flow;
float AmbiantTemp,AmbiantTemp2;
float WaterTemp;
float MidtTemp; //2
float ReturTemp;
float BeerTemp,BeerTemp2;
float PumpeEnde; //2
float SlangeEnde;

size_t parse ( char *line, char *list[], size_t size )
{
    char   *p;
    size_t n;

    p = line;
    n = 0;
    for ( ; ; ) {
        /* Ditch leading commas */
        while ( *p == ' ' )
            p++;
        /* Nothing of use */
        if ( *p == '\0' )
            return n;
        /* Save the string */
        list[n++] = p;
        /* Find the next field */
        while ( *p != ' ' && *p != '\0' )
            p++;
        /* Nothing else of use or too many fields */
        if ( *p == '\0' || n >= size )
            return n;
        /* Split the field */
        *p++ = '\0';
    }
}


void GetData()
{
    Timer t;
    char *list[4];
    char a,ch;
    char waiting;
    p=&InBuff[0];
    Radio.printf("!");
    waiting=1;
    a=0;
    led=1;
    t.start();
    while (waiting) {
        if (t.read_ms()>1000) {
            Radio.printf("!");
            t.reset();
            t.start();
            a=0;
            pc.printf("Retry\r\n");
        }
        if (Radio.readable()) {
            ch=Radio.getc();
            if ((ch!=0x0A) && (ch!=0x0D)) InBuff[a++]=ch;
            if (ch==0x0D) {
                InBuff[a]=0;

                t.stop();
                led=0;
                //pc.printf("%s\r\n",InBuff);
                
                if (parse(p,list,100)==4) {
                    AmbiantTemp2=atof(list[0]);
                    MidtTemp=atof(list[1]);
                    BeerTemp2=atof(list[2]);
                    SlangeEnde=atof(list[3]);
                    waiting=0;
                }
                else {
                    pc.printf("decodeError\r\n");
                    waiting=0;
                 /*   Radio.printf("!");
                    t.reset();
                    t.start();
                    a=0;
                    p=&InBuff[0];*/
                }    

                // sscanf(InBuff,"%f %f %f %f",AmbiantTemp2,MidtTemp,BeerTemp2,SlangeEnde);
                //pc.printf("%f %f %f %f\r\n",AmbiantTemp2,MidtTemp,BeerTemp2,SlangeEnde);
            }
        }
    }
    led=0;
}

void readAnalog()
{
    Flow=(float)flowCount/(17*1200);
    Tryk=(transmitter.read()*3.3-0.597)*4,16;
    AmbiantTemp=(amb.read()*3.3-0.25)/0.028;
    WaterTemp=(vand.read()*3.3-0.25)/0.028;
    ReturTemp=(retur.read()*3.3-0.25)/0.028;
    BeerTemp=(oltemp.read()*3.3-0.25)/0.028;
    Channel.AddFloat(AmbiantTemp);
    Channel.AddFloat(AmbiantTemp2);
    Channel.AddFloat(WaterTemp);
    Channel.AddFloat(MidtTemp);
    Channel.AddFloat(ReturTemp);
    Channel.AddFloat(Flow);
    Channel.SendData(thingSpeakKey1);
    Channel.AddFloat(PumpeEnde);
    Channel.AddFloat(SlangeEnde);
    Channel.AddFloat(BeerTemp2);
    Channel.AddFloat(BeerTemp);
    Channel.SendData(thingSpeakKey2);
    flowCount=0;
    extpc.printf("T1 %.2f T2 %.2f Wt1 %.2f Wt2 %.2f Wt3 %.2f Flow %.2f Tr1 %.2f Tr2 %.2f B2 %.2f B1 %.2f \r\n",AmbiantTemp,AmbiantTemp2,WaterTemp,MidtTemp,ReturTemp,Flow,PumpeEnde,SlangeEnde,BeerTemp2,BeerTemp);
    pc.printf("T1 %.2f T2 %.2f Wt1 %.2f Wt2 %.2f Wt3 %.2f Flow %.2f Tr1 %.2f Tr2 %.2f B2 %.2f B1 %.2f \r\n",AmbiantTemp,AmbiantTemp2,WaterTemp,MidtTemp,ReturTemp,Flow,PumpeEnde,SlangeEnde,BeerTemp2,BeerTemp);
}

void flowcounter()
{
    flowCount++; //tæller
    flowindi=!flowindi;
}

int main()
{
    pc.printf("\n\r---------------------------------------------------------------\n\r");
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\n\r", eth.getIPAddress());
    flow.fall(&flowcounter);
    while(1) {
        GetData();
        readAnalog();
        wait(17);
    }
}
