//---------------------------------------------------------
//Class for measure distance with the HCSR04 sensor
/*
Eksemple
void distance(long Distance) {      
        printf("Distance: %d   \r",Distance);    
}

int main()
{
    sensor= new HCSR04(p5,p6,distance); 
    printf("Test af sensor\r\n");
    while(1) {
       sensor->Trigger();
       wait(0.1); 

    }
}
Datasheet: http://www.micropik.com/PDF/HCSR04.pdf
*/
#include "mbed.h"
typedef void (*callback_type)(long); 
 
class HCSR04 {
  public:
    HCSR04(PinName t, PinName e,callback_type _callback);
    void Trigger(); //starts the trigger
    
    private:
        DigitalOut trig;
        InterruptIn echo;
        Timer timer;
        Timeout *pulsWidth;
        callback_type callback;
        long dist_cm;
        
        void Trigoff(); //Turnoff the trigger
        void DistResult();
        void StartTimer(); 
};