#include "HCSR04.h"
#include "mbed.h"
#define DistanceOffset 0
HCSR04::HCSR04(PinName t, PinName e,callback_type _callback) : trig(t), echo(e) 
{
 echo.rise(this, &HCSR04::StartTimer); 
 echo.fall(this, &HCSR04::DistResult);
 pulsWidth=new Timeout; 
 callback = _callback;     
}

void HCSR04::StartTimer() {
   timer.reset();
   timer.start(); 
}

void HCSR04::DistResult() {
//Getting the distance
 dist_cm =((timer.read_us()-DistanceOffset)*0.034)/2;
 callback(dist_cm);   //time the speed of sound
}

void HCSR04::Trigoff() {
//setting the trigger low    
    trig = 0;
}

void HCSR04::Trigger() {
//Makes a trigger signal
    trig = 1;
    pulsWidth->attach_us(this,&HCSR04::Trigoff,10);
    //Give it 10 us puls
}

