//---------------------------------------------------------------------------------------------------------------------
//                       :   Headerfile
// Title                 :   Generator module
// Filename              :   Gen.cpp
// Author                :   Gert Lauritsen
// Origin Date           :   22/05/2015
// Version               :   1.000
// Compiler              :   Keil
// Target                :
// Notes                 :   None
//
//---------------------------------------------------------------------------------------------------------------------
//--------------------------------- MODULE REVISION LOG ---------------------------------------------------------------
//
//    Date     Software Version    Initials   Description
//  22/05/2015    1.0.0.0            GL      Module Created.
//
//---------------------------------------------------------------------------------------------------------------------
// @file Queue.h
//  @brief This module contains the
//  @Generator Control
//  @Styrer generator vha PWM af rotor strøm
//  @Måler Vout, Iout, Irotor,
//
//---------------------------------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------------------------------
//Includes
#include "GenCtrl.h"
//---------------------------------------------------------------------------------------------------------------------
#define defsoftstartTimeOut 50
#define MaxStartPWM         192 //(75%)
#define MinStartPWM         25  //Max 10%
#define LowCutPoint         470
#define IntoSoftStart       10  //[sek] Den tid det går fra den kommer ud af regmode til den går i startup


//1,0,4,2,6,7,5,3
#define AinVout         0
#define AinCurrmon      1
#define AinFieldmon     2

DigitalOut LED(p20);
//-------------------------------------------------------------------------------------------------------------------------------------
GenCtrl::GenCtrl(PinName PWMSignal,PinName VinSignal,PinName IInSignal,PinName IrotorSignal,GenCallback_type _callback)
{
    RotorPWM=new PwmOut(PWMSignal);
    RotorPWM->period_us(100); //Periodetide for PWM 10khz
    RotorPWM->pulsewidth(0.75); //Slukke for den i første omgang
    softstart=1;               //Starter i startupmode
    Vin    = new mbed::AnalogIn(VinSignal);
    Iin    = new mbed::AnalogIn(IInSignal);
    Irotor = new mbed::AnalogIn(IrotorSignal);
    Sampler.attach(this,&GenCtrl::AnalogIn,0.001); //1000hz samples
    GeneralTimer.attach(this,&GenCtrl::Timer,1);    //1 sek timeTick
    callback=_callback;
}

//-------------------------------------------------------------------------------------------------------------------------------------
//Omregnings functioner:
long PMax2Count(float P) {
   return P; 
} 

void GenCtrl::NewVout(float Vset) {
    //softstart=1;        //Starter i startupmode    
    CalRec.Vset         =(Vset*VinGain)/VoltPrCount;    
}    

void GenCtrl::SetVCal(float Vset,float Vmax,float StartPower,float RunPower,float RotorMaxCurrent){
    CalRec.Vset         =(Vset*VinGain)/VoltPrCount;
    CalRec.VMax         =(Vmax*VinGain)/VoltPrCount;
    CalRec.VmaxRep      =3; //3 sek før den går i overvoltage
    CalRec.StartPower   =StartPower/(VinFromCount*IoutCalFaktor);  
    CalRec.PWMRotaryBlok=MinStartPWM; //minimal PWM    
    CalRec.IRotorMax    =RotorMaxCurrent/IRotorCalFaktor;
    CalRec.Kp           =7;
    CalRec.RunPower     =RunPower/(VinFromCount*IoutCalFaktor);
}
   
//-------------------------------------------------------------------------------------------------------------------------------------
//
void GenCtrl::Blink()
{
    static char state;
    state=!state;
    LED=state;
}

void GenCtrl::Timer() {
//General timer 1gg/sec
     if ((LastRpm<1000) && (!NotInRegArea)) NotInRegArea=1; //Hvis motoren er stoppet
      
     if ((NotInRegArea) && (!softstart)) {  //Timeout på at holde reguleringen
       if (NotInRegArea<100) NotInRegArea++; 
     }
     if ((NotInRegArea>IntoSoftStart) && (!softstart))  { //Slår over i softstart efter timeout
      if ((LastRpm>1000) || (ADCValue[AinVout]<LowCutPoint)) softstart=1; else softstart=2;
      softstartTimeOut=defsoftstartTimeOut; //Softstart er for at få generator stille op.
     }
     Vout=MessData.Vmon/MessData.Nstak;
     if (Vout>CalRec.VMax) { //Vmax nedluk
          if (vmaxdone<CalRec.VmaxRep) vmaxdone++;   
         } //nedluk som følge af fejl
       else {
        vmaxdone=0;
     }
      
     callback();      
}

void GenCtrl::AnalogIn()
{
//Sample Vout, Iout og Irotor bliver kaldt med ca 1khz
static int PRotorCurrent;

    ADCValue[AinVout] = Vin   ->read_u16();
    ADCValue[AinCurrmon] = Iin   ->read_u16();
    ADCValue[AinFieldmon] = Irotor->read_u16();

    MessData.Vmon+=ADCValue[AinVout];
    MessData.Iin+=ADCValue[AinCurrmon];
    MessData.Irotor+=ADCValue[AinFieldmon];
    MessData.Nstak++;
    RotorCurrent[PRotorCurrent++]=ADCValue[AinFieldmon];
     if (PRotorCurrent>=RotorCurrentAdvLength) PRotorCurrent=0;

    SetNewPwM();
   // Blink();
}

void GenCtrl::ResetMessData(void)
{
    MessData.Nstak=0;
    MessData.Vmon=0;
    MessData.Iin=0;
    MessData.Irotor=0;
    MessData.loadadvcount=0;
    MessData.loadadv=0;
    MessData.regadvcount=0;
    MessData.regadv=0;
}

unsigned char GenCtrl::MaxValuePos(void)
{
//finder max i VinBuff (tager ca 10us)
    unsigned char BufPosition,i;
    unsigned int MaxValue;
    BufPosition=0;
    MaxValue=0;
    for (i=0; i<VinBuffLength; i++) {
        if (VinBuff[i]>MaxValue) {
            MaxValue=VinBuff[i];
            BufPosition=i;
        }
    }
    return BufPosition;
}


unsigned int GenCtrl::AdvRotorCurrent(void)
{
//Beregner middelstrømmen
//Denne funktion er den der tager det meste af tiden
//Når denne ændre fra Long til int falder tiden til 50us
//For at dette skal kunne lade sig gøre er længden sat ned til 12 i stedet for 50
    unsigned char Ptail;
    unsigned int adv,outvalue;
    adv=0;
    for (Ptail=0; Ptail<RotorCurrentAdvLength; Ptail++) {
        adv+=RotorCurrent[Ptail];
    }
    outvalue=adv/RotorCurrentAdvLength;
    return outvalue;
}

//-------------------------------------------------------------------------------------------------------------------------------------
//Regulerings function
//-------------------------------------------------------------------------------------------------------------------------------------


void GenCtrl::SetNewPwM (void)
{
    static unsigned int RegValue;
    static unsigned int RegError;
    static unsigned char PWMOut;
    static unsigned int pVinBuff,PRotorCurrent;

    bool NotInRegArea=0;


    VinBuff[pVinBuff++]=ADCValue[AinVout]; //Vin kægges over...
    if (pVinBuff>=VinBuffLength) pVinBuff=0;

    RotorCurrent[PRotorCurrent++]=ADCValue[AinFieldmon];
    if (PRotorCurrent>=RotorCurrentAdvLength-1) PRotorCurrent=0;

    Vmax=VinBuff[MaxValuePos()]; //Max findes


    if (CalRec.Vset>Vmax) {
        RegError=CalRec.Vset-Vmax;
        RegValue=RegError*CalRec.Kp;      //Det ændre ikke på det om vi bruger shift her
        if (RegValue>0xff) RegValue=0xff; //overflow af reguleringsloop
    } else RegValue=0;

    if (vmaxdone>=CalRec.VmaxRep) RegValue=0; //AFbryder overspænding vmaxdone inc 1 gang/sek

    if ((AdvRotorCurrent()>CalRec.IRotorMax) && (CalRec.IRotorMax>0)) {//begrænser Irotor
        PWMOut=0; //Sluk for strømmen
    }

    else {
        if (Rotionprotech) { //Sætter en max
            if (RegValue>CalRec.PWMRotaryBlok) PWMOut=CalRec.PWMRotaryBlok;
        }
        if (softstart) {
            long PError, Power, RegPower;
            Power=(long) Vmax*ADCValue[AinCurrmon];

            switch (softstart) {
                case 1:
                    RegPower=CalRec.StartPower; //Max effekt i opstart
                    break;
                case 2:
                    RegPower=CalRec.StartPower;
                    break;
                case 3:
                    RegPower=CalRec.RunPower; //MaxEffekt når vi kører
                    break;
            }
          
            if (Power<=RegPower) { //Denne del taget 14us
                PError=RegPower-Power;
                PError>>=10;          
                if (PError<255)
                    PWMOut=PError; //Gange med gain der er 1/128
                else
                    PWMOut=255;
            } else
                PWMOut=0;
          

            if (RegValue<PWMOut) {
                PWMOut=RegValue; //Vi går nu ud af softstart
                if (softstartTimeOut--==0) softstart=0;
            } else
                softstartTimeOut=defsoftstartTimeOut; //Softstart er for at få generator stille op.

            if (Rotionprotech) { //Sætter en max i startupmode
                if (PWMOut>CalRec.PWMRotaryBlok) PWMOut=CalRec.PWMRotaryBlok;
            }

            if (PWMOut>MaxStartPWM) {
                switch (softstart) {
                    case 1:
                        PWMOut=MaxStartPWM;
                        break;//Max 75%
                    case 2:
                        PWMOut=MinStartPWM;
                        break; //Max 10%
                    case 3:
                        PWMOut=MaxStartPWM;
                        break; //Max 75%
                }
            }
        } else //hvis ikke startup
            PWMOut=RegValue;

        if ((RegValue<0xff) & (ADCValue[AinVout]>LowCutPoint)) { //er indenfor reg slå softstart fra
            NotInRegArea=0;
        }
    }
    if ((NotInRegArea==0) && (RegValue>=0xff)) NotInRegArea=1; //Vi er udenfor regområde
    RotorPWM->write((float) PWMOut/255); //Sætter pwm på pin
    MessData.regadv+=RegValue;
    MessData.regadvcount++;

    MessData.loadadv=PWMOut;
    MessData.loadadvcount++;
}

//---------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------

