//                       :
// Title                 :   Generator controller
// Filename              :   GenCtrl.h
// Author                :   Gert Lauritsen
// Origin Date           :   26/01/2016
// Version               :   1.000
// Compiler              :   Keil
// Target                :
// Notes                 :   None
//
//------------------------------------------------------------------------------------

#ifndef GenCtrl_H
#define GenCtrl_H
#include "mbed.h"

typedef void (*GenCallback_type)();
#define RotorCurrentAdvLength  12
#define VinBuffLength 25

//Omregning
#define VoltPrCount         (3.3/65535)                 //vref/12bit 
#define VinGain             (4.7/(200+4.7))             //Spændingsdeler i input
#define VinFromCount        (VoltPrCount/VinGain)       //Omregning til Count->Volt 
#define IoutCalFaktor       (VoltPrCount*(1000/21.5))   //Strøm i Count til Amp
#define IRotorCalFaktor     (VoltPrCount*2.1315)        //Målt Count til strøm i rotor [A] 


typedef struct {
    unsigned int Vset;          //2 byte
    unsigned int VMax;          //2 byte I tilfælde af at spændingen kommer over dette slukkes for det hele
    unsigned char VmaxRep;      //1 byte
    long StartPower;            //4 byte
    unsigned int PWMRotaryBlok; //2 Den PWM, som vi kan gå ned til
    unsigned int IRotorMax;     //2 Begrænsning af rotor strøm
    unsigned int Kp;            //2 Gain i Voltage Reg
    long RunPower;              //4 byte
} CalRecType;                   //21 byte i alt

typedef struct {                //Her har vi alle måle data samlet
    unsigned int Nstak;         //Stak af ADC
    long Vmon, Iin ,Irotor;     //
    unsigned long regadv;       //middel af PWM
    unsigned int regadvcount;   //tæller til at regne middel ud med
    unsigned long loadadv;      //middel af PWM
    unsigned int loadadvcount;  //tæller til at regne middel ud med
} MessDataType;


class GenCtrl
{
private:
    GenCallback_type callback;
    PwmOut *RotorPWM;
    Ticker Sampler, GeneralTimer;
    AnalogIn  *Vin, *Iin,*Irotor;

    unsigned int ADCValue[3]; //Analog In Vout, Iout, Irotor
    unsigned int VinBuff[VinBuffLength]; //Buffer til at filtre input spænding (undgå Ron)
    unsigned int NotInRegArea;  //Disable function til generator
    unsigned int RotorCurrent[RotorCurrentAdvLength];
    unsigned int vmaxdone;      //Tæller for hvor mange gange der har været over Vmax
    int softstartTimeOut;       //en tid, hvor den efter at være kommet over i reg mode stadig har en Max Pout
    void AnalogIn(void);        //Sampler
    unsigned int AdvRotorCurrent(void); //Finder middelstrøm
    void SetNewPwM (void);      //ReCalc PWM
    void Blink();               //debug function
    void Timer();               //General timer 1gg/sec

    unsigned char MaxValuePos(void);

public:
    GenCtrl(PinName PWMSignal,PinName VinSignal,PinName IInSignal,PinName IrotorSignal,GenCallback_type _callback);
    bool Rotionprotech;    //Sættes hvis omdrejningerne kommer for lang ned
    int  softstart;        //Opstarts styring
    unsigned int Vmax;     //målt Vmax
    unsigned int LastRpm;
    unsigned int  Vout;    //stakket måling over 1 sek [count]

    MessDataType MessData; //Målte data (load m.m.)
    CalRecType CalRec;     //Record med opsætningsparameter

    void ResetMessData(void); //når man har aflæst sine værdier rester man dem.
    void SetVCal(float Vset,float Vmax,float StartPower,float RunPower,float RotorMaxCurrent);
    void NewVout(float Vset);
};

#endif
