//------------------------------------------------------------------------------------
// Title                 :   General Q
// Filename              :   Queue.c
// Author                :   Gert Lauritsen
// Origin Date           :   21/04/2015
// Version               :   1.000
// Compiler              :   Keil
// Target                :
// Notes                 :   None
//
//------------------------------------------------------------------------------------
//----------------------- MODULE REVISION LOG ----------------------------------------
//
//    Date     Software Version    Initials   Description
//  21/04/2015    1.0.0.0            GL      Module Created.
//  22/05/2015    1.0.0.1            GL      Translated to Mbed
//
//------------------------------------------------------------------------------------
// @file ComQueue.cpp
// @brief This module contains the
// @A que funtion for serial communiaction
//
//------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------
#include <ComQueue.h>

#define QSIZE 250
//-----------------------------------------------------------------------------
// Global VARIABLES
//-----------------------------------------------------------------------------
typedef struct{
    int cnt;
    int front;
    int rear;
    unsigned char que[QSIZE];
}QueueType;

QueueType Serial;
unsigned char Q_crc;
//-----------------------------------------------------------------------------
// Queue Functions
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Init_q
//-----------------------------------------------------------------------------
void init_q(void)
{
    Serial.cnt = 0; // set initial values
    Serial.front = 0;
    Serial.rear = 0;
}
//-----------------------------------------------------------------------------
// Put into Q
//-----------------------------------------------------------------------------
unsigned char Put(unsigned char ch)
{
    if(Serial.cnt >= QSIZE) return 0; 	// Put fails
    Serial.que[Serial.rear++] = ch; 			// copy character
    Q_crc ^=ch;                         // Runing calc of CRC
    if(Serial.rear >= QSIZE) Serial.rear = 0;
    Serial.cnt++;    					// increase count
    return 1; 							// report sucess
}

unsigned char Put16(unsigned int Wch)
{
    union {
        char bytes[2];
        unsigned int val;
    } Int2Byte;

    Int2Byte.val=Wch;
    Put(Int2Byte.bytes[0]);
    Put(Int2Byte.bytes[1]);

    return 1;
}
//-----------------------------------------------------------------------------
// Get From Q
//-----------------------------------------------------------------------------
unsigned char Get(unsigned char *ch)
{
    if(Serial.cnt <= 0) return 0; 		// Get fails
    *ch = Serial.que[Serial.front++]; 	// remove front item
    if(Serial.front >= QSIZE) Serial.front = 0;
    Serial.cnt--; 					    // reduce count
    return 1; 							// return sucess
}


