//------------------------------------------------------------------------------------
//                       :
// Title                 :   Comlink
// Filename              :   Queue.h
// Author                :   Gert Lauritsen
// Origin Date           :   26/05/2015
// Version               :   1.000
// Compiler              :   Keil
// Target                :
// Notes                 :   None
//
//------------------------------------------------------------------------------------

#include "ComLink.h"
#define Frameheader 3
//#define TxIrq

ComLink::ComLink(PinName tx, PinName rx) : _com(tx,rx)
{
    //_com=new Serial(tx,rx);
    init_q();
    _com.baud(115200);
    TxAktiv=0;               //Signal om at der ikke sendes data for øjeblikket
    _Dtype=0;
#ifndef TxIrq
    _com.attach(this,&ComLink::txCallback, Serial::TxIrq); //Interrupt rutiner
#endif
    _com.attach(this,&ComLink::rxCallback, Serial::RxIrq);
}

bool ComLink::CRC()
{
    unsigned char CRCin=0;
    int framesize=inbuff[1];
    for (int i=0; i<(framesize+Frameheader); i++) CRCin^=inbuff[i];
//return CRCin==inbuff[framesize+Frameheader];
    return 1;
}

//------------------------------------------------------------------------------------
// STX Size type Data       CRC
//  0   1    2   3..Dsize  Dsize+3
//------------------------------------------------------------------------------------

void ComLink::rxCallback()   //modtager data, når frame er modtaget sende besked
{
    static unsigned char InPointer;
    static bool Incoming;
    unsigned char framesize;


    inbuff[InPointer]=_com.getc();
    if ((!Incoming) && (inbuff[InPointer]==stx)) {
        Incoming=1;
    }
    if (Incoming) {
        if (InPointer>Frameheader) {
            framesize=inbuff[1]+Frameheader;
            if (framesize<=InPointer) { //Vi har modtaget det hele
                if (CRC()) {
                    strncpy(&Data[0],&inbuff[3],framesize-Frameheader);
                    InPointer=0;
                    Incoming=0;
                    _Dtype=inbuff[2];
                    DSize=framesize-Frameheader;
                } //if crc
                else {
                    InPointer=0;
                    Incoming=0;
                }

            } //if framesize..
        } //if (Inpo..
        if (Incoming) InPointer++; //
    } //if incoming
}

int ComLink::Work()
{
    int tmp;
    tmp=_Dtype;
    _Dtype=0;
    return tmp;
}

void ComLink::txCallback()   //Skal tage den næste byt i rækken og sende den
{
    unsigned char NextCh=0;
    if (Get(&NextCh)==0) TxAktiv=0;
    else
        _com.putc((int) NextCh); //sender næste char fra q
}
#ifndef TxIrq
void ComLink::Senddata(unsigned char Dtype,unsigned char  Dsize, char *str)
{
    unsigned char outbuf[50];
    int i;
    if (Dsize<(50-4)) {
        outbuf[0]=stx;
        outbuf[1]=Dsize;
        outbuf[2]=Dtype;
        for (i=0; i<Dsize; i++) {  //Datasektion
            outbuf[3+i]=*str;
            str++;
        }
        Q_crc=0;
        for (i=0; i<Dsize+3; i++) Q_crc^=outbuf[i];  //CRC
        outbuf[Dsize+3]=Q_crc;
        for (i=0; i<Dsize+4; i++) {
            _com.putc((int) outbuf[i]);
            while (!_com.writeable()) {} //wait
        }
    }
}
#endif
#ifdef TxIrq

void ComLink::Senddata(unsigned char Dtype,unsigned char  Dsize, char *str)
{
    unsigned char NextCh=0;
    Q_crc=0;
    //printf("N=%d %s\r\n",Dsize, &str[2]);
    Put(stx);   //Start Frame
    Put(Dsize); //FrameSize
    Put(Dtype);  //Frame type
    for (int i=0; i<Dsize; i++) {  //Datasektion
        Put(*str);
        str++;
    }
    Put(Q_crc);  //CRC
    if (!TxAktiv) {      //Hvis vi ikke sender noget for tiden startes tømningen fra Q
        Get(&NextCh);
        _com.putc((int) NextCh); //sender næste char fra q
        TxAktiv=1;
    }
}
#endif
//---------------------------------------------------------------------------------------------------
//Tx Frames
//Public functions:
void ComLink::TxFloats(unsigned char Ftype, float *Fvalue, int Size)
{
    char OutStr[40];
    union {
        char bytes[4];
        float val;
    } Float2Byte;
    for (int i=0; i<Size; i++) {
        Float2Byte.val=*Fvalue;
        memcpy(&OutStr[i*4],&Float2Byte.bytes[0],4);
    }
    Senddata(Ftype,Size*4,OutStr);
}

void ComLink::TxCalRecord(float *value, int Size)
{
    TxFloats(2,value,Size);
}


void ComLink::TxStatus(float *value, int Size)
{
    TxFloats(3,value,Size);
}

void ComLink::TxErrStateArr(float *value, int Size)
{
    TxFloats(4,value,Size);
}

void ComLink::TxSetStateArr(float *value, int Size)
{
    TxFloats(5,value,Size);
}

void ComLink::TxMessData(unsigned char Ftype, void *SValue, int Size)
{
    char OutStr[40];
    memcpy(&OutStr[0],SValue,Size);
    Senddata(Ftype,Size,OutStr);
}

void ComLink::WriteConsol(char *str)
{
    //Bare til at blive skrevet på consol
    char outstr[50];
    if (strlen(str)<48) {
    strcpy(&outstr[0],str);
    Senddata(8,strlen(str),outstr);
    }
}

void ComLink::WriteLCD(unsigned char x,unsigned char y, char *str)
{
    char outstr[50];
    if (strlen(str)<48) {
      outstr[0]=x;
      outstr[1]=y;
      memcpy(&outstr[2],str,strlen(str));
      Senddata(6,2+strlen(str),outstr);
    }
}

void ComLink::cls()
{
    Senddata(7,0,"");
}

void ComLink::StatusUpdate(float Vout,float Iout,float Irotor) {
    char OutStr[40];
    union {
        char bytes[4];
        float val;
    } Float2Byte;
    Float2Byte.val=Vout;
    memcpy(&OutStr[0],&Float2Byte.bytes[0],4);
    Float2Byte.val=Iout;
    memcpy(&OutStr[4],&Float2Byte.bytes[0],4);
    Float2Byte.val=Irotor;
    memcpy(&OutStr[8],&Float2Byte.bytes[0],4);
    Senddata(9,12,OutStr);    
}    