//------------------------------------------------------------------------------------
//                       :     
// Title                 :   Comlink 
// Filename              :   Queue.h
// Author                :   Gert Lauritsen
// Origin Date           :   26/05/2015
// Version               :   1.000
// Compiler              :   Keil
// Target                :   
// Notes                 :   None
//
//------------------------------------------------------------------------------------

#ifndef ComLink_H
#define ComLink_H

#include "ComQueue.h"
#include "mbed.h"

#define RxSize 200
#define stx 2
//------------------------------------------------------------------------------------


/*
Modtagne data:
1: Kp, Ki,Kd
2: Vset            float 
3: SetSpeed Manual byte 0..100
4: ReadTempetur
//Når vi modtager data vil type blive send i callback

Sender:
1: ID, Firmware,
2: CalRecord, Vmax, PowerOn, PowerStart,  
3: Gui, Vout, Iout, Irotor, Temp, Vbat, 
4: Send ErrStateArr
5: Send SetStateArr
6: Write LCD
7: Clear LCD

*/
//------------------------------------------------------------------------------------

class ComLink {
private:
 RawSerial _com;
 int _Dtype;
 char inbuff[RxSize];
 void rxCallback();
 void txCallback();
 bool CRC(); //check af inkommende frames
 bool TxAktiv;
 void Senddata(unsigned char Dtype, unsigned char Dsize, char *str); 
 void TxFloats(unsigned char Ftype, float *Fvalue, int Size);
 
public:
 char Data[RxSize];
 unsigned char DSize;
 ComLink(PinName tx, PinName rx);
 //void Updategui();
 int Work();
 
 //Sender
 void StatusUpdate(float Vout,float Iout,float Irotor); //Generator data
 void TxErrStateArr(float *value, int Size);
 void TxSetStateArr(float *value, int Size);
 
 void TxCalRecord(float *value, int Size);
 void TxStatus(float *value, int Size);
 
 void TxMessData(unsigned char Ftype, void *SValue, int Size); //Måledata sendes til PC
 void WriteConsol(char *str);               //Skriver data til linux consol (debug/indstilling)     

 void WriteLCD(unsigned char x,unsigned char y, char *str);
 void cls(); 
};

#endif