#include "mbed.h"
#include <stdint.h>
#include "DS18B20.h"
#include "DHT.h"
#include "EthernetInterface.h"
#include "Hx711.h"

#define RATE 1
#define SensorOffset 0

char* SERVER_ADDRESS = "172.31.2.3";
const int SERVER_PORT = 2223;


typedef struct {
 char CtrlType;
 long RawData;
 long Offset;
}  __attribute__ ((packed)) TStatus;   

typedef struct {
 char CtrlType;
 float tempeture;     //nuværende temperatur
 float setpoint;      //Hvad temperatur vi skal nå.
 float weigth;        //Vægten af fadet
 float OutTemp;       //Udendørs temperatur
 float OutHum;        //udendør hymidity
 float Hyst;          //Hysterese  
}  __attribute__ ((packed)) Tsetting;

DigitalOut led(LED_GREEN);  //Indikator på frys
DigitalOut Cool(A3);        //Fryser relæ

HX711 LoadCell(A4,A5); 
DHT dht22(A2,DHT22);  //Udendørs temperatur
 
Serial pc(USBTX, USBRX);     // serial comms over usb back to console
DS18B20 thermom(A1, DS18B20::RES_12_BIT); // Dallas 1-wire
float SetTemp;

Tsetting status;
EthernetInterface eth;
UDPSocket server,sock;;    //Denne server. Modtager data fra PC sock er til at sende data
Endpoint process_server, DataIn;

void ReadTemp() {
    status.tempeture=thermom.GetTemperature()-SensorOffset;
    while ((status.tempeture<-20) || (status.tempeture>110)) status.tempeture=thermom.GetTemperature(); //læs igen
    if (status.tempeture>(status.setpoint+status.Hyst))  {
       Cool=1; led=0;
    }
    if (status.tempeture<(status.setpoint-status.Hyst))  {
       Cool=0; led=1;
    }
    
}    

void ReadSocketDate(void const *args) {
 char buffer[256];
 printf("ReadThread Init Done\r\n");
 while (1) {
    int n = server.receiveFrom(DataIn, buffer, sizeof(buffer));
    if (buffer[0]==0) { //seach function
        if (strcmp(DataIn.get_address(),process_server.get_address())!=0) {
           process_server.set_address(DataIn.get_address(),SERVER_PORT); 
           printf(" New Adress: %s\r\n",DataIn.get_address());
        } 
    }    
    if (buffer[0]==1) {
        memcpy(&status,&buffer[0],sizeof(status));
        printf("NEW Settings [%s]:\r\n",DataIn.get_address());
        printf(" setpoint: %.1f \r\n",status.setpoint);    
    }
    if (buffer[0]==2) {
       printf("Set new zero for loadCell\r\n");
       LoadCell.tare(50); 
    }    
 }       
}    

int main() {
  char out_buffer[sizeof(status)];
  led=1; 
  pc.printf("\n\r---------------------------------------------------------------\n\r");
  pc.printf("Fryser Controller INIT\n\r");
  status.CtrlType=2;
  status.setpoint=0;
  eth.init(); //Use DHCP  
  eth.connect();
  pc.printf("IP Address is %s\n\r", eth.getIPAddress());  
  
  sock.init();
  server.bind(SERVER_PORT);
  
  process_server.set_address(SERVER_ADDRESS, SERVER_PORT);
      
  pc.printf("Temp Sensor: \n\r");
  DS18B20::ROM_Code_t ROM_Code;
  thermom.ReadROM(&ROM_Code);
  pc.printf("Family code: 0x%X\n\r", ROM_Code.BYTES.familyCode);
  pc.printf("Serial Number: ");
  for (unsigned i = 6; i != 0; --i) {
      pc.printf("%02X%s", ROM_Code.BYTES.serialNo[i-1], (i != 1)?":":"\r\n");
  }
  pc.printf("CRC: 0x%X\r\n", ROM_Code.BYTES.CRC);
  Thread DbThread(ReadSocketDate, NULL, osPriorityNormal, (DEFAULT_STACK_SIZE * 2.25));
  
  LoadCell.set_scale(1); //Sættes afhængigt af sensor
  pc.printf("---------------------------------------------------------------\n\r");
  
  pc.printf("\n\rRunning ...\n\r");
  
  
  while (1) {
      ReadTemp();  //
      status.weigth=LoadCell.get_units(20);
      int err=dht22.readData();
       if (err==0) {
          status.OutTemp=dht22.ReadTemperature(CELCIUS);
          status.OutHum =dht22.ReadHumidity();
 //         printf("T: %.1f C",dht22.ReadTemperature(CELCIUS));
//          printf(" H %.1f\% \n\r",dht22.ReadHumidity());          
       }
      //send data til PC
    //  printf("%.1f \r\n",status.tempeture );
      memcpy(&out_buffer[0],&status.CtrlType,sizeof(status));
      sock.sendTo(process_server, out_buffer, sizeof(status)); 
      wait(2);         
  }
}