#include "mbed.h"
#include <stdint.h>
#include "DS18B20.h"
#include "PID.h"
#include "EthernetInterface.h"

#define RATE 1
#define SensorOffset 1.2 //Its about this that they show to must.

char* SERVER_ADDRESS = "172.31.2.3";
const int SERVER_PORT = 2222;

typedef struct {
 char MeassageID;
 float Kp,tauI,tauD;   
}  __attribute__ ((packed)) TPID;    

typedef struct {
 char CtrlType;
 float tempeture;     //nuværende temperatur
 float setpoint; //Hvad temperatur vi skal nå.
 float pump;     //Stilling af pumpen
 char mode;      //0: Auto; 1: manuel
 float PWM;      //Manuel power 
}  __attribute__ ((packed)) Tsetting;

DigitalOut led(LED_GREEN); //Varmelegme
DigitalOut Heat(A3); //Varmelegme
PwmOut Pump(A4);

 
Serial pc(USBTX, USBRX);     // serial comms over usb back to console
DS18B20 thermom(A5, DS18B20::RES_12_BIT); // Dallas 1-wire
float SetTemp;

PID controller(10.0, 0.02, 5.0, RATE);
Timeout TurnOffHeat;
Tsetting status;
EthernetInterface eth;
UDPSocket server,sock;;    //Denne server. Modtager data fra PC sock er til at sende data
Endpoint process_server, DataIn;
TPID PidFactors;

void initSpeedCtrl(void)
{
    controller.setInputLimits(0,100); //0..100 RPM
    //Pwm output from 0.0 to 1.0
    controller.setOutputLimits(0.0, 1.0);
//   controller.setBias(1.0);
    controller.setMode(AUTO_MODE);
    controller.setSetPoint(status.setpoint); //tomgang
}

void HeatOff() {
  Heat=0; led=1; 
}    

void ReadTemp() {
float RegError;    
    status.tempeture=thermom.GetTemperature()-SensorOffset;
    while ((status.tempeture<-20) || (status.tempeture>110)) status.tempeture=thermom.GetTemperature(); //læs igen
    if (status.mode==1) {
    controller.setProcessValue(status.tempeture);
    RegError =controller.compute();
        if (RegError>0.01) {
          Heat=1; led=0;
          TurnOffHeat.attach(&HeatOff,RegError/RATE);  
        }
    }
    if (status.mode==0) {        
        if (status.PWM>0.01) {
          Heat=1; led=0;
          TurnOffHeat.attach(&HeatOff,status.PWM/RATE);  
        }
    }            
}    


void sendStatus() {

}

void ReadSocketDate(void const *args) {
 char buffer[256];
 printf("ReadThread Init Done\r\n");
 while (1) {
    int n = server.receiveFrom(DataIn, buffer, sizeof(buffer));
    if (buffer[0]==0) { //seach function
        if (strcmp(DataIn.get_address(),process_server.get_address())!=0) {
           process_server.set_address(DataIn.get_address(),SERVER_PORT); 
           printf(" New Adress: %s\r\n",DataIn.get_address());
        } 
    }    
    if (buffer[0]==1) {
        memcpy(&status,&buffer[0],sizeof(status));
        printf("NEW Settings [%s]:\r\n",DataIn.get_address());
        printf(" setpoint: %.1f \r\n",status.setpoint);    
        if (!status.mode) printf("Manual mode %.1f\n\r",status.PWM); else printf("Auto mode\n\r");
        printf(" Pump: %.1f \r\n",status.pump);  
        Pump=status.pump/100; 
    }
    if (buffer[0]==2) {
        memcpy(&PidFactors,&buffer[0],sizeof(PidFactors));
        printf("NEW PID %.2f %.2f %.2f\r\n", PidFactors.Kp,PidFactors.tauI,PidFactors.tauD);
        controller.setTunings(PidFactors.Kp,PidFactors.tauI,PidFactors.tauD);
    }    
 }       
}    

int main() {
  char out_buffer[sizeof(status)];
  led=1; 
  Pump.period_ms(1);
  Pump.write(0);
  pc.printf("\n\r---------------------------------------------------------------\n\r");
  pc.printf("BrewController INIT\n\r");
  status.CtrlType=1;
  status.setpoint=0;
  eth.init(); //Use DHCP  
  eth.connect();
  pc.printf("IP Address is %s\n\r", eth.getIPAddress());  
  
  sock.init();
  server.bind(SERVER_PORT);
  
  process_server.set_address(SERVER_ADDRESS, SERVER_PORT);
      
  pc.printf("Temp Sensor: \n\r");
  DS18B20::ROM_Code_t ROM_Code;
  thermom.ReadROM(&ROM_Code);
  pc.printf("Family code: 0x%X\n\r", ROM_Code.BYTES.familyCode);
  pc.printf("Serial Number: ");
  for (unsigned i = 6; i != 0; --i) {
      pc.printf("%02X%s", ROM_Code.BYTES.serialNo[i-1], (i != 1)?":":"\r\n");
  }
  pc.printf("CRC: 0x%X\r\n", ROM_Code.BYTES.CRC);
  Thread DbThread(ReadSocketDate, NULL, osPriorityNormal, (DEFAULT_STACK_SIZE * 2.25));
  
  initSpeedCtrl();
  
  pc.printf("---------------------------------------------------------------\n\r");
  
  pc.printf("\n\rRunning ...\n\r");
  
  
  while (1) {
      ReadTemp(); 
      //send data til PC
      memcpy(&out_buffer[0],&status.CtrlType,sizeof(status));
      sock.sendTo(process_server, out_buffer, sizeof(status));          
    //  printf("Data to: %s Temp= %.1f Out[0] %x \r\n",process_server.get_address(),status.tempeture, out_buffer[0]);
      wait(RATE);
  }
}