#include "mbed.h"

RawSerial pc(USBTX, USBRX);
AnalogIn   Ain1(p19);// --- AttoPilot "V"
AnalogIn   Ain2(p20);// --- AttoPilot "I"

int VRaw; //This will store our raw ADC data
int IRaw;
float VFinal; //This will store the converted data
float IFinal;

int main()
{
    while(1) {
        VRaw = Ain1.read_u16();
        IRaw = Ain2.read_u16();

        //Conversion
        VFinal = VRaw/49.44; //45 Amp board
        //VFinal = VRaw/12.99; //90 Amp board
        //VFinal = VRaw/12.99; //180 Amp board

        IFinal = IRaw/14.9; //45 Amp board
        //IFinal = IRaw/7.4; //90 Amp board
        //IFinal = IRaw/3.7; //180 Amp board
        pc.printf("%.1   Volts\r\n",VFinal);
        pc.printf("%.1f   Amps\r\n\r\n\r\n",IFinal);
        wait(0.2);
    }
}
