#include "mbed.h"
#include "HCSR04.h"
#include "NeoStrip.h"

#define MinDist 150
#define PeriodeTime 100
#define Nsensor 6

HCSR04 *sensor1;
HCSR04 *sensor2;
HCSR04 *sensor3;
HCSR04 *sensor4;
HCSR04 *sensor5;
HCSR04 *sensor6;

Timeout Delay;

Serial pc(USBTX, USBRX);
//int SectionSize[8]={16,16,16,16,16,16,16,16};
int SectionSize[8]= {500,343,285,270,395,443,16,16};
int N=2268;

int TimeToNet=0;
int CallAgain=0;
bool ThereAreSomeThing=0;
int ThereAreNothing=0;

//int N=128;

NeoStrip strip(p22, N);

double LED[8]; //power status
int LedOnOff[8]; //Hvis 1 sættes skal den lave et loop
bool InAktive;
int color[3]= {255,255,255};

long DistArr[6];
int SensorTOCall=0;

int hueToRGB(float h);
void CallNewSensor();
void pattern1();
extern "C" void mbed_reset();
// display a shifting rainbow, all colors have maximum
// saturation and value, with evenly spaced hue
void pattern1()
{
    static float dh = 360.0 / N;
    static float x = 0;

    for (int i = 0; i < N; i++)
        strip.setPixel(i, hueToRGB((dh * i) - x));

    x += 1;
    if (x > 360)
        x = 0;
}

// Converts HSV to RGB with the given hue, assuming
// maximum saturation and value
int hueToRGB(float h)
{
    // lots of floating point magic from the internet and scratching my head
    float r, g, b;
    if (h > 360)
        h -= 360;
    if (h < 0)
        h += 360;
    int i = (int)(h / 60.0);
    float f = (h / 60.0) - i;
    float q = 1 - f;

    switch (i % 6) {
        case 0:
            r = 1;
            g = f;
            b = 0;
            break;
        case 1:
            r = q;
            g = 1;
            b = 0;
            break;
        case 2:
            r = 0;
            g = 1;
            b = f;
            break;
        case 3:
            r = 0;
            g = q;
            b = 1;
            break;
        case 4:
            r = f;
            g = 0;
            b = 1;
            break;
        case 5:
            r = 1;
            g = 0;
            b = q;
            break;
        default:
            r = 0;
            g = 0;
            b = 0;
            break;
    }

    // scale to integers and return the packed value
    uint8_t R = (uint8_t)(r * 255);
    uint8_t G = (uint8_t)(g * 255);
    uint8_t B = (uint8_t)(b * 255);

    return (R << 16) | (G << 8) | B;
}

void update()
{
    int LEDNr=0;
    for (int j=0; j<Nsensor; j++) {
        for (int i=0; i<SectionSize[j]; i++) {
            strip.setPixel(LEDNr,LED[j]*color[0],LED[j]*color[1],LED[j]*color[2]);
            LEDNr++;
        }
    }
    strip.write();
}

void ReadColorFactor()
{
    LocalFileSystem local("local");               // Create the local filesystem under the name "local"
    char str[10];

    FILE *fp = fopen("/local/color.txt", "r");  // Open "out.txt" on the local file system for writing
    if (fp) {
        //fscanf(fp,"%[^\n]",str);
        printf("Reading color.txt \r\n");
        fgets(str, 10, fp);
        printf("%s\r\n",str);
        color[0]=atoi(str);
        fgets(str, 10, fp);
        printf("%s\r\n",str);
        color[1]=atoi(str);
        fgets(str, 10, fp);
        printf("%s\r\n",str);
        color[2]=atoi(str);
        fclose(fp);
    } else
        printf("Cant open file\r\n");
}

void CalcNew()
{
    for (int i=0; i<Nsensor; i++) {
        if ((LedOnOff[i]==2) && (LED[i]>=0)) LED[i]-=0.1; //falder
        if (LedOnOff[i]==1) {
            LED[i]+=0.1;
            //InAktive=0;                 //stiger
        }
        if (LED[i]>1) {                                    //Skift til at gå ned igen
            LedOnOff[i]=2;
            LED[i]=1;
        }
        if ((LedOnOff[i]==2) && (LED[i]<=0.02)) {          //SLuk
            LED[i]=0;
            LedOnOff[i]=0;
        }
    }
    update();
}


void SetAll(float p)
{
    for (int i=0; i<N; i++) {
        strip.setPixel(i,p*255,p*255,p*255);
    }
    strip.write();
}

void SetAllOn()
{
    for (int i=0; i<N; i++) {
        strip.setPixel(i,color[0],color[1],color[2]);
    }
    strip.write();
}


void distance6(long Duration)
{
    //printf("Distance2: %d   %.2f \n\r",Duration, LED[1]);
    DistArr[5]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[5]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=6; //kalder sig selv igen
        }
    } else  {
        LedOnOff[5]=2;
        CallAgain=0;
    }
}


void distance5(long Duration)
{
    //printf("Distance1: %d %.2f  \n\r",Duration, LED[0]);
    DistArr[4]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[4]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=5; //kalder sig selv igen
        }
    } else  {
        LedOnOff[4]=2;
        CallAgain=0;
        SensorTOCall=6;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor

//    sensor6->Trigger();
}

void distance4(long Duration)
{
    //printf("Distance4: %d   %.2f \n\r",Duration, LED[3]);
    DistArr[3]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[3]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=4; //kalder sig selv igen
        }
    } else  {
        LedOnOff[3]=2;
        CallAgain=0;
        SensorTOCall=5;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor

//    sensor5->Trigger();
}

void distance3(long Duration)
{
    //printf("Distance3: %d   %.2f \n\r",Duration, LED[2]);
    DistArr[2]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[2]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=3; //kalder sig selv igen
        }
    } else  {
        LedOnOff[2]=2;
        CallAgain=0;
        SensorTOCall=4;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor

    //sensor4->Trigger();
}

void distance2(long Duration)
{
    //printf("Distance2: %d   %.2f \n\r",Duration, LED[1]);
    DistArr[1]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[1]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=2; //kalder sig selv igen
        }
    } else  {
        LedOnOff[1]=2;
        CallAgain=0;
        SensorTOCall=3;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor
}


void distance1(long Duration)
{

    DistArr[0]=Duration;
    if (Duration<MinDist) {
        if (CallAgain) {
            LedOnOff[0]=1;
            CallAgain=0;
            ThereAreSomeThing=1;
        } else {
            CallAgain++;
            SensorTOCall=1; //kalder sig selv igen
        }
    } else  {
        LedOnOff[0]=2;
        CallAgain=0;
        SensorTOCall=2;
    }
    Delay.attach(&CallNewSensor,0.005); //5ms mellem sensor
}

void CallNewSensor()
{
    switch (SensorTOCall) {
        case 1:
            sensor1->Trigger();
            break;
        case 2:
            sensor2->Trigger();
            break;
        case 3:
            sensor3->Trigger();
            break;
        case 4:
            sensor4->Trigger();
            break;
        case 5:
            sensor5->Trigger();
            break;
        case 6:
            sensor6->Trigger();
            break;
    }
}

int main()
{
    pc.baud(115200);
    printf("Test af sensor\r\n");
    sensor1= new HCSR04(p5,p6,distance1);
    sensor2= new HCSR04(p7,p8,distance2);
    sensor3= new HCSR04(p9,p10,distance3);
    sensor4= new HCSR04(p11,p12,distance4);
    sensor5= new HCSR04(p13,p14,distance5);
    sensor6= new HCSR04(p15,p16,distance6);
    ReadColorFactor();
    N=0;
    for (int a=0; a<8; a++) N+=SectionSize[a];
    printf("Numbers of LED %d\r\n",N);

    float bright = 0.2; // 20% is plenty for indoor use
    strip.setBrightness(bright);    // set default brightness

    SetAll(0);

    while(1) {
        ThereAreSomeThing=0;
        sensor1->Trigger();
        wait(0.05);
        if (ThereAreSomeThing) ThereAreNothing=0; else ThereAreNothing++;
        if (ThereAreNothing>6000) { //5 minutter ingenting
          InAktive=2; //Inaktiv på den måde at denskal lave noget         
        }
        if ((ThereAreSomeThing==0) && (InAktive==2)) InAktive=0; //gå tilbage til almindeligt mode
        if (InAktive) {
            if (TimeToNet) TimeToNet--;
            if ((InAktive==2) && (TimeToNet==0)) { //gør noget
              LED[rand() % 6]=1; //Tænder for en tilfældig
              //Der skal gå et stykke tid
              TimeToNet=60; //3 sek
              CalcNew();
            }    
        }
        if (InAktive==0) {
            CalcNew();
            LedOnOff[0]=2;
            LedOnOff[1]=2;
            LedOnOff[2]=2;
            LedOnOff[3]=2;
            LedOnOff[4]=2;
            LedOnOff[5]=2;
            LedOnOff[6]=2;
            LedOnOff[7]=2;
            printf("Sensor %d %d %d %d %d %d             \r",DistArr[0],DistArr[1],DistArr[2],DistArr[3],DistArr[4],DistArr[5]);
        }
        if (pc.readable()) {
            switch(pc.getc()) {
                case '1':
                    LedOnOff[0]=1;
                    break;
                case '2':
                    LedOnOff[1]=1;
                    break;
                case '3':
                    LedOnOff[2]=1;
                    break;
                case '4':
                    LedOnOff[3]=1;
                    break;
                case '5':
                    LedOnOff[4]=1;
                    break;
                case '6':
                    LedOnOff[5]=1;
                    break;
                    //case 'a':  InAktive=1;     break;
                case 'k': {
                    InAktive=1;
                    SetAllOn();
                    printf("All On !!!!\r\n");
                }
                break;
                case 'K':
                    InAktive=0;
                    break;

                case 'c':
                    printf("Color R %d G %d B %d\r\n",color[0],color[1],color[2]);
                    break;
                case 'r':
                    mbed_reset();
                    break;
                case 'b': {
                    bright+=0.1;
                    if (bright>1.01) bright=0;
                    strip.setBrightness(bright);    // set default brightness
                    printf("brigth %.2f\r\n",bright);
                }
                break;
            }
        }
    }
}