#include "mbed.h"

PwmOut mypwm(PWM_OUT); // PWM Output on Pin PWM/D9 

DigitalOut myled(LED1);

InterruptIn my_button(USER_BUTTON); // USER_BUTTON generates an interrupt  

bool        LongPulse = true ; // remember the pulsewidth

void pressed() {
    if (LongPulse) {
        mypwm.pulsewidth_ms(1);  // change to short pulse 
     }
    else {
        mypwm.pulsewidth_ms (5); // change to long pulse
    }
    LongPulse = !LongPulse ; // remember that pulse width has been changed
}

int main() {
    
    mypwm.period_ms(10);  // 10 ms time between pulses
    mypwm.pulsewidth_ms(1); // pulses with 1 ms duration
    my_button.fall(&pressed); // if USER_BUTTON is pressed then call pressed
     
    
    while(1) {              // Just to show that the program is running
        myled = !myled;     // let LED1 blink  
        wait(1);
    }
}
