#include "mbed.h"
#include "GetForce.h"

GetForce::GetForce(PinName pot): _pot(pot){
}


float GetForce::getGrams (){
    float volts=_pot;
    float grams;
    if (volts>=0.36 and volts<0.56){
       grams= (volts*450.0)/(0.56);
    }else if (volts>=0.56 and volts<=0.69){
       grams= (volts*1000.0)/(0.69);
    }
    return grams;
}

float GetForce::getN (){
    float kilo=getKG();
    float forceN=(kilo)*(9.81);
    return forceN;
}

float GetForce::getKG (){
    float grams=getGrams();
    float KG=grams/1000;
    return KG;
}