#include "mbed.h"
#include "MODSERIAL.h"


/** keep_in_range -> float in, and keep_in_range if less than min, or larger than max **/
void keep_in_range(float * in, float min, float max);

volatile bool looptimerflag;
float sluis10;
int sluis11;
float y;
float y1;
float y2;
float z;
float z1;
float z2;
float numl1;
float numl2;
float numl3;
float denl1;
float denl2;
float denl3;

void setlooptimerflag(void)
{
    looptimerflag = true;
}
    AnalogIn sluis1(PTC2);
    

int main() {
        //START OF CODE
    MODSERIAL pc(USBTX,USBRX);
    pc.baud(115200);
    Ticker looptimer;
    looptimer.attach(setlooptimerflag,0.004);  
    y=0;
    y1=0;
    y2=0;
    z1=0;
    z2=0;
    
    //Low pass, 2 Hz, 2e orde, 1 ms.
    numl1=0.003621681514929;
    numl2=0.007243363029857;
    numl3=0.003621681514929;
    //denl1=1;
    denl2=-1.822694925196308;
    denl3=0.837181651256023;
    
    //INFINITE LOOP 
    while(1) {
        while(looptimerflag != true);
        looptimerflag = false;
        y = sluis1.read();
        z=y*numl1+y1*numl2+y2*numl3-z1*denl2-z2*denl3;

        y1=y;
        y2=y1;
        z1=z;
        z2=z1;
        
       if(z > 0.85)
            sluis11 = 1;
        else
            sluis11 = 0;
        //pc.printf("%f, %i \n\r", sluis10, sluis11);
         //pc.printf("%f \n\r", z);
         pc.printf("%i \n\r", sluis11);


    }
}


//coerces value 'in' to min or max when exceeding those values
//if you'd like to understand the statement below take a google for
//'ternary operators'.
void keep_in_range(float * in, float min, float max)
{
    *in > min ? *in < max? : *in = max: *in = min;
}



