#ifndef MBED_PWMOSCILLATOR_H
#define MBED_PWMOSCILLATOR_H

#include "mbed.h"

/** Creates square-wave frequency output on pin22 with custom frequency. Tested for frequencies from 1Hz to 48MHz.
 *  The accuracy depends heavily on the frequency - at 12, 24, 48 MHz the frequency deviation is less than 1%, but at 20 MHz it is about 20%.
 *  Uses Library FastPWM ( http://mbed.org/users/Sissors/code/FastPWM/ ).       */
class PwmOscillator
{

public:
    
    /** Initialize PwmOscillator instance with frequency [Hz]. 
     * @param frequencyHz  = frequency in Hz (1 ... 48000000)     */
    void initWithFrequency(int frequencyHz);

    /** Start oscillator
     */
    void start();
    
    /** Stop oscillator 
     */
    void stop();
};

#endif
