#include "mbed.h"
#include "PwmOscillator.h"
#include "FastPWM.h"

FastPWM pinOut(p22);

double _period_us = 0;
double _pulsewidth_us = 0;


void PwmOscillator::initWithFrequency(int frequencyHz)
{
    _period_us = (1.0 / (double)frequencyHz)*1000000;
    _pulsewidth_us = _period_us / 2.0;
    pinOut.period_us(_period_us);  
}

void PwmOscillator::start()
{    
    pinOut.pulsewidth_us(_pulsewidth_us);
}

void PwmOscillator::stop()
{
    pinOut = 0;
}
