#include "mbed.h"
#include "SRF05.h"   //http://mbed.org/cookbook/SRF05-Ultrasonic-Ranger
#define PI 3.1415926
#define RPSPUNIT -0.00126766

Serial pc(USBTX, USBRX);

SRF05 srf(p13, p14);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led4(LED4);

PwmOut LF(p21); //left forward
PwmOut LB(p22); //left back
PwmOut RF(p23); //right forward
PwmOut RB(p24); //right back
AnalogIn GyroX(p19); //Gyro X
Ticker ticker;

float ANGLE;
float GYRO;
float INTEGRAL=0.0;
float startangle=0;
float startgyro=0;

//PID loop
float control;
float Kp=0.5;//0.5 works
float Kd=-5.0;//-5.0 works
float Ki=0.5;//0.3 works

float lowpassedGYRO;

void stabilize();

void controlbothmotors(float drive) {
    LF.write(drive > 0 ? drive : 0);
    LB.write(drive < 0 ? -drive : 0);
    RF.write(drive > 0 ? drive : 0);
    RB.write(drive < 0 ? -drive : 0);
}

float toprint[3];

float gyros[3];
I2C i2c(p9, p10);
float gyrcalib[3];

void calibgyro() {

    //activating the wiimotion +
    i2c.start();
    //device address | write
    i2c.write(0x53 << 1 | 0);
    //register address
    i2c.write(0xfe);
    //data
    i2c.write(0x04);
    i2c.stop();

    for (int i = 0; i < 100; i++) {
        //sending a 0x00 to flag that we want data
        i2c.start();
        //device address | write (note new address)
        i2c.write(0x52 << 1 | 0);
        //send 0x00
        i2c.write(0x00);
        i2c.stop();

        //reading the data
        char wmpdata[6];
        i2c.read(0x52 << 1 | 1, wmpdata, 6);
        //pc.printf("%x %x %x %x %x %x\r\n",  wmpdata[0], wmpdata[1], wmpdata[2], wmpdata[3], wmpdata[4], wmpdata[5]);

        gyrcalib[0] += (((wmpdata[3] >> 2) << 8) + wmpdata[0]) / 100;
        gyrcalib[1] += (((wmpdata[4] >> 2) << 8) + wmpdata[1]) / 100;
        gyrcalib[2] += (((wmpdata[5] >> 2) << 8) + wmpdata[2]) / 100;

        wait(0.05);

    }

}

void getgyros(float gyrodata[3]) {
    //sending a 0x00 to flag that we want data
    i2c.start();
    //device address | write (note new address)
    i2c.write(0x52 << 1 | 0);
    //send 0x00
    i2c.write(0x00);
    i2c.stop();

    //reading the data
    char wmpdata[6];
    i2c.read(0x52 << 1 | 1, wmpdata, 6);

    //detect if we ever went into fast mode
    bool fastdiscard = !(wmpdata[3] & 0x02 && wmpdata[4] & 0x02 && wmpdata[3] & 0x01);

    if (fastdiscard)
        led1 = 1;
    else {
        gyrodata[0] = RPSPUNIT * -(((wmpdata[3] >> 2) << 8) + wmpdata[0] - gyrcalib[0]);
        gyrodata[1] = RPSPUNIT * (((wmpdata[4] >> 2) << 8) + wmpdata[1] - gyrcalib[1]);
        gyrodata[2] = RPSPUNIT * (((wmpdata[5] >> 2) << 8) + wmpdata[2] - gyrcalib[2]);
    }

    //pc.printf("yaw: %f, pitch: %f, roll: %f\r\n", gyrodata[0], gyrodata[1], gyrodata[2]);

    //wait(0.05);
}

int main() {

    //pc.baud(115200);

    Timer outputtimer;

    calibgyro();
    printf("%f\r\n", gyrcalib[1]);

    //getstartangle and getstartgyro

    for (int i=0; i<=100; i++) {
        startangle=(startangle*i+srf.read())/(i+1);
        //startgyro=(startgyro*i+GyroX.read())/(i+1);
        wait(0.02);
    }
    startangle = (360.0/(2.0*PI))*asin((startangle-5.0)/16.0);

    //startangle=40.07;
    //lowpassedGYRO=startgyro;

    outputtimer.start();

    //balance
    ticker.attach(&stabilize, 0.01);
    while (1) {
        //printf("Angle in degrees : %.2f\t Gyro : %f\n\r",toprint[0],toprint[1]);
        //printf("Gyro : %.2f\t%.0f\n\r",abs(toprint[1]),toprint[1]);
        if (outputtimer.read()>30.0) {
            led4.write(1.0);
            printf("Startangle : %.2f\n\r",startangle);
        }
        wait(0.1);
    }

}

void stabilize() {
    led1 = 1;
    led2 = 0;

    //Kp
    if (srf.read()>0.0 && srf.read()<30.0)
        ANGLE = (360.0/(2.0*PI))*asin((srf.read()-5.0)/16.0)-startangle;
    //Kd
    getgyros(gyros);
    GYRO = gyros[1];
    //Ki
    float integralcap=1.0/Ki;
    if ((INTEGRAL+control < integralcap) && (INTEGRAL+control > -integralcap))
        INTEGRAL+=control;
    INTEGRAL*=0.98;//0.97 works

    //float howlowpassed=0.0;
    //lowpassedGYRO=howlowpassed*GyroX.read()+(1.0-howlowpassed)*lowpassedGYRO;
    //GYRO = GyroX.read()-lowpassedGYRO;

    float smooth=0.95;//0.95 works
    control=(1.0-smooth)*(Kp*ANGLE + Kd*GYRO + Ki*INTEGRAL)+smooth*control;
    controlbothmotors(control);

    toprint[0]=ANGLE;
    toprint[1]=GYRO;

    led1 = 0;
    led2 = 1;
}