#include "mbed.h"
DigitalOut Redled(LED_RED);
DigitalOut Greenled(LED_GREEN);
DigitalOut Blueled(LED_BLUE);

Serial pc(USBTX, USBRX);
Serial XbeeSerial(PTC17, PTC16); //TX,RX

void Setup()
{
    pc.baud(9600);
    XbeeSerial.baud(9600);
    Redled = 1.0;  // off
    Greenled = 1.0;
    Blueled = 1.0; 
}

void Header()
{
    pc.printf("XBserial_comms_Manual V1.0\n");
    pc.printf("Any character typed from the pc will\n");
    pc.printf("be sent to the remote XBee \n");
    pc.printf("+++ to enter command mode (no CR) \n");
    pc.printf("AT should get OK in response \n"); 
    pc.printf("ATAI = 0 Associated\n");
    pc.printf("ATSH = Serial No H byte\n");
    pc.printf("ATSL = Serial No L byte\n");   
    pc.printf("ATHV = Hardware version\n");
    pc.printf("ATVR = Firmware version\n");
    pc.printf("ATTP = Temperature\n");
    pc.printf("ATDH = Destination Address\n");
    wait(1);
}
// -------- end Header -----------

void Blink(int clr)
// introduces a delay !
{   
    if (clr == 'R') {
        //DigitalOut Redled(LED_RED, 1);
        Redled = 0;     // on
        wait(0.001);
        Redled = 1.0;    // off
    }
    if (clr == 'G') { 
        //DigitalOut Greenled(LED_GREEN, 1);
        Greenled = 0;     // on
        wait(0.001);
        Greenled = 1.0;   // off
    }
    if (clr == 'B') {
        //DigitalOut Blueled(LED_Blue, 1);
        Blueled = 0;     // on
        wait(0.001);
        Blueled = 1.0;   // off
    }
}
// -------- end Blink -----------

void XbeeRelay()
{
    if (XbeeSerial.readable()) {
        pc.putc(XbeeSerial.getc());   //get data from Xbee and send to pc(USB)
        Blink('R');  // Blink introduces a delay of 1ms
    }
    if(pc.readable()) {
        XbeeSerial.putc(pc.getc());  //get data from pc(USB) and send to Xbee
        Blink('G');
    }
}
// don't forget to set the destination addresses on both xbees
// -------- end XbeeRelay -----------


int main()
{
    Setup();

    Header();
    
    Blink('R');  
    wait(1);
    Blink('G');
    wait(1);
    Blink('B');
    
    while (true) {
        XbeeRelay();
    }
}
