////////////////////////////////// LIBRERIAS DEL PROYECTO/////////////////////////////////////////////
#include "mbed.h"// libreria principal mbed
#include "TextLCD.h"// libreria lcd
#include "Keypad.h"// libreria Keypad
#include "DHT11.h"// libreria sensor de humedad y temperatura
//include "clase.h"
#include "math.h"
#include "ds1307.h"
//////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////  CONFIGURACION DE  GPIO ////////////////////////////////////////////
Serial pc(PA_2,PA_3);
DigitalOut myled(PD_13);// configura salida digital y asigna a myled al pin d13
TextLCD lcd(PB_7,PB_8,PB_15,PB_14,PB_13,PB_12,TextLCD:: LCD16x2);// configuracion de conexion de lcd
Keypad  teclado(PC_8,PC_11,PC_7,PC_6,PB_0,PD_6,PD_7,PB_3);
DHT11 dato(PC_5);
DS1307 my1307(PB_7,PB_8);
Ticker flipper1;
Ticker flipper2;
/////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////     DECLARACION DE VARIABLES GLOBALES ////////////////////////////////////
int rtc=0;
int sec=0;
int mins=0;
int hours=0;
int day=0;
int date=0;
int month=0;
int year=0;
int muestreo;
int z;
char key;
int released;
int s; // variable usada en rutina sensor 
int temp;
int temp1;
int hum;
int avrtemp;
int avrhum;
int conteo;
//////////////////////////////Declaracion de funciones///////////////////////////////////////////////////////////

void test_rw(int test);

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////// SUB-RUTina lectura DS1307/////////////////////////////////////////////
 void lecturads1307(){
      // test_rw(my1307.gettime(&sec,&mins,&hours,&day,&date,&month,&year));
       my1307.gettime(&sec,&mins,&hours,&day,&date,&month,&year);
       /*pc.printf("seconds  set are %.2D \n\r",sec);
       pc.printf("minutes  set are %.2D\n\r",mins);
       pc.printf("hours  set are %.2D\n\r",hours);
       pc.printf("day  set are %.2D\n\r",day);
       pc.printf("date  set are %.2D\n\r",date);
       pc.printf("month  set are %.2D\n\r",month);
       pc.printf("year  set are %.2D\n\r",year);
       wait(1);*/
       pc.printf("DATE:\r"); 
       pc.printf("%.2D",day);
       pc.printf(":%.2D",month);
       pc.printf(":%.2D\r",year);
       pc.printf(" %.2D",hours);
       pc.printf(":%.2D",mins);
       pc.printf(":%.2D\n\r",sec);
       }  
//////////////////////////////////////////////////////////////////////////////////////////////////////  
////////////////////////////////////////// SUB-RUTina INTERRUPCION2/////////////////////////////////////////////
void flip2(){
       conteo=conteo + 1;
       temp1=dato.readTemperature();
       muestreo=muestreo+temp1;
   
    
   
    if (conteo==1000){
        avrtemp=(muestreo/conteo) ;
        pc.printf("*PROMEDIO DE TEMPERATURA: \r");  
        pc.printf("%2d C \r ",avrtemp); 
        conteo=0;
        }
    
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////// SUB-RUTina INTERRUPCION1/////////////////////////////////////////////
void flip1(){
    
       pc.printf("**********SE REALIZO REGISTRO DE DATOS********** \n\r");    
       pc.printf("Temperatura:%d C \r ",dato.readTemperature());
       pc.printf("Humedad:%d Hr \r ",dato.readHumidity());
       pc.printf("DATE:\r"); 
       pc.printf("%.2D",day);
       pc.printf(":%.2D",month);
       pc.printf(":%.2D\r",year);
       pc.printf(" %.2D",hours);
       pc.printf(":%.2D",mins);
       pc.printf(":%.2D\n\r",sec);
       pc.printf("**********FIN DE REGISTRO DE DATOS**********\n\r");    
       
    
    
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////// SUB-RUTina test DS1307/////////////////////////////////////////////
 void test_rw(int test){
        if(test==0) pc.printf("Last R/W operation passed\n\r");
        else pc.printf("Last R/W operation failed\n\r");
       }  
//////////////////////////////////////////////////////////////////////////////////////////////////////  
///////////////////////// SUB-RUTina DS1307 calibracion de tiempo/////////////////////////////////////////////
     void DS1307RTC(){
       int junk=0;
       sec= 40;
       mins= 40;
       hours=10;
       day=6;
       date=15;
       month=2;
       year=20;
       test_rw(my1307.settime(sec,mins,hours,day,date,month,year));
       pc.printf("seconds  set are %.2D\n\r",sec);
       pc.printf("minutes  set are %.2D\n\r",mins);
       pc.printf("hours  set are %.2D\n\r",hours);
       pc.printf("day  set are %.2D\n\r",day);
       pc.printf("date  set are %.2D\n\r",date);
       pc.printf("month  set are %.2D\n\r",month);
       pc.printf("year  set are %.2D\n\r",year);
       wait(3);
       
     //while(1){
       test_rw(my1307.gettime(&sec,&mins,&hours,&day,&date,&month,&year));
       pc.printf("seconds  set are %.2D \n\r",sec);
       pc.printf("minutes  set are %.2D\n\r",mins);
       pc.printf("hours  set are %.2D\n\r",hours);
       pc.printf("day  set are %.2D\n\r",day);
       pc.printf("date  set are %.2D\n\r",date);
       pc.printf("month  set are %.2D\n\r",month);
       pc.printf("year  set are %.2D\n\r",year);
       
       junk= 0x39;
       test_rw(my1307.write(0x20,junk));
       pc.printf("Value written to register 0x20 %.2x \n\r",junk);
       junk=0;
       test_rw(my1307.read(0x20,&junk));
       pc.printf("Value read from register 0x20 %.2x \n\r",junk);
    wait(1);
    rtc=1;
    //}     
            //}          
    }
          
/////////////////////////////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////// SUB-RUTina keypad/////////////////////////////////////////////
     void keypad1(){
      // while(1){
        key=teclado.ReadKey();
        if(key== '\0')
          released=1;
        if((key!= '\0')&& (released==1)){
            lcd.printf("%c\n",key);
            released=0;
            }     
            //}          
    }
          
/////////////////////////////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////// SUB-RUTina SENSORE DHT11/////////////////////////////////////////////
     void sensor(){
        s=dato.readData();
        if (s != DHT11::OK){
            lcd.printf("ERROR SENSOR\r\n");
        }    
        else{
           lcd.cls();
           return;
         
            
        }
        pc.printf("Temperatura:%d C \r ",dato.readTemperature());
       //lcd.locate(0,1);
       //lcd.printf( "Hr:%d hr SP: 75 ",dato.readHumidity());
       pc.printf("Humedad:%d Hr \r ",dato.readHumidity());
       
        
    }
          
/////////////////////////////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////// SUB-RUTINA MENU/////////////////////////////////////////////
 void menu(){
      //char tr;
      while(1){
        key=teclado.ReadKey();  
        keypad1();
        
        if(key=='D' ){
        lcd.cls();
        return;
        }
        //tr=key;
        //void inicial();
         
        lcd.locate(0,0);// LOCALIZA INICIO DE TEXTO EN COLUMNAS  Y FILAS
        lcd.printf( "      Menu  " );
        lcd.locate(0,1);
       // lcd.printf( "  Configuracion " );
        //lcd.printf("%c\n", tr );
        //wait(3);
        //lcd.cls();//borra caracters
        if((key!= '\0')&& (released==1)){
            lcd.printf("%c\n",key);
            released=0;
            }          
       }           
          
    }
          
///////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////// SUB-RUTINA INICIAL ///////////////////////////////////////////////
 void inicial(){
   while(1){
        //lcd.cls();
        //keypad1();
        
       //if ( key=='A'){
         //lcd.cls();                        //borra caracters
         //menu();
         //}
         
       sensor();
       lecturads1307();
      
           
       //temp:dato.readTemperature();
       //hum: dato.readHumidity();   
       //lcd.locate(0,0);                   // LOCALIZA INICIO DE TEXTO EN COLUMNAS  Y FILAS
       //lcd.printf( "T :%d C  SP: 40",dato.readTemperature());
       //pc.printf("Temperatura:%d C \r ",dato.readTemperature());
       //lcd.locate(0,1);
       //lcd.printf( "Hr:%d hr SP: 75 ",dato.readHumidity());
       //pc.printf("Humedad:%d Hr \r ",dato.readHumidity());
       wait(1);
            
        }                                 // cierra while
}                                        //  cierra rutina

/////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////// RUTINA  PRINCIPAL //////////////////////////////////////////////
int main() {
    z=0;
    conteo=0;
    muestreo=0;
    avrtemp=0;
    avrhum=0;
    released=1;
    //lcd.printf("helllooo people");// escribe caracteres en el lcd 
    flipper1.attach(&flip1,20.0);
    flipper2.attach(&flip2,0.001);
    while(1) {
        
        //if (rtc==0) DS1307RTC();
   //  lcd.cls();//borra caracters
      //lcd.locate(0,0);// LOCALIZA INICIO DE TEXTO EN COLUMNAS  Y FILAS
      //lcd.printf( "    Proyecto " );
      pc.printf("PROYECTO TUTORIA\n\r " );
      //lcd.locate(0,1);
      //lcd.printf( "    Tutoria " );
      //pc.printf("Tutoria \n\r ");
       wait(3);
      //lcd.cls();//borra caracters
      //lcd.locate(0,0);
      //lcd.printf( "    Sistemas " );
      pc.printf("SISTEMAS MICROPROCESADOS \n\r ");
      pc.printf("GEOVANNY GARCIA \n\r ");
      
      lcd.locate(0,1);
      lcd.printf( "Microprocesados " );
      //pc.printf("MICROPORCESADOS \n\r ");
      wait(2);
      //lcd.cls();//borra caracters
      inicial();
     
      }      
        
    }
     
///////////////////////////////////////////////////////////////////////////////////////////////////////



