
#include "mbed.h"
#include "rtos.h"
#include "color.h"


//Set Up all basic colors
Color black(0.0f,0.0f,0.0f);
Color red(1.0f,0.0f,0.0f);
Color yellow(1.0f,1.0f,0.0f);
Color green(0.0f,1.0f,0.0f);
Color teal(0.0f,1.0f,1.0f);
Color blue(0.0f,0.0f,1.0f);
Color purple(1.0f,0.0f,1.0f);

//PWM pins used D12, D11, D10
PwmOut   ledr(D12);
PwmOut   ledg(D11);
PwmOut   ledb(D10);
DigitalIn btn(USER_BUTTON);
DigitalOut led(LED1);

int state = 0; //State of the button animation

/** Fades LED from one value to the next to calculate animation time
    multiply steps by stepTime

    @param start Starting clor
    @param finish Ending color
    @param step Steps to take to get to color
    @param setTime Time taken by each step
 */
bool fadeTo(Color start, Color finish, float steps, double stepTime)
{
    float rSteps = (finish.r - start.r)/steps;
    float gSteps = (finish.g - start.g)/steps;
    float bSteps = (finish.b - start.b)/steps;

    steps = 1/steps;

    float rStepsCounter = 1.0f - start.r;
    float gStepsCounter = 1.0f - start.g;
    float bStepsCounter = 1.0f - start.b;
    int stateBefore = state; //Used as a temporary variable
    //  and print what the measured voltage should be (assuming VCC = 3.3v)
    for (float i = 0.0f; i < 1.0f; i += steps) {
        rStepsCounter -= rSteps;
        gStepsCounter -= gSteps;
        bStepsCounter -= bSteps;

        ledr = rStepsCounter ;
        ledg = gStepsCounter;
        ledb = bStepsCounter;

        Thread::wait(stepTime*1000);
        if (stateBefore != state) return 0;
    }
    return 1;
}

/** Fades LED through all standard colors (black, red, yellow, green, teal, blue, purple)
    to calculate animation time multiply steps by stepTime by 7

    @param steps Number of steps to take
    @param stepTime Time taken by each step
 */
void fadeThruAll(float steps, float stepTime)
{
    bool cont = 1;
    cont = fadeTo(black, red, steps, stepTime);
    if(cont) cont = fadeTo(red, yellow, steps, stepTime);
    if(cont) cont = fadeTo(yellow, green, steps, stepTime);
    if(cont) cont = fadeTo(green, teal, steps, stepTime);
    if(cont) cont = fadeTo(teal, blue, steps, stepTime);
    if(cont) cont = fadeTo(blue, purple, steps, stepTime);
    if(cont) cont = fadeTo(purple, black, steps, stepTime);
}


/** This is the thread used for controlling the LED rendering state. This state
    is modified by the btnPresses process through the use of the state global
    variable.
*/
void renderColors(void const * arg)
{
    while (1) {
        switch(state) {
            case 0:
                fadeThruAll(100.0f, 0.025f);
                break;
            case 1:
                fadeThruAll(1.0f,0.1f);
                break;
            case 2:
                state = 0;
                break;
            default:
                state = 0;
                break;
        }
    }
}

enum SMBtnStates {SMBtnStart, SMBtnPressedOff, SMBtnUnpressedOff, SMBtnPressedOn, SMBtnUnpressedOn} SMBtnState;
/** This is the thread used to gather button presses information. This is a simple State machine of a button
    press.
     ___________      _______________
    |           |    |               |
    |SMBtn Start| -> |SMBtnPressedOFF|
    |___________|    |_______________|
*/
void btnPresses(void const * arg)
{
    while(1) {
        switch(SMBtnState) {
            case SMBtnStart:
                SMBtnState = SMBtnUnpressedOff;
                break;
            case SMBtnUnpressedOff:
                if(!btn) SMBtnState = SMBtnPressedOn;
                break;
            case SMBtnPressedOn:
                if(btn) {
                    SMBtnState = SMBtnUnpressedOn;
                    state++;
                    led = 1;
                }
                break;
            case SMBtnUnpressedOn:
                if(!btn) SMBtnState = SMBtnPressedOff;
                break;
            case SMBtnPressedOff:
                if(btn) {
                    SMBtnState = SMBtnUnpressedOff;
                    state++;
                    led = 0;
                }
                break;
            default:
                SMBtnState = SMBtnStart;
                break;
        }

        switch(SMBtnState) {
            case SMBtnStart:
                SMBtnState = SMBtnUnpressedOff;
                break;
            case SMBtnUnpressedOff:
                break;
            case SMBtnPressedOn:
                break;
            case SMBtnUnpressedOn:
                break;
            case SMBtnPressedOff:
                break;
            default:
                SMBtnState = SMBtnStart;
                break;
        }
    }
}

/** Main thread control
*/
int main()
{
    Thread thread1(renderColors);
    Thread thread2(btnPresses);
    while(true) {};
}
