#include "EventLoop.h"
#include "rtos.h"


EventLoop::EventLoop(osPriority priority,
                     unsigned event_count,
                     unsigned event_context,
                     unsigned char *event_pointer,
                     uint32_t stack_size,
                     unsigned char *stack_pointer)
        : EventQueue(event_count, event_context, event_pointer) {
    _running = false;
    _priority = priority;
    _stack_size = stack_size;
    _stack_pointer = stack_pointer;
}

EventLoop::EventLoop(bool start,
                     osPriority priority,
                     unsigned event_count,
                     unsigned event_context,
                     unsigned char *event_pointer,
                     uint32_t stack_size,
                     unsigned char *stack_pointer)
        : EventQueue(event_count, event_context, event_pointer) {
    _running = false;
    _priority = priority;
    _stack_size = stack_size;
    _stack_pointer = stack_pointer;

    if (start) {
        EventLoop::start();
    }
}

EventLoop::~EventLoop() {
    stop();
}

osStatus EventLoop::start() {
    if (_running) {
        return osOK;
    }

    _running = true;
    _thread = new Thread(run, this, _priority, _stack_size, _stack_pointer);
    if (!_thread) {
        return osErrorNoMemory;
    }

    return osOK;
}

osStatus EventLoop::stop() {
    if (!_running) {
        return osOK;
    }

    Thread *thread = _thread;
    _thread = 0;

    _running = false;
    while (true) {
        uint8_t state = thread->get_state();
        if (state == Thread::Inactive || state == osErrorParameter) {
            break;
        }

        osStatus status = Thread::yield();
        if (status != osOK) {
            break;
        }
    }

    delete thread;
    return osOK;
}

void EventLoop::run(const void *p) {
    EventLoop *loop = (EventLoop *)p;

    while (loop->_running) {
        loop->dispatch(0);
        Thread::yield();
    }
}

