#include "Event.h"

#include "LWIPInterface.h"
#include "TCPServer.h"
#include "SimpleHTTP.h"

DigitalOut led_red  (LED_RED  , true);
DigitalOut led_green(LED_GREEN, true);
DigitalOut led_blue (LED_BLUE , true);
unsigned count_red = 0;
unsigned count_green = 0;
unsigned count_blue = 0;

LWIPInterface lwip;
SimpleHTTP http(&lwip);

#define IMAGE_URL (                                     \
    "https://developer.mbed.org/media/cache/platforms/" \
    "FRDM-K64F_400x300_WO6GnVU.png.250x250_q85.jpg"     )

#define PROJECT_URL (                                              \
    "https://developer.mbed.org/users/geky/code/SimpleHTTPExample" )

int page(char *buffer, unsigned size) {
    printf("%s\r\n", strtok(buffer, "\r\n"));

    return snprintf(buffer, size,
        "<html>\r\n"
          "<head>\r\n"
            "<title>k64f</title>\r\n"
            "<style>\r\n"
              "body { "
                "text-align: center; "
                "margin: auto; "
                "width: 250px; }\r\n"
              "h3 { margin: 10px 0 0; }\r\n"
              ".led { "
                "width: 50px; "
                "height: 50px; "
                "border: 1px; "
                "cursor: pointer; }\r\n"
              ".stats { text-align: left; }\r\n"
              ".left  { float: left;  }\r\n"
              ".right { float: right; }\r\n"
              ".red_on    { background-color: #f00; }\r\n"
              ".green_on  { background-color: #0f0; }\r\n"
              ".blue_on   { background-color: #00f; }\r\n"
              ".red_off   { background-color: #800; }\r\n"
              ".green_off { background-color: #080; }\r\n"
              ".blue_off  { background-color: #008; }\r\n"
            "</style>\r\n"
          "</head>\r\n"
          "<body>\r\n"
            "<p>\r\n"
              "<h3>k64f says hello!</h3>\r\n"
              "<a href=%s>source code</a>\r\n"
            "</p>\r\n"
            "<img src=%s>\r\n"
            "<p>\r\n"
              "<form>\r\n"
                "<input type=submit name=toggle value=red   class=\"led red_%s\"  ></input>\r\n"
                "<input type=submit name=toggle value=green class=\"led green_%s\"></input>\r\n"
                "<input type=submit name=toggle value=blue  class=\"led blue_%s\" ></input>\r\n"
              "</form>\r\n"
            "</p>\r\n"
            "<p class=\"stats left\">\r\n"
              "red: %d<br>\r\n"
              "green: %d<br>\r\n"
              "blue: %d<br>\r\n"
            "</p>\r\n"
            "<p class=\"stats right\">\r\n"
              "errors: %d<br>\r\n"
              "accepts: %d<br>\r\n"
              "sent: %d<br>\r\n"
              "recv: %d<br>\r\n"
            "</p>\r\n"
          "</body>\r\n"
        "</html>\r\n"
        , PROJECT_URL
        , IMAGE_URL
        , led_red   ? "off" : "on"
        , led_green ? "off" : "on"
        , led_blue  ? "off" : "on"
        , count_red
        , count_green
        , count_blue
        , http.get_errors()
        , http.get_accepts()
        , http.get_sent()
        , http.get_recv());
}

int page_toggle(DigitalOut *led, unsigned *count, char *buffer, unsigned size) {
    *led = !*led;
    (*count)++;
    return page(buffer, size);
}

Binder<int(DigitalOut*, unsigned*, char*, unsigned), DigitalOut*, unsigned*>
    toggle_red  (page_toggle, &led_red,   &count_red  ),
    toggle_green(page_toggle, &led_green, &count_green),
    toggle_blue (page_toggle, &led_blue,  &count_blue );

int main() {
    lwip.connect();

    http.get("/", page);
    http.get("/?toggle=red",   &toggle_red);
    http.get("/?toggle=green", &toggle_green);
    http.get("/?toggle=blue",  &toggle_blue);
    http.start();

    printf("Hi! I'm at %s\r\n", lwip.get_ip_address());
}

