#!/usr/bin/env python

import sys
import time


FILE_TEMPLATE = """
/*** Auto generated on %s ***/

struct flash_page {
    uint32_t address;
    uint32_t size;
    const char *data;
};

#define FLASH_COUNT %d
struct flash_page FLASH_PAGES[FLASH_COUNT] = {
%s
};
"""

PAGE_TEMPLATE = """    { 0x%05x, 0x%05x, (const char []){
        %s
    }}"""
    

def main(*args):
    if len(args) < 2:
        print 'Usage: %s <address> <file> <address> <file>...' % sys.argv[0]
        sys.exit(-1)
        
    pages = []

    for addr, filename in zip(*[iter(args)]*2):
        with open(filename, 'rb') as file:
            addr = int(addr, 0)
            data = file.read()
            size = len(data)
            
            lines = zip(*[('0x%02x' % ord(x) for x in data)]*16)
            array = ',\n        '.join(','.join(line) for line in lines)
            
            pages.append(PAGE_TEMPLATE % (addr, size, array))
            
    sys.stdout.write(FILE_TEMPLATE % (
        time.strftime("%d/%m/%Y"),
        len(pages),
        ',\n'.join(pages)
        ))            
    
if __name__=="__main__":
    main(*sys.argv[1:])
