#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCVariable.h"
#include "RPCFunction.h"

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");

void setBufferedVariables();

int Flag = 0;

float SwitchingFrequency = 10;
float FundamentalFrequency = 20;
float ModulationIndex = 30;
float PhaseShift12 = 40;
float PhaseShift23 = 50;
float DeadTime = 60;

float SwitchingFrequencyBuff = SwitchingFrequency;
float FundamentalFrequencyBuff = FundamentalFrequency; 
float ModulationIndexBuff = ModulationIndex;
float PhaseShift12Buff = PhaseShift12;
float PhaseShift23Buff = PhaseShift23;
float DeadTimeBuff = DeadTime;

RPCVariable<int> RPCFlag(&Flag, "Flag");

RPCVariable<float> RPCSwitchingFrequency(&SwitchingFrequency, "SwitchingFrequency");
RPCVariable<float> RPCFundamentalFrequency(&FundamentalFrequency, "FundamentalFrequency");
RPCVariable<float> RPCModulationIndex(&ModulationIndex, "ModulationIndex");
RPCVariable<float> RPCPhaseShift12(&PhaseShift12, "PhaseShift12");
RPCVariable<float> RPCPhaseShift23(&PhaseShift23, "PhaseShift23");
RPCVariable<float> RPCDeadTime(&DeadTime, "DeadTime");

RPCVariable<float> RPCSwitchingFrequencyBuff(&SwitchingFrequencyBuff, "SwitchingFrequencyBuff");
RPCVariable<float> RPCFundamentalFrequencyBuff(&FundamentalFrequencyBuff, "FundamentalFrequencyBuff");
RPCVariable<float> RPCModulationIndexBuff(&ModulationIndexBuff, "ModulationIndexBuff");
RPCVariable<float> RPCPhaseShift12Buff(&PhaseShift12Buff, "PhaseShift12Buff");
RPCVariable<float> RPCPhaseShift23Buff(&PhaseShift23Buff, "PhaseShift23Buff");
RPCVariable<float> RPCDeadTimeBuff(&DeadTimeBuff, "DeadTimeBuff");



LocalFileSystem fs("webfs");

EthernetNetIf eth(
    IpAddr( 192, 168, 0, 128 ), // IP Address
    IpAddr( 255, 255, 255, 0 ), // Network Mask
    IpAddr( 192, 168, 0, 254 ), // Gateway
    IpAddr( 10, 41, 196, 60)    // DNS
);  
HTTPServer svr;

int main() {
  Base::add_rpc_class<DigitalOut>();

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
  
  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/"); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
  
  svr.bind(80);
  
  printf("Listening...\n");
  
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(Flag==1){
        setBufferedVariables();
        printf("Switching Freq is: %f\n", SwitchingFrequency);
        printf("Fundamental Freq is: %f\n", FundamentalFrequency);
        printf("Modulation Index is: %f\n", ModulationIndex);
        printf("Phase Shift 1-2 is: %f\n", PhaseShift12);
        printf("Phase Shift 2-3 is: %f\n", PhaseShift23);
        printf("Deadtime is: %f\n", DeadTime);
        Flag = 0;
    }
    /*
    if(tm.read()>.1)
    {
      led2=!led2; //Show that we are alive
     
      
      tm.start();

    }*/
  }
  
  return 0;

}

void setBufferedVariables(){
    SwitchingFrequency = SwitchingFrequencyBuff;
    FundamentalFrequency = FundamentalFrequencyBuff;
    ModulationIndex = ModulationIndexBuff;
    PhaseShift12 = PhaseShift12Buff;
    PhaseShift23 = PhaseShift23Buff;
    DeadTime = DeadTimeBuff;
    printf("Daten schreiben\n");
}
