//  server v4 ou version 4   modified LRSD  
//  for mbed with  TestBed  card  Electronik laden
// Example d' HTTPServer 
// * SNTP Client (Simple NTP)
// * Link status indication (LED4 or RJ45 socket LED on MBED-BoB2-mod)
// * Local file system 
// * SD-based WebServer ,  sd card 128meg only **.htm  8.3
//  LRSD  evolution from    pub-iva2k-ethsntp  project
// Instructions:
// 1  Plug ETH connector into your network (with a switch beetwen   pc)
// 3  Plug MBED tu pc  using USB cable
// 4  need to have Installed MBED serial driver (http://mbed.org/handbook/SerialPC)
// 5     Copy compiled .bin to your MBED (make sure target device selected in the compiler is correct)
// 6  Open terminal on the mbed serial port
// 7  Push MBED reset button
// 8  Terminal will display info message with mac address, followed by IP address 
// 9  Open browser and enter the following URL:    http://192,168,1,77/   !! ( sd card site)
// 10 The browser will show "index.htm"  web page that you put in the sd card
// 11 Open browser and enter the following URL:  http://192,168,1,77/testbed.htm  
// 12 here in  your browser     clic on Led  on ou off  !!
// 13               or  Lecture , an1.htm in sd  show a voltage in testbed ( pot)
// 14               or put a number and envoyer , give a number to testbed card     
// les fichiers htm utiles a mettre en SD sont dans le r'epertoire htm.                
//modifs   lxip/HHTPServer/testbed.h  description des adresses a decoder pour les actions dans loop
 
// global usefull things 
int aip4,aip3,aip2,aip1;  
int pon4,pon3,pon2,pon1;  
int gDebug=1;
int var = 0;   // image pour la led 
int adc = 0; 
char rr;
float ana = 1.0;
float gWait = 0.05;        // Main loop wait timeout
char *url = "0123            ";
char *add = "0000      ";
char *lieu ;
int  par1 ; 

#include "mbed.h"
#include "NewTextLCD.h"
#include "SDFileSystem.h"
#include "HTTPRPC.h"
#include "HTTPServer.h"
#include "HTTPFS.h"
#include "HTTPStaticPage.h"
#include "HTTPLinkStatus.h"
#include "SNTPClient.h"
#define CLS "\033[2J"


    // E/S sur  la carte mbed 005.1
DigitalOut led1(LED1, "led1");  // mbed
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
    // E/S  hors carte mbed sur la carte TestBed
DigitalIn sw1(p8, "sw1");       // testbed bt1  ( bt2 on  sd card !!)
DigitalOut led5(p6, "led5");    // 2 led on testbed
DigitalOut led6(p5, "led6");
AnalogIn Potm(p15);             //potentiometre carte testbed 
TextLCD lcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4); // testbed LCD
LocalFileSystem local("local");
SDFileSystem sd(p11, p12, p13, p14, "sd");        //test bed sd card 

extern Ethernet eth;        // eth is defined elsewhere, avoid compiler error.
Serial pc(USBTX, USBRX);    // usb sur la Mbed


//*******************************************MAIN***************************
//****************************************************************************   
    int main(void)
     {
    lcd.cls();
    pc.baud(115200);
    lcd.printf("LRSD Webserver V4 \n");
    printf("LRSD  debout  !!\n");
      
    char mac[6];
    bool use_sd = false;
    char res[16]= "<H2>000000";    // resultat conv an 
    char rr[10]= "00000000";
    led1=1; led2=1; led3=1;  led4=1; led5 = 0;  //led off

    // Start RTC
    time_t seconds = time(NULL);
    if (seconds == (unsigned)-1 || seconds == 0) {
      seconds = 1256729737;     // Set RTC time to Wed, 28 Oct 2009 11:35:37
      set_time(seconds);
      printf("RTC initialized, start time %d seconds\r\n", seconds);
    }
    
       aip4 = 192; aip3 = 168 ; aip2 = 1 ; aip1 = 77;      
       pon4 = 192; pon3 = 168 ; pon2 = 1 ; pon1 = 0;      
    lcd.locate(0,1); 
    lcd.printf("IP:%hhu.%hhu.%hhu.%hhu\n",   aip4, aip3, aip2, aip1); 
     HTTPServer http("mbed",                  //  static IP address and domain name.
                 IPv4(aip4,aip3,aip2,aip1),   // IPv4 is a helper function which allows to rtype ipaddresses direct
                 IPv4(255,255,0,0),        
                 IPv4(pon4,pon3,pon2,pon1),        
                 IPv4(pon4,pon3,pon2,pon1),   
                   80);             // port 80  souvent 
    char *hostname = "mbed";
   // HTTPServer http(hostname);    // Use DHCP
    http.timeout(10000);    // Sets the timout for a HTTP request.  The timout is the time which is allowed to spent between two incomming TCP packets.  If the time is passed the connection will be closed.
   
    eth.address(mac);
    pc.printf(CLS "\r\n\r\nHTTPServer \"%s\" started\r\nMAC %02X:%02X:%02X:%02X:%02X:%02X\r\n%s",
        hostname, mac[0], mac[1], mac[2], mac[3], mac[4], mac[5],
        gDebug?"Debug is ON\r\n":""
    );

    // Check if we can use SD card for the web server
    FILE *fp = fopen("/sd/index.htm", "r");
    if (fp == NULL) {
        if (gDebug) printf("DEBUG: No SD card found or no index.htm file - using LocalFilesystem for WebServer.\r\n");
    } else {
        use_sd = true;
        fclose(fp);
        if (gDebug) printf("DEBUG: Found SD card with index.htm file - using SD for WebServer.\r\n");
    }

    if (0 != SNTPReadIniFile("/sd/sntp.ini") )
        SNTPReadIniFile("/local/sntp.ini");
    SNTPWriteIniFile(stdout);

    http.addHandler(new HTTPLinkStatus("/", 
#if MBED_BOB2
      p25, p26,            // MBED-BoB2-mods
#else
      LED3, LED4,
#endif
      0.1,   // ici ???
      /*do_urlfile*/ true, /*do_link_printf*/ true, /*do_log_printf*/ false, 
      /*log_file*/ ( (gDebug>1) ? (use_sd ? "/sd/httpd.log" : "/local/httpd.log") : NULL)
    ));    // Should be the first handler to get a preview of all requests
    //  fin du ici ?? 
    
    http.addHandler(new HTTPFileSystemHandler("/", use_sd ? "/sd/" : "/local/"));
    led3=0;

// FIXME: BUG If eth is not plugged, http.bind() hangs!
    http.bind();
    SNTPClientInit();
    led4 = 0;
   // pc.printf("\r");    // Add linefeed for stupid Hyperterminal
    
    while(1) {  //BOUCLE POLL
        http.poll();    // Have to call this method at least every 250ms to let the http server run.      
        wait(gWait);
        
       ana = Potm.read();   //  travail en temps reel like ( gWait)
       lcd.locate(0,2); //ligne 2 lcd 
       ana = 3.2*ana;   // mise au niveau 3v2
              lcd.printf("Value: %1.2f", ana);
              sprintf(rr, "%f", ana);  // met ana en chaine dans rr[]
              res[4]=rr[0];  res[5]=rr[1]; res[6]=rr[2]; res[7]=rr[3] ;res[8]=rr[4];  // on fait mieux
              res[9]='V' ;res[10]= 0;
 
  if ( adc == 1)
          {
          FILE *fp = fopen("/sd/an1.htm", "w");     // on met an1 en sd card , il sera lu par le code html 
          fprintf( fp,res );   
          fclose(fp);
         
          adc = 0;
          }      
         
  lcd.locate(0,3);
  lcd.printf("retour = %2hhu\n", par1);     
  if ( var == 1) {led6 = 1 ;}  // dans serveur on scrute et on force var 
  else { led6 = 0;}
  if ( par1 > 0 ) { led5 = !led5 ; par1 = par1 - 1; }  // exemple clignote "par1" fois
  if ( par1 == 0 ) led5=1;
    }
}

//END