// myrpc.cpp
#include "myrpc.h"
#ifdef MBED_RPC
#include "rpc.h"
#endif

#include "SNTPClient.h"

extern int gDebug;

namespace mbed {
myrpc::myrpc(PinName pin, const char *name) : Base(name), _pin(pin) {}

void myrpc::debug(int val)
 {   //  
  gDebug=val; 
  printf("Debug is %s\r\n", gDebug ? "ON" : "OFF");
 }

void myrpc::blink(int n)
 {//  ... led/blink,1 n fois    
  for (int i=0; i<n; i++) {
    _pin = 1;  //_pin ?
    wait(0.2);
    _pin = 0;
    wait(0.2);
                            }
  }

char *myrpc::echo(const char * in) {
printf("DEBUG myrpc::echo() IN=%s\r\n",in);
    sprintf(_buffer, "%s", in);
    return _buffer;
}

void myrpc::settime(const char *t) {
  time_t seconds = time(NULL);
  if (seconds == (unsigned)-1 || seconds == 0) {
    seconds = 1256729737;     // Set RTC time to Wed, 28 Oct 2009 11:35:37
  }
//  set_time(seconds);
  SNTPSetTime(seconds);
  strftime(_buffer, sizeof(_buffer), "%A %m/%d/%Y %H:%M:%S", localtime(&seconds));
  printf("settime(%s) seconds=%d datetime=%s\r\n", t, seconds, _buffer);
}
char *myrpc::gettime(const char *fmt="%A %m/%d/%Y %H:%M:%S") {
//  time_t seconds = time(NULL);
  time_t seconds = SNTPTime();
//printf("Time as seconds since January 1, 1970 = %d\r\n", seconds);
//printf("Time as a basic string = %s\r\n", ctime(&seconds));
  if (!fmt || !fmt[0])
    fmt = "%A %m/%d/%Y %H:%M:%S";
  strftime(_buffer, sizeof(_buffer), fmt, localtime(&seconds));
  return _buffer;
}

#ifdef MBED_RPC
const rpc_method *myrpc::get_rpc_methods() {
  static const rpc_method rpc_methods[] = {
    { "debug", rpc_method_caller<myrpc, int, &myrpc::debug> },
    { "blink", rpc_method_caller<myrpc, int, &myrpc::blink> },
    { "echo", rpc_method_caller<char *, myrpc, const char *, &myrpc::echo> },
    { "settime", rpc_method_caller<myrpc, const char *, &myrpc::settime> },
    { "gettime", rpc_method_caller<char *, myrpc, const char *, &myrpc::gettime> },
    RPC_METHOD_SUPER(Base)
  };
  return rpc_methods;
}       
rpc_class *myrpc::get_rpc_class() {
    static const rpc_function funcs[] = {
        "new", rpc_function_caller<const char*, PinName, const char*, &Base::construct<myrpc,PinName,const char*> >,
        RPC_METHOD_END
    };
    static rpc_class c = { "myrpc", funcs, NULL };
    return &c;
}
#endif

}    // namespace mbed
