// original Written by IVA2K  modified LRSD  
//  adapted to TestBed  card for  Electronik laden
// Example of HTTPServer 
// * SNTP Client (Simple NTP)
// * Link status indication (LED4 or RJ45 socket LED on MBED-BoB2-mod)
// * Local file system 
// * SD-based WebServer ,  sd card 128meg only **.htm  8.3
// * Static HTM page
// * Dynamic HTM page  a tester 
// LRSD  evolution from    pub-iva2k-ethsntp  project
//  not so good but works. 
// Instructions:
// 1  Plug ETH connector into your network (with a switch beetwen   pc)
// 3  Plug MBED tu pc  using USB cable
// 4  need to have Installed MBED serial driver (http://mbed.org/handbook/SerialPC)
// 5     Copy compiled .bin to your MBED (make sure target device selected in the compiler is correct)
// 6  Open terminal on the mbed serial port
// 7  Push MBED reset button
// 8  Terminal will display info message with mac address, followed by IP address 
//    in the following items, i put  192.168.1.77 
// 9  Open browser and enter the following URL:    http://192,168,1,77   !! ( sd card site)
// 13 Open browser and enter the following URL:    http://192.168.1.77/static.htm
// 14 The browser will show static HTML page  writen in defhtm.h   
// 16   if you clic on Led ( in browser) led5 from testbed light on ou off
//     led change , and the browser is redirected to static.htm

int aip4,aip3,aip2,aip1;  
int pon4,pon3,pon2,pon1;  
int gDebug=1;
float ana = 1.0;
float gWait = 0.05;        // Main loop wait timeout


#include "mbed.h"
DigitalOut led5(p6, "led5");  // avant led.h
#include "NewTextLCD.h"
#include "SDFileSystem.h"
#include "HTTPRPC.h"
#include "HTTPServer.h"
#include "HTTPFS.h"
#include "HTTPStaticPage.h"
#include "HTTPled.h"   // 
#include "HTTPDynamicPage.h"
#include "HTTPLinkStatus.h"
#include "SNTPClient.h"
#define CLS "\033[2J"


#define MAX_DYNAMIC_CONTENT_LEN     2048         // a exploiter mieux
char dynamic_content[MAX_DYNAMIC_CONTENT_LEN];
   const char content_fmt[] = 
    "<HTML>"
    "<HEAD>"
    "<title>Dynamic Page</title>"
    "</HEAD>"
    "<BODY>"                                 //
    "<H1>Hello l'univers </H1>"              // "<H1>Hello World</H1>"               
    "<p>Page generated dynamically from code.</p>"
    "<p>URL=%s</p>"
    "<p>Header Fields=%s</p>"
    "</BODY></HTML>"
    ;
    // E/S sur  la carte mbed 005.1
DigitalOut led1(LED1, "led1");  // mbed
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
    // E/S  hors carte mbed sur la carte TestBed
DigitalIn sw1(p8, "sw1");       // testbed bt1  ( bt2 on  sd card !!)
//DigitalOut led5(p6, "led5");
DigitalOut led6(p5, "led6");
AnalogIn Potm(p15);             //potentiometre carte testbed 
TextLCD lcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4); // testbed LCD
LocalFileSystem local("local");
SDFileSystem sd(p11, p12, p13, p14, "sd");        //test bed sd card 

#include "myrpc.h"  // ici on ecrit les pages web dans des tableaux 
myrpc le(p6, "le"); // fonction apelable par l'adresse 

extern Ethernet eth;        // eth is defined elsewhere, avoid compiler error.
Serial pc(USBTX, USBRX);    // usb sur Mbed l'autre sur testbed ??


HTTPStatus myDynamicPage(HTTPConnection *con, HTTPDynamicPageData *pd) {
#if 0
    // Static example. With this, we don't really need HTTPStaticPage
    pd->size = 0;    // let it measure our page
    pd->page = (char*)content; // Nothing dynamic about that yet, but we can now get loose here.
    pd->page_free = NULL;      // No mem free() needed
#elif 0
    // Dynamic example, static buffer
    pd->size = sprintf(dynamic_content, content_fmt, con->getURL(), con->getHeaderFields());
    pd->page = (char*)dynamic_content;
    pd->page_free = NULL;    // No mem free() needed
if(pd->size > sizeof(dynamic_content)) printf("ASSERTION FAILED: %s:%d\r\n", __FILE__, __LINE__);    // Buffer overrun
#else
    // Dynamic example, dynamic buffer
    int size = sizeof(content_fmt) + 512;    // Just guess how much the data will expand
    char *buf = (char *)malloc(size);
    if (buf) {
        pd->size = sprintf(buf, content_fmt, con->getURL(), con->getHeaderFields());
        pd->page = buf;
        pd->page_free = &free;    // Use free() when done
if(pd->size > size) printf("ASSERTION FAILED: %s:%d\r\n", __FILE__, __LINE__);    // Buffer overrun
#endif
    }
    return HTTP_OK;
}
//*******************************************MAIN***************************
//****************************************************************************   
    int main(void)
     {
    lcd.cls();
    pc.baud(115200);
    lcd.printf("LRSD Webserverv2 \n");
    printf("LRSD  debout  !!\n");
    // initialisation de   static.htm en ram  local 
    #include "defhtm.h"
    
  
    char mac[6];
    bool use_sd = false;
    char res[10]= "1234000";
    int  pt = 0;  // pointeur dans tab 128 c'est sur le *
    led1=1; led2=1; led3=1;  led4=1; led5 = 0;  //led off

    // Start RTC
    time_t seconds = time(NULL);
    if (seconds == (unsigned)-1 || seconds == 0) {
      seconds = 1256729737;     // Set RTC time to Wed, 28 Oct 2009 11:35:37
      set_time(seconds);
      printf("RTC initialized, start time %d seconds\r\n", seconds);
    }
    
    led6 = sw1;
    if ( sw1 == 0 )
      { aip4 = 172; aip3 = 20 ; aip2 = 140 ; aip1 = 49; //BT1 on > adresse de  mon  PC
        pon4=  172; pon3 = 20 ; pon2 = 0   ; pon1 = 254;}
    else
      { aip4 = 192; aip3 = 168 ; aip2 = 1 ; aip1 = 77;      // si on ne touche pas BT1 adresse  box
        pon4 = 192; pon3 = 168 ; pon2 = 1 ; pon1 = 0;  }     // si on ne touche pas BT1 adresse  box
    lcd.locate(0,1); 
    lcd.printf("IP:%hhu.%hhu.%hhu.%hhu\n",                  
                  aip4, aip3, aip2, aip1); 
     HTTPServer http("mbed",                  //  static IP address and domain name.
                 IPv4(aip4,aip3,aip2,aip1),   // IPv4 is a helper function which allows to rtype ipaddresses direct
                 IPv4(255,255,0,0),        
                 IPv4(pon4,pon3,pon2,pon1),        
                 IPv4(pon4,pon3,pon2,pon1),   
                   80);             // port 80  souvent 
    char *hostname = "mbed";
   // HTTPServer http(hostname);    // Use DHCP
    http.timeout(10000);    // Sets the timout for a HTTP request.  The timout is the time which is allowed to spent between two incomming TCP packets.  If the time is passed the connection will be closed.
   
    eth.address(mac);
    pc.printf(CLS "\r\n\r\nHTTPServer \"%s\" started\r\nMAC %02X:%02X:%02X:%02X:%02X:%02X\r\n%s",
        hostname, mac[0], mac[1], mac[2], mac[3], mac[4], mac[5],
        gDebug?"Debug is ON\r\n":""
    );

    Base::add_rpc_class<myrpc>();
    led1=0;
    // Check if we can use SD card for the web server
    FILE *fp = fopen("/sd/index.htm", "r");
    if (fp == NULL) {
        if (gDebug) printf("DEBUG: No SD card found or no index.htm file - using LocalFilesystem for WebServer.\r\n");
    } else {
        use_sd = true;
        fclose(fp);
        if (gDebug) printf("DEBUG: Found SD card with index.htm file - using SD for WebServer.\r\n");
    }

    if (0 != SNTPReadIniFile("/sd/sntp.ini") )
        SNTPReadIniFile("/local/sntp.ini");
    SNTPWriteIniFile(stdout);

    http.addHandler(new HTTPLinkStatus("/", 
#if MBED_BOB2
      p25, p26,            // MBED-BoB2-mods
#else
      LED3, LED4,
#endif
      0.1,   // ici ???
      /*do_urlfile*/ true, /*do_link_printf*/ true, /*do_log_printf*/ false, 
      /*log_file*/ ( (gDebug>1) ? (use_sd ? "/sd/httpd.log" : "/local/httpd.log") : NULL)
    ));    // Should be the first handler to get a preview of all requests
    //  fin du ici ?? 
    
    http.addHandler(new HTTPRPC());// on y trouve d'autres choses a faire
    led2=0;   // 

    // Static/Dynamic pages must be installed before FileSystem on /
    http.addHandler(new HTTPStaticPage("/static.htm", tab, strlen(tab)));   // ma page statique en ram
 // http.addHandler(new HTTPDynamicPage("/dynamic.htm", &myDynamicPage));   avant
    http.addHandler(new HTTPled("/led.htm", led , strlen(tab)));  /// test
    http.addHandler(new HTTPFileSystemHandler("/", use_sd ? "/sd/" : "/local/"));
    led3=0;

// FIXME: BUG If eth is not plugged, http.bind() hangs!
    http.bind();
    SNTPClientInit();
    led4 = 0;
   // pc.printf("\r");    // Add linefeed for stupid Hyperterminal
    
    while(1) {  //BOUCLE POLL
        http.poll();    // Have to call this method at least every 250ms to let the http server run.      
        wait(gWait);
        
       ana = Potm.read();   //  travail en temps reel like ( gWait)
       lcd.locate(0,2); //ligne 2 lcd 
       ana = 3.2*ana;   // mise au niveau 3v2
              lcd.printf("Value: %1.2f", ana);
              sprintf(res, "%f", ana);  // met ana en chaine dans res[]
         pt = 127 ; //point dans l'affichage a faire
        tab[pt+0] = res[0]; // met 5 char de la chaine a dans static.htm
        tab[pt+1] = res[1];
        tab[pt+2] = res[2];
        tab[pt+3] = res[3];  
        tab[pt+4] = res[4];  
        
  
    }
}

//END