#ifndef HTTPLED_H
#define HTTPLED_H

#include "HTTPServer.h"

 //  inspiration de staticpage , mais pour interagir avec la carte 
//   on agit sur les e/s de la carte mbed , on finit en retournant une page  vide qui repointe en static 
class HTTPledData : public HTTPData {
  public: int left;  };

/**
 * This class Provide a Handler to send Static HTTP Pages from the bin file.
 */
class HTTPled : public HTTPHandler {
  public:
    /**
     * Constructer takes the pagename and the pagedata.
     * As long as the pagedata is NULL terminated you have not to tell the data length.
     * But if you want to send binary data you should tell us the size.
     */
  
    HTTPled(const char *path, const char *page, int length = 0)
     : HTTPHandler(path), _page(page) {
      _size = (length)?length:strlen(_page);
    }

    HTTPled(HTTPServer *server, const char *path, const char *page, int length = 0)
     : HTTPHandler(path), _page(page) {
      _size = (length)?length:strlen(_page);
      server->addHandler(this);
    }

  private:
    /**
     * A this Static Page is requested!
     * Prepare a datastorage helper "HTTPledHelper" to store the left data size.
     * And return HTTP_OK
     */
    virtual HTTPStatus init(HTTPConnection *con) const {
      HTTPledData *data = new HTTPledData();
      con->data = data;
      data->left = _size;
      con->setLength(_size);
      return HTTP_OK;
    }

    /**
     * Send the maximum data out to the client. 
     * If the file is complete transmitted close connection by returning HTTP_SuccessEnded
     */
    virtual HTTPHandle send(HTTPConnection *con, int maximum) const {
      HTTPledData *data = static_cast<HTTPledData *>(con->data);
      int len = min(maximum, data->left);
      err_t err;
      led5 = !led5;               // la on fait du travail sur les e/s
      do {
        err = con->write((void*)&_page[_size - data->left], len, 1);
        if(err == ERR_MEM) {
          len >>= 1;
        }
      } while(err == ERR_MEM && len > 1);
      if(err == ERR_OK) {
        data->left -= len;
      }
      return (data->left)? HTTP_Success : HTTP_SuccessEnded;
    }

    /** Pointer to the page data */
    const char *_page;
    
    /** page data size*/
    int   _size;
};

#endif
