// original Written by IVA2K  
//
// Example of HTTPServer with additional features:
// * SNTP Client (Simple NTP)
// * Link status indication (LED4 or RJ45 socket LED on MBED-BoB2-mod)
// * Local file system (create index.htm page on MBED!)
// * SD-based WebServer
// * Static HTML page
// * Dynamic HTML page
// modification fron LRSD  from the pub-iva2k-ethsntp  project
//  i am not a specialist , stil bugs , but that works 
// Instructions:
// 2  Plug ETH connector into your network(with a switch for direct  pc, needs DHCP to get IP address and Internet connection)
// 3  Plug MBED using USB cable
// 4  need to have Installed MBED serial driver (http://mbed.org/handbook/SerialPC)
// 5  Copy compiled .bin to your MBED (make sure target device selected in the compiler is correct)
// 6  Open terminal on the mbed serial port
// 7  Push MBED reset button
// 8  Terminal will display info message with mac address, followed by IP address 
//    in the following items, i put  192.168.1.77  line 144 : IPv4(192,168,1,77),
// 9  Open browser and enter the following URL:
//    http://192,168,1,77 /
//        !!
// 13 Open browser and enter the following URL:
//    http://192.168.1.77/static.htm
// 14 The browser will show static HTML page
// 15 Open browser and enter the following URL:
//    http://192,168,1,77/dynamic.htm
// 16 The browser will show dynamic HTML page
// 17 Create a simple index.htm page on the MBED
// 18 Open browser and enter the following URL:
//    http://192,168,1,77
// 19 The browser will show index HTM page  not HTML! ( 3 char extension , no directorie)
// 20 Create a simple index.htm page on a micro SD card, plug the card into MBED-BoB2
// 22 The browser will show index HTM page from SD card
// 23 Optionally, create file "sntp.ini" on MBED or SD card. Copy-paste SNTP configuration from the terminal into this file and modify to your needs.
//
int aip4,aip3,aip2,aip1;
#include "mbed.h"
#include "NewTextLCD.h"
#include "SDFileSystem.h"
#include "HTTPServer.h"
#include "HTTPFS.h"
#include "HTTPStaticPage.h"
#include "HTTPDynamicPage.h"
#include "HTTPLinkStatus.h"
#include "SNTPClient.h"
#define CLS "\033[2J"



AnalogIn Potm(p15); //var. resistor
TextLCD lcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4); // rs, rw, e, d4-d7

#define MAX_DYNAMIC_CONTENT_LEN     2048    // a finir
char dynamic_content[MAX_DYNAMIC_CONTENT_LEN];

const char content_fmt[] = 
"<HTML>"
"<HEAD>"
"<title>Dynamic Page</title>"
"</HEAD>"
"<BODY>"  //
"<H1>Helo                      World</H1>"              // "<H1>Hello World</H1>"               
"<p>Page generated dynamically from code.</p>"
"<p>URL=%s</p>"
"<p>Header Fields=%s</p>"
"</BODY></HTML>"
;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
DigitalIn sw1(p9, "sw1");
DigitalIn sw2(p10, "sw2");
LocalFileSystem local("local");
SDFileSystem sd(p11, p12, p13, p14, "sd");        // MBED-BoB2


extern Ethernet eth;        // eth is defined elsewhere, avoid compiler error.
Serial pc(USBTX, USBRX);
int gDebug=1;
float ana = 1.0;
float gWait = 0.05;        // Main loop wait timeout



HTTPStatus myDynamicPage(HTTPConnection *con, HTTPDynamicPageData *pd) {
#if 0
    // Static example. With this, we don't really need HTTPStaticPage
    pd->size = 0;    // let it measure our page
    pd->page = (char*)content; // Nothing dynamic about that yet, but we can now get loose here.
    pd->page_free = NULL;      // No mem free() needed
#elif 0
    // Dynamic example, static buffer
    pd->size = sprintf(dynamic_content, content_fmt, con->getURL(), con->getHeaderFields());
    pd->page = (char*)dynamic_content;
    pd->page_free = NULL;    // No mem free() needed
if(pd->size > sizeof(dynamic_content)) printf("ASSERTION FAILED: %s:%d\r\n", __FILE__, __LINE__);    // Buffer overrun
#else
    // Dynamic example, dynamic buffer
    int size = sizeof(content_fmt) + 512;    // Just guess how much the data will expand
    char *buf = (char *)malloc(size);
    if (buf) {
        pd->size = sprintf(buf, content_fmt, con->getURL(), con->getHeaderFields());
        pd->page = buf;
        pd->page_free = &free;    // Use free() when done
if(pd->size > size) printf("ASSERTION FAILED: %s:%d\r\n", __FILE__, __LINE__);    // Buffer overrun
#endif
    }
    return HTTP_OK;
}
//*******************************************MAIN***************************
//****************************************************************************   
    int main(void)
     {
    lcd.cls();
    pc.baud(115200);
    lcd.printf("LRSD web SERVER .!.\n");
    printf("LRSD  debout  !!\n");
    char tab[] =                // ce tableau est mis en ram
        "<HTML>"                // il stock un fichier htm , qui sera r crit dans BOUCLE POLL 
        "<HEAD>"
        "<title>Static Page</title>"
        "</HEAD>"
        "<BODY>"                         //V  le v pointe en dessous le lieu  
        "<H1> tension sur le potentiomtre=       volt </H1>"  // lieu de l'insertion
        "</BODY></HTML>";
    char mac[6];
    bool use_sd = false;
    char res[10]= "1234000";
    int  pt = 85;
    led1=1;
    led2=1;
    led3=1;
    led4=1;

    // Start RTC
    time_t seconds = time(NULL);
    if (seconds == (unsigned)-1 || seconds == 0) {
      seconds = 1256729737;     // Set RTC time to Wed, 28 Oct 2009 11:35:37
      set_time(seconds);
      printf("RTC initialized, start time %d seconds\r\n", seconds);
    }
    aip4 = 192; aip3 = 168 ; aip2 = 1 ; aip1 = 77;  // pour plus tard les changer par le clavier 
    lcd.locate(0,1); 
    lcd.printf("IP:%hhu.%hhu.%hhu.%hhu\n",                  
                  aip4, aip3, aip2, aip1); 
     HTTPServer http("mbed",                  //  static IP address and domain name.
                 IPv4(aip4,aip3,aip2,aip1),   // IPv4 is a helper function which allows to rtype ipaddresses direct
                 IPv4(255,255,0,0),        
                 IPv4(192,168,1,0),        
                 IPv4(192,168,1,0),   
                   80);             // port 80 gnralement  
    char *hostname = "mbed";
   // HTTPServer http(hostname);    // Use DHCP
    http.timeout(10000);    // Sets the timout for a HTTP request.  The timout is the time which is allowed to spent between two incomming TCP packets.  If the time is passed the connection will be closed.
   
    eth.address(mac);
    pc.printf(CLS "\r\n\r\nHTTPServer \"%s\" started\r\nMAC %02X:%02X:%02X:%02X:%02X:%02X\r\n%s",
        hostname, mac[0], mac[1], mac[2], mac[3], mac[4], mac[5],
        gDebug?"Debug is ON\r\n":""
    );


    //

    // Check if we can use SD card for the web server
    FILE *fp = fopen("/sd/index.htm", "r");
    if (fp == NULL) {
        if (gDebug) printf("DEBUG: No SD card found or no index.htm file - using LocalFilesystem for WebServer.\r\n");
    } else {
        use_sd = true;
        fclose(fp);
        if (gDebug) printf("DEBUG: Found SD card with index.htm file - using SD for WebServer.\r\n");
    }

    if (0 != SNTPReadIniFile("/sd/sntp.ini") )
        SNTPReadIniFile("/local/sntp.ini");
    SNTPWriteIniFile(stdout);


    http.addHandler(new HTTPLinkStatus("/", 
#if MBED_BOB2
      p25, p26,            // MBED-BoB2-mods
#else
      LED3, LED4,
#endif
      0.1,
      /*do_urlfile*/ true, /*do_link_printf*/ true, /*do_log_printf*/ false, 
      /*log_file*/ ( (gDebug>1) ? (use_sd ? "/sd/httpd.log" : "/local/httpd.log") : NULL)
    ));    // Should be the first handler to get a preview of all requests
    led2=0;

    // Static/Dynamic pages must be installed before FileSystem on /
  //  http.addHandler(new HTTPStaticPage("/static.htm", content, strlen(content)));  // moi
        http.addHandler(new HTTPStaticPage("/static.htm", tab, strlen(tab)));
    http.addHandler(new HTTPDynamicPage("/dynamic.htm", &myDynamicPage));
    http.addHandler(new HTTPFileSystemHandler("/", use_sd ? "/sd/" : "/local/"));
    led3=0;

// FIXME: BUG If eth is not plugged, http.bind() hangs!
    http.bind();

    SNTPClientInit();
    led4 = 0;
   // pc.printf("\r");    // Add linefeed for stupid Hyperterminal
    
    while(1) {  //BOUCLE POLL
        http.poll();    // Have to call this method at least every 250ms to let the http server run.      
        wait(gWait);
        
       ana = Potm.read();   // mon travail en temps reel like ( gWait)
       lcd.locate(0,2); //ligne 2 lcd 
       ana = 3.2*ana; // mise au niveau 3v2
              lcd.printf("Value: %1.2f", ana);
              sprintf(res, "%f", ana);  // met ana en chaine dans res[]
      // pt = pt +1 ; // change le pointage dans la ligne htm au cas ou 
        tab[pt+1] = res[0]; // met 4 char de la chaine 
        tab[pt+2] = res[1];
        tab[pt+3] = res[2];
        tab[pt+4] = res[3];       
    }
}

//END