#include "mbed.h"
#include "Servo.h"
#include "ESP8266.h"
#include "math.h"
#define CloudIP "184.106.153.149"           //Raw IP Address of ThingSpeak Cloud Server

DigitalOut RLed(LED1);                      //when Garage has no spot for parking
DigitalOut GLed(LED2);                      //when Garage has spot available
DigitalOut BLed(LED3);                      //Onboard Blue LED for Wifi Tx Indication

ESP8266 wifi(PTC17, PTC16, 9600);         //Tx Pin:PTC17; Rx Pin:PTC17; Baud rate:115200
DigitalIn  IR1(A0);
DigitalIn IR2(A1);
DigitalIn IR3(A2);
DigitalIn GS(A3);
Servo myservo(D7);
void wifi_send(void);             //Connect and Push Data Channel to Cloud Server
int f_out= 3;                      //variable to count for no of slots available
int num = 0;
int open = 1 ;
char snd[255],rcv[1000];                    //snd: send command to ESP8266
//rcv: receive response from ESP8266
int main()
{ 
    printf("WELCOME TO PARKING SYSTEM\n\r");
    printf("Cloud synchronization number : %d", num);
    printf("Syncing Data with Cloud, Please Wait.\n\r");  
    printf("Initial Setup\r\n");
    wifi.SetMode(1);                        //Set ESP mode to 1
    wifi.RcvReply(rcv, 1000);               //Receive a response from ESP
    printf("%s\r", rcv);

    printf("Conneting to WiFi\r\n");     //AP Setup Initialization
    wifi.Join("Kuch Bhi Daal Do", "paiselagenge");   //wifi address details
    wifi.RcvReply(rcv, 1000);
    printf("%s\n", rcv);
    wait(8);

    wifi.GetIP(rcv);                        //Obtains an IP address from the AP

    while (1) {
        wifi_send();

        RLed = 1;
        GLed = 1;
        BLed = 0;
        wait(2.0f);
    }
}

void wifi_send(void)
{ 
    while(num<1000000000000) {
        num=num + 1;
        
        GLed=0;
        BLed=1;

        
    
        if(GS==0) {
            printf("Car is available at parking entrance..checking for slot availability\n\r");
            if(IR1==0 && IR2==0 && IR3==0) {
                printf("Parking full try next garage..\n\r");
                open=0;
                RLed=0;
                GLed=1;
                f_out = 0;
            } else if (IR1==0 && IR2==0 && IR3==1) {
                printf(" 1 spot available at slot 3\n\r");
                f_out = 1;
            } else if (IR1==0 && IR2==1 && IR3==0) {
                printf(" 1 spot avaialble at slot 2\n\r");
                f_out = 1;
            } else if (IR1==0 && IR2==1 && IR3==1) {
                printf("Two spots available at slot 2 and 3\n\r");
                f_out = 2;
            } else if (IR1==1 && IR2==0 && IR3==0) {
                printf("One spot available at slot 1\n\r");
                f_out = 1;
            } else if (IR1==1 && IR2==0 && IR3==1) {
                printf("Two spot avaialble at slot 1 and 3\n\r");
                f_out = 2;
            } else if (IR1==1 && IR2==1 && IR3==0) {
                printf("Two spot avaialble at slot 1 and 2\n\r");
                f_out = 2;
            } else if (IR1==1 && IR2==1 && IR3==1) {
                printf("Garage Empty\n\r");
                f_out = 3;
            }
          
            if(open == 1) {
                for(int i=0; i<100; i++) {
                    myservo = i/100.0;
                    wait(0.01);
                }
                for(int i=100; i>0; i--) {
                    myservo = i/100.0;
                    wait(0.01);
                }
            }
            }
             else
                printf("No car to enter\n\r");

            //Sending Data to the Cloud Server via ESP8266 WiFi Module
            strcpy(snd,"AT+CIPMUX=0\n\r");        //AT+CIPMUX: Enabling Single Channel Mode
            wifi.SendCMD(snd);
            wait(1);
            wifi.RcvReply(rcv, 1000);
            wait(1);

            sprintf(snd,"AT+CIPSTART=4,\"TCP\",\"%s\",80\n",CloudIP); //Establish TCP connection w/ Cloud Server
            wait(1);
            wifi.RcvReply(rcv, 1000);
            wait(1);

            strcpy(snd,"AT+CIPSEND=100\n\r");    //Set length of the data that will be sent
            wifi.SendCMD(snd);
            printf("%s\r", rcv);
            wait(1);
            wifi.RcvReply(rcv, 1000);
            printf("%s\r", rcv);
            wait(1);

            //   Pushing the data to Cloud Server via API
            sprintf(snd,"GET https://api.thingspeak.com/update?api_key=M2RJX3971TCLP0S7&field1=%d\n\r", f_out);
            wifi.SendCMD(snd);
            printf("%s\r",snd);
            wait(1);
            wifi.RcvReply(rcv, 1000);
            printf("%s\r", rcv);
        }
    }
