#include "mbed.h"
#include "ESP8266.h"               // Include header file from Author: Antonio Quevedo
#include "math.h"
#include <string>
#include "DHT.h"

#define APIKEY OF2O1FTK5UNXYWO8    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "WiFi"
#define WIFI_PASS "b5c7f638"

//Board Pinouts******************
DigitalOut heater(D2); //Defining heater pin
DHT sensor(D4, DHT11); //defining temperature sensor
//*******************************

Serial pc(USBTX,USBRX);

ESP8266 esp(PTC17, PTC16, 115200); // baud rate for wifi

char snd[255],rcv[1000],snd_Data[255];           //snd= string used to send command to ESP 8266 wii and  rcv = string used to receive response from ESP8266 wifi module 

float temperature = 0.0f;


void esp_initialize(void); // Function used to initialize ESP8266 wifi module 
void esp_send(void);       // Function used to connect with thingspeak.com and update channel using ESP8266 wifi module 

//test variable 
float i=0;
float j=10;
  

int main() 
{
    
    pc.baud(115200);           // Baud rate used for communicating with Tera-term on PC
    
    pc.printf("START\r\n");  // Starting point
    
    int error = 0;
    
    esp_initialize();

    while(1) {
        
        
        wait(2.0f);
        error = sensor.readData(); //read sensor for error
        if (0 == error) {
            temperature   = sensor.ReadTemperature(CELCIUS);
            printf("Temperature in Celcius: %4.2f\n", temperature);
        } 
        else {
            printf("Error: %d\n", error);
        }
        
        if (temperature > 24.00) {
            heater = 1;
            printf("Heater is OFF\n");
        }
        else {
            heater = 0;
            printf("Heater is ON\n");
        }  

        wait(3);
        esp_send(); 
        i++;
        j--;
        
    }
}


void esp_initialize(void)
{    
    pc.printf("Initializing ESP\r\n"); 
      
    pc.printf("Reset ESP\r\n"); 
    esp.Reset();                   //RESET ESP
    esp.RcvReply(rcv, 400);        //receive a response from ESP
    //pc.printf(rcv);          //Print the response onscreen 
    wait(2);
    
    strcpy(snd,"AT");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf(rcv);      
    wait(0.1);
    
    strcpy(snd,"AT+CWMODE=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(2);

    strcpy(snd,"AT+CWJAP=\"");
    strcat(snd,WIFI_SSID);
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);
    strcat(snd,"\"");
    
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(5);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
    
    strcpy(snd,"AT+CIPMUX=0");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 

}


void esp_send(void)
{
   
    //ESP updates the Status of Thingspeak channel//
    
    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");
    
    esp.SendCMD(snd); 
    pc.printf("S\r\n%s",snd);
    //wait(2);                                                    
    esp.RcvReply(rcv, 1000);
    pc.printf("R\r\n%s",rcv);
    wait(1);
    
    sprintf(snd,"GET https://api.thingspeak.com/update?key=OF2O1FTK5UNXYWO8&field1=%f&field2=%f\r\n",temperature,heater);
    
    int i=0;
    for(i=0;snd[i]!='\0';i++);
    i++;
    char cmd[255];
    
    sprintf(cmd,"AT+CIPSEND=%d",i);                                       //Send Number of open connection and Characters to send 
    esp.SendCMD(cmd);
    pc.printf("S\r\n%s",cmd);
    while(i<=20 || rcv == ">")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    
    esp.SendCMD(snd);                                                      //Post value to thingspeak channel
    pc.printf("S\r\n%s",snd);
    
    while(i<=20 || rcv == "OK")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    
}
