#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832.h"
#include "Websocket.h"
#include "MMA7660.h"
#include "LM75B.h"

// accelerometer
MMA7660 acc(p28, p27);

// temperature sensor
LM75B tmp(p28,p27);

// rgb led
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

// lcd
C12832 lcd(p5, p7, p6, p8, p11);

// speaker
DigitalIn fire(p14);
PwmOut spkr(p26);

// led
DigitalOut l1(LED1);
 
int main() {
    char json_str[100];
    
    for(float i = 0.0; i < 1.0 ; i += 0.001) {
            float p = 3 * i;
            r = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
            g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
            b = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;  
            wait (0.01);
        }
    
    if (acc.testConnection())
        l1 = 1;
 
    EthernetInterface eth;
    eth.init(); //Use DHCP
    wait(2);
    eth.connect(60000);
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    // See the output on http://sockets.mbed.org/app-board/viewer
    // you need to specify a channel! otherwise this shit won't work!
    // "the /ws is important!"
    Websocket ws("ws://192.168.0.101:8001/ws");
    ws.connect();
    char recv[50];
    lcd.printf("SF1 Dev Week, here we go!");
    ws.send(json_str);
    while (1) {
        // create json string with acc/tmp data
        //sprintf(json_str, "{\"id\":\"geekymartianboard\",\"ax\":%d,\"ay\":%d,\"az\":%d, \"tmp\":%d}", (int)(acc.x()*360), (int)(acc.y()*360), (int)(acc.z()*360), (int)tmp.read());
        
        // send str
        //ws.send(json_str);
        
        wait(5.0);
        
        if(ws.read(recv)) {
            printf(recv);
            lcd.printf("Received a message:\n");
            lcd.printf(recv);
            
            for (float i=2000.0; i<10000.0; i+=100) {
                spkr.period(1.0/i);
                spkr=0.5;
                wait(0.1);
            }
            spkr=0.0;
            while(!fire) {}
            
        }
    }
}